/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.util.logging.Level;
import net.sf.jaxodraw.logging.JaxoDefaultLogger;
import net.sf.jaxodraw.logging.JaxoLogger;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;

public final class JaxoLog {
    public static final int DEBUG = Level.FINE.intValue();
    public static final int INFO = Level.INFO.intValue();
    public static final int WARN = Level.WARNING.intValue();
    private static JaxoLogger logger = new JaxoDefaultLogger(JaxoInfo.LOG_DIR);

    private JaxoLog() {
    }

    public static JaxoLogger getLogger() {
        return logger;
    }

    public static void setLogger(JaxoLogger newLogger) {
        logger = newLogger == null ? new DevNullLogger() : newLogger;
    }

    public static void setLevel(int level) {
        logger.setLevel(JaxoLog.getLevelFor(level));
    }

    public static int getCurrentLevel() {
        return logger.getLevel().intValue();
    }

    public static boolean isLoggable(int level) {
        return logger.isLoggable(JaxoLog.getLevelFor(level));
    }

    public static void debug(String message) {
        JaxoLog.log(Level.FINE, message, null);
    }

    public static void debugI18N(String messageKey) {
        JaxoLog.logI18N(Level.FINE, messageKey, null);
    }

    public static void debug(String message, Exception e) {
        JaxoLog.log(Level.FINE, message, e);
    }

    public static void debugI18N(String messageKey, Exception e) {
        JaxoLog.logI18N(Level.FINE, messageKey, e);
    }

    public static void debug(Exception e) {
        JaxoLog.log(Level.FINE, null, e);
    }

    public static void info(String message) {
        JaxoLog.log(Level.INFO, message, null);
    }

    public static void infoI18N(String messageKey) {
        JaxoLog.logI18N(Level.INFO, messageKey, null);
    }

    public static void info(String message, Exception e) {
        JaxoLog.log(Level.INFO, message, e);
    }

    public static void infoI18N(String messageKey, Exception e) {
        JaxoLog.logI18N(Level.INFO, messageKey, e);
    }

    public static void info(Exception e) {
        JaxoLog.log(Level.INFO, null, e);
    }

    public static void warn(String message) {
        JaxoLog.log(Level.WARNING, message, null);
    }

    public static void warnI18N(String messageKey) {
        JaxoLog.logI18N(Level.WARNING, messageKey, null);
    }

    public static void warn(String message, Exception e) {
        JaxoLog.log(Level.WARNING, message, e);
    }

    public static void warnI18N(String messageKey, Exception e) {
        JaxoLog.logI18N(Level.WARNING, messageKey, e);
    }

    public static void warn(Exception e) {
        JaxoLog.log(Level.WARNING, null, e);
    }

    public static void log(int level, String message) {
        JaxoLog.log(JaxoLog.getLevelFor(level), message, null);
    }

    public static void logI18N(int level, String messageKey) {
        JaxoLog.logI18N(JaxoLog.getLevelFor(level), messageKey, null);
    }

    public static void log(int level, String message, Exception e) {
        JaxoLog.log(JaxoLog.getLevelFor(level), message, e);
    }

    public static void logI18N(int level, String messageKey, Exception e) {
        JaxoLog.logI18N(JaxoLog.getLevelFor(level), messageKey, e);
    }

    public static void log(int level, Exception e) {
        JaxoLog.log(JaxoLog.getLevelFor(level), null, e);
    }

    public static Level getLevelFor(int level) {
        Level newLevel = null;
        newLevel = level < INFO ? Level.FINE : (level < WARN ? Level.INFO : Level.WARNING);
        return newLevel;
    }

    private static void log(Level level, String message, Exception e) {
        logger.log(level, message, e);
    }

    private static void logI18N(Level level, String messageKey, Exception e) {
        JaxoLog.log(level, JaxoLanguage.translate(messageKey), e);
    }

    private static class DevNullLogger
    implements JaxoLogger {
        private DevNullLogger() {
        }

        public void setLevel(Level level) {
        }

        public Level getLevel() {
            return Level.OFF;
        }

        public boolean isLoggable(Level level) {
            return false;
        }

        public void log(Level level, String message, Throwable e) {
        }
    }
}

