/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxoPrefs {
    public static final String PREF_BROWSER = "prefBROWSER";
    public static final String PREF_EDITOR = "prefEDITOR";
    public static final String PREF_PSVIEWER = "prefPSVIEWER";
    public static final String PREF_LOOKNFEEL = "prefLOOKNFEEL";
    public static final String PREF_LANGUAGE = "prefLANGUAGE";
    public static final String PREF_GRIDTYPE = "prefGRIDTYPE";
    public static final String PREF_COLOR = "prefCOLOR";
    public static final String PREF_PSFAMILY = "prefPSFAMILY";
    public static final String PREF_TEXTCOLOR = "prefTEXTCOLOR";
    public static final String PREF_LATEXPATH = "prefLATEXPATH";
    public static final String PREF_DVIPSPATH = "prefDVIPSPATH";
    public static final String PREF_CANVASBACKGROUND = "prefCANVASBACKGROUND";
    public static final String PREF_VERSION = "prefVERSION";
    public static final String PREF_GRIDCOLOR = "prefGRIDCOLOR";
    public static final String PREF_USER_DIR = "prefUSERDIR";
    public static final String PREF_SCREENSIZEX = "prefSCREENSIZEX";
    public static final String PREF_SCREENSIZEY = "prefSCREENSIZEY";
    public static final String PREF_GRIDSIZE = "prefGRIDSIZE";
    public static final String PREF_AMPLITUDE = "prefAMPLITUDE";
    public static final String PREF_PSSTYLE = "prefPSSTYLE";
    public static final String PREF_PSSIZE = "prefPSSIZE";
    public static final String PREF_TEXSIZE = "prefTEXSIZE";
    public static final String PREF_TEXALIGN = "prefTEXALIGN";
    public static final String PREF_PSROTANGLE = "prefPSROTANGLE";
    public static final String PREF_TEXROTANGLE = "prefTEXROTANGLE";
    public static final String PREF_DEFAULTACTION = "prefDEFAULTACTION";
    public static final String PREF_UNDODEPTH = "prefUNDODEPTH";
    public static final String PREF_COLORSPACE = "prefCOLORSPACE";
    public static final String PREF_GRIDSTYLE = "prefGRIDSTYLE";
    public static final String PREF_VERTEXSIZE = "prefVERTEXSIZE";
    public static final String PREF_LINEWIDTH = "prefLINEWIDTH";
    public static final String PREF_DLSEP = "prefDLSEP";
    public static final String PREF_ARROWPOSITION = "prefARROWPOSITION";
    public static final String PREF_ARROWLENGTH = "prefARROWLENGTH";
    public static final String PREF_ARROWWIDTH = "prefARROWWIDTH";
    public static final String PREF_ARROWINSET = "prefARROWINSET";
    public static final String PREF_SHOWTOOL = "prefSHOWTOOL";
    public static final String PREF_SHOWSTATUS = "prefSHOWSTATUS";
    public static final String PREF_ANTIALIAS = "prefANTIALIAS";
    public static final String PREF_ARROW = "prefARROW";
    public static final String PREF_GRIDONOFF = "prefGRIDONOFF";
    public static final String PREF_SNAPONOFF = "prefSNAPONOFF";
    public static final String PREF_SHOWGRIDBAR = "prefSHOWGRIDBAR";
    public static final String PREF_SHOWSPLASHWINDOW = "prefSHOWSPLASHWINDOW";
    private static final Preference[] PREFERENCES;
    private static final Preferences PREFS;
    private static final Map<String, Preference> NAME_TO_PREFERENCE;
    private static final Map<String, Object> VALUES;
    public static final int MAX_RECENT_FILES = 10;
    private static String[] recentKEYS;
    private static String[] recentFile;

    private JaxoPrefs() {
    }

    public static String[] getRecentFiles() {
        String[] copy = new String[recentFile.length];
        System.arraycopy(recentFile, 0, copy, 0, recentFile.length);
        return copy;
    }

    public static void setRecentFiles(String[] filePaths) {
        JaxoPrefs.clearRecentFiles();
        for (int i = 0; i < filePaths.length; ++i) {
            String rf = filePaths[i];
            JaxoPrefs.recentFile[i] = rf == null ? "" : rf;
        }
    }

    public static void clearRecentFiles() {
        for (int i = 0; i < 10; ++i) {
            JaxoPrefs.recentFile[i] = "";
        }
    }

    public static void addRecentFile(String st) {
        int i;
        for (i = 0; i < 10; ++i) {
            if (!"".equals(recentFile[i])) continue;
            JaxoPrefs.recentFile[i] = st;
            break;
        }
        if (i == 10) {
            System.arraycopy(recentFile, 1, recentFile, 0, recentFile.length - 1);
            JaxoPrefs.recentFile[9] = st;
        }
    }

    public static String getStringPref(String name) {
        if (JaxoPrefs.hasType(name, String.class)) {
            return (String)VALUES.get(name);
        }
        throw new IllegalArgumentException("Not String Pref: " + name);
    }

    public static int getIntPref(String name) {
        if (JaxoPrefs.hasType(name, Integer.TYPE)) {
            return (Integer)VALUES.get(name);
        }
        throw new IllegalArgumentException("Not int Pref: " + name);
    }

    public static float getFloatPref(String name) {
        if (JaxoPrefs.hasType(name, Float.TYPE)) {
            return ((Float)VALUES.get(name)).floatValue();
        }
        throw new IllegalArgumentException("Not float Pref: " + name);
    }

    public static boolean getBooleanPref(String name) {
        if (JaxoPrefs.hasType(name, Boolean.TYPE)) {
            return Boolean.TRUE.equals(VALUES.get(name));
        }
        throw new IllegalArgumentException("Not boolean Pref: " + name);
    }

    public static void setStringPref(String name, String str) {
        JaxoPrefs.setPref(name, str);
    }

    public static void setIntPref(String name, int newPref) {
        JaxoPrefs.setPref(name, newPref);
    }

    public static void setFloatPref(String name, float newPref) {
        JaxoPrefs.setPref(name, Float.valueOf(newPref));
    }

    public static void setBooleanPref(String name, boolean newPref) {
        JaxoPrefs.setPref(name, newPref);
    }

    public static Map<String, Object> getState() {
        return new HashMap<String, Object>(VALUES);
    }

    public static void setState(Map<String, Object> value) {
        for (int i = 0; i < PREFERENCES.length; ++i) {
            JaxoPrefs.setPref(PREFERENCES[i].getName(), value.get(PREFERENCES[i].getName()));
        }
    }

    public static void initSessionPrefs() {
        Preferences legacy = Preferences.userRoot().node(JaxoInfo.USER_HOME);
        JaxoPrefs.setPrefsFrom(legacy);
        JaxoPrefs.setPrefsFrom(PREFS);
        JaxoPrefs.resetPref(PREF_USER_DIR);
        JaxoPrefs.setStringPref(PREF_VERSION, PREFS.get(PREF_VERSION, "1.3"));
        if (!JaxoPrefs.getStringPref(PREF_VERSION).equals("1.4")) {
            JaxoPrefs.upgradePreferences();
            JaxoPrefs.setStringPref(PREF_VERSION, "1.4");
        }
    }

    private static void setPrefsFrom(Preferences p) {
        int j;
        for (j = 0; j < PREFERENCES.length; ++j) {
            JaxoPrefs.setPrefFromString(PREFERENCES[j].getName(), p.get(PREFERENCES[j].getName(), PREFERENCES[j].getDefaultValue().toString()));
        }
        for (j = 0; j < 10; ++j) {
            JaxoPrefs.recentFile[j] = p.get(recentKEYS[j], recentFile[j]);
        }
    }

    public static void resetPref(String name) {
        Preference p = NAME_TO_PREFERENCE.get(name);
        JaxoPrefs.setPref(name, p.getDefaultValue());
    }

    public static void savePrefs() {
        int j;
        for (j = 0; j < PREFERENCES.length; ++j) {
            PREFS.put(PREFERENCES[j].getName(), VALUES.get(PREFERENCES[j].getName()).toString());
        }
        for (j = 0; j < 10; ++j) {
            PREFS.put(recentKEYS[j], recentFile[j]);
        }
    }

    public static void saveRecentFiles() {
        for (int j = 0; j < 10; ++j) {
            PREFS.put(recentKEYS[j], recentFile[j]);
        }
    }

    private static boolean hasType(String name, Class<?> type) {
        Preference p = NAME_TO_PREFERENCE.get(name);
        return p != null && p.getType() == type;
    }

    private static void upgradePreferences() {
        String lookAndFeel = JaxoPrefs.getStringPref(PREF_LOOKNFEEL);
        if ("Metal".equals(lookAndFeel)) {
            lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else if ("CDE/Motif".equals(lookAndFeel)) {
            lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else if ("Windows".equals(lookAndFeel)) {
            lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if ("Windows Classic".equals(lookAndFeel)) {
            lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
        } else if ("Mac OS X".equals(lookAndFeel)) {
            lookAndFeel = "apple.laf.AquaLookAndFeel";
        } else if ("GTK".equals(lookAndFeel) || "GTK+".equals(lookAndFeel)) {
            lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
        }
        JaxoPrefs.setStringPref(PREF_LOOKNFEEL, lookAndFeel);
    }

    private static void setPrefFromString(String name, String value) {
        Preference p = NAME_TO_PREFERENCE.get(name);
        if (p.getType() == String.class) {
            JaxoPrefs.setPref(name, value);
        } else if (p.getType() == Integer.TYPE) {
            JaxoPrefs.setPref(name, Integer.valueOf(value));
        } else if (p.getType() == Float.TYPE) {
            JaxoPrefs.setPref(name, Float.valueOf(value));
        } else if (p.getType() == Boolean.TYPE) {
            JaxoPrefs.setPref(name, Boolean.valueOf(value));
        }
    }

    private static void setPref(String name, Object value) {
        if (name.equals(PREF_LANGUAGE)) {
            Object old = VALUES.get(name);
            VALUES.put(name, value);
            if (old == null ? value != null : !old.equals(value)) {
                JaxoLanguage.languageChanged(JaxoPrefs.getStringPref(PREF_LANGUAGE));
            }
        } else {
            VALUES.put(name, value);
        }
    }

    static {
        int i;
        PREFS = Preferences.userNodeForPackage(JaxoPrefs.class);
        String black = JaxoColor.getColorName(JaxoColor.BLACK);
        String workingDir = System.getProperty("exec.workingdir");
        String userDir = workingDir == null ? System.getProperty("user.dir") : workingDir;
        PREFERENCES = new Preference[]{new Preference(PREF_BROWSER, ""), new Preference(PREF_EDITOR, ""), new Preference(PREF_PSVIEWER, ""), new Preference(PREF_LOOKNFEEL, "javax.swing.plaf.metal.MetalLookAndFeel"), new Preference(PREF_LANGUAGE, "english"), new Preference(PREF_GRIDTYPE, "rectangular"), new Preference(PREF_COLOR, black), new Preference(PREF_PSFAMILY, "Default"), new Preference(PREF_TEXTCOLOR, black), new Preference(PREF_LATEXPATH, "latex"), new Preference(PREF_DVIPSPATH, "dvips"), new Preference(PREF_CANVASBACKGROUND, "r255g255b255"), new Preference(PREF_VERSION, "1.4"), new Preference(PREF_GRIDCOLOR, black), new Preference(PREF_USER_DIR, userDir), new Preference(PREF_DEFAULTACTION, 6201), new Preference(PREF_UNDODEPTH, 20), new Preference(PREF_COLORSPACE, 2), new Preference(PREF_GRIDSTYLE, 0), new Preference(PREF_VERTEXSIZE, 0), new Preference(PREF_SCREENSIZEX, 800), new Preference(PREF_SCREENSIZEY, 600), new Preference(PREF_GRIDSIZE, 16), new Preference(PREF_AMPLITUDE, 15), new Preference(PREF_PSSTYLE, 2), new Preference(PREF_PSSIZE, 18), new Preference(PREF_TEXSIZE, 6), new Preference(PREF_TEXALIGN, 2), new Preference(PREF_PSROTANGLE, 0), new Preference(PREF_TEXROTANGLE, 0), new Preference(PREF_LINEWIDTH, 1.0f), new Preference(PREF_DLSEP, 2.0f), new Preference(PREF_ARROWPOSITION, 0.5f), new Preference(PREF_ARROWLENGTH, 5.0f), new Preference(PREF_ARROWWIDTH, 2.0f), new Preference(PREF_ARROWINSET, 0.2f), new Preference(PREF_SHOWTOOL, true), new Preference(PREF_SHOWSTATUS, true), new Preference(PREF_ANTIALIAS, true), new Preference(PREF_ARROW, true), new Preference(PREF_GRIDONOFF, true), new Preference(PREF_SNAPONOFF, true), new Preference(PREF_SHOWGRIDBAR, true), new Preference(PREF_SHOWSPLASHWINDOW, true)};
        NAME_TO_PREFERENCE = new HashMap<String, Preference>(PREFERENCES.length);
        VALUES = new HashMap<String, Object>(PREFERENCES.length);
        for (i = 0; i < PREFERENCES.length; ++i) {
            NAME_TO_PREFERENCE.put(PREFERENCES[i].getName(), PREFERENCES[i]);
            VALUES.put(PREFERENCES[i].getName(), PREFERENCES[i].getDefaultValue());
        }
        recentKEYS = new String[10];
        recentFile = new String[10];
        for (i = 0; i < 10; ++i) {
            String rf;
            JaxoPrefs.recentFile[i] = rf = "";
            JaxoPrefs.recentKEYS[i] = rf = "recentFile".concat(Integer.toString(i + 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Preference {
        private final String name;
        private final Class<?> type;
        private final Object defaultValue;

        Preference(String nname, String value) {
            this.name = nname;
            this.type = String.class;
            this.defaultValue = value;
        }

        Preference(String nname, int value) {
            this.name = nname;
            this.type = Integer.TYPE;
            this.defaultValue = value;
        }

        Preference(String nname, float value) {
            this.name = nname;
            this.type = Float.TYPE;
            this.defaultValue = Float.valueOf(value);
        }

        Preference(String nname, boolean value) {
            this.name = nname;
            this.type = Boolean.TYPE;
            this.defaultValue = value;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

