/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.MarkedContentInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Vector;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRenderInfo {
    private final String text;
    private final Matrix textToUserSpaceTransformMatrix;
    private final GraphicsState gs;
    private final Collection<MarkedContentInfo> markedContentInfos;

    TextRenderInfo(String text, GraphicsState gs, Matrix textMatrix, Collection<MarkedContentInfo> markedContentInfo) {
        this.text = text;
        this.textToUserSpaceTransformMatrix = textMatrix.multiply(gs.ctm);
        this.gs = gs;
        this.markedContentInfos = new ArrayList<MarkedContentInfo>(markedContentInfo);
    }

    public String getText() {
        return this.text;
    }

    public boolean hasMcid(int mcid) {
        for (MarkedContentInfo info : this.markedContentInfos) {
            if (!info.hasMcid() || info.getMcid() != mcid) continue;
            return true;
        }
        return false;
    }

    float getUnscaledWidth() {
        return this.getStringWidth(this.text);
    }

    public LineSegment getBaseline() {
        return this.getUnscaledBaselineWithOffset(0.0f).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getAscentLine() {
        float ascent = this.gs.getFont().getFontDescriptor(1, this.gs.getFontSize());
        return this.getUnscaledBaselineWithOffset(ascent).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getDescentLine() {
        float descent = this.gs.getFont().getFontDescriptor(3, this.gs.getFontSize());
        return this.getUnscaledBaselineWithOffset(descent).transformBy(this.textToUserSpaceTransformMatrix);
    }

    private LineSegment getUnscaledBaselineWithOffset(float yOffset) {
        return new LineSegment(new Vector(0.0f, yOffset, 1.0f), new Vector(this.getUnscaledWidth(), yOffset, 1.0f));
    }

    public DocumentFont getFont() {
        return this.gs.getFont();
    }

    public float getSingleSpaceWidth() {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(this.getUnscaledFontSpaceWidth(), 0.0f, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    public int getTextRenderMode() {
        return this.gs.renderMode;
    }

    private float getUnscaledFontSpaceWidth() {
        char charToUse = ' ';
        if (this.gs.font.getWidth(charToUse) == 0) {
            charToUse = '\u00a0';
        }
        return this.getStringWidth(String.valueOf(charToUse));
    }

    private float getStringWidth(String string) {
        CMapAwareDocumentFont font = this.gs.font;
        char[] chars = string.toCharArray();
        float totalWidth = 0.0f;
        for (int i = 0; i < chars.length; ++i) {
            float w = (float)((DocumentFont)font).getWidth(chars[i]) / 1000.0f;
            float wordSpacing = chars[i] == ' ' ? this.gs.wordSpacing : 0.0f;
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
        }
        return totalWidth;
    }
}

