/*
 * Decompiled with CFR 0.152.
 */
package org.bric.input;

import javax.swing.ImageIcon;
import org.bric.utils.Utils;

public class ImportedImage {
    private ImageIcon thumbnailImageIcon;
    private String path;
    private String dimensions;
    private String name;
    private String imageType;
    private long size;
    private boolean corrupted = false;

    public ImportedImage() {
    }

    public ImportedImage(String path) {
        boolean metadata;
        this.path = path;
        this.name = path.substring(path.lastIndexOf(Utils.FS) + 1);
        boolean thumbnail = Utils.prefs.getBoolean("thumbnail", true) && Utils.prefs.getInt("thumbWay", 0) == 0;
        boolean bl = metadata = Utils.prefs.getBoolean("metadata", true) && Utils.prefs.getInt("metaWay", 0) == 0;
        if (this.name.contains(".")) {
            this.name = this.name.substring(0, this.name.lastIndexOf("."));
        }
        this.imageType = path.substring(path.lastIndexOf(46) + 1);
        Utils.setMetadataThumbnail(this, metadata, thumbnail);
    }

    public void setThumbnailImageIcon(ImageIcon thumbnail) {
        this.thumbnailImageIcon = thumbnail;
    }

    public ImageIcon getThumbnailImageIcon() {
        return this.thumbnailImageIcon;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getImageType() {
        return this.imageType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public void setCorrupted(boolean corrupted) {
        this.corrupted = corrupted;
    }

    public String toString() {
        return this.path;
    }

    public ImportedImage clone() throws CloneNotSupportedException {
        ImportedImage clone = new ImportedImage();
        clone.setPath(this.path);
        clone.setName(this.name);
        clone.setImageType(this.imageType);
        return clone;
    }
}

