/*
 * Decompiled with CFR 0.152.
 */
package org.bric.processor;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.bric.imageEditParameters.WatermarkParameters;
import org.bric.processor.ImageProcessor;

public class WatermarkProcessor
implements ImageProcessor {
    WatermarkParameters watermarkParameter;

    public WatermarkProcessor(WatermarkParameters watermarkParameter) {
        this.watermarkParameter = watermarkParameter;
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        int type = image.getType() == 0 ? 2 : image.getType();
        BufferedImage watermarkImage = new BufferedImage(image.getWidth(), image.getHeight(), type);
        Graphics2D g2 = watermarkImage.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        if (this.watermarkParameter.getPattern() == 0) {
            int newX = this.watermarkParameter.getX(image.getWidth()) - this.watermarkParameter.getWatermarkImage().getWidth() / 2;
            int newY = this.watermarkParameter.getY(image.getHeight()) - this.watermarkParameter.getWatermarkImage().getHeight() / 2;
            g2.drawImage((Image)this.watermarkParameter.getWatermarkImage(), newX, newY, null);
        } else {
            int columns = this.watermarkParameter.getTiledColumns();
            int rows = this.watermarkParameter.getTiledRows();
            if (columns == 0) {
                columns = image.getWidth() / this.watermarkParameter.getWatermarkImage().getWidth();
            }
            if (rows == 0) {
                rows = image.getHeight() / this.watermarkParameter.getWatermarkImage().getHeight();
            }
            double rowsStep = image.getHeight() / rows;
            double columnsStep = image.getWidth() / columns;
            if (rowsStep < (double)(this.watermarkParameter.getWatermarkHeight() / 2)) {
                rows = image.getHeight() / this.watermarkParameter.getWatermarkImage().getHeight();
                rowsStep = image.getHeight() / rows;
            }
            if (columnsStep < (double)(this.watermarkParameter.getWatermarkWidth() / 2)) {
                columns = image.getWidth() / this.watermarkParameter.getWatermarkImage().getWidth();
                columnsStep = image.getWidth() / columns;
            }
            int row = image.getHeight() / rows / 2 - this.watermarkParameter.getWatermarkImage().getHeight() / 2;
            int column = image.getWidth() / columns / 2 - this.watermarkParameter.getWatermarkImage().getWidth() / 2;
            for (int c = 0; c < columns; ++c) {
                for (int r = 0; r < rows; ++r) {
                    g2.drawImage((Image)this.watermarkParameter.getWatermarkImage(), (int)((double)column + columnsStep * (double)c), (int)((double)row + rowsStep * (double)r), null);
                }
            }
        }
        g2.dispose();
        return watermarkImage;
    }
}

