/*
 * Decompiled with CFR 0.152.
 */
package net.grelf;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import net.grelf.Maths;
import net.grelf.MixedUnitsException;
import net.grelf.Units;

public class MeasuredValue
implements Cloneable,
Serializable {
    private double value = 0.0;
    private double stdErr = 0.0;
    private Units units;

    public double getValue() {
        return this.value;
    }

    public double getStdErr() {
        return this.stdErr;
    }

    public Units getUnits() {
        return this.units;
    }

    public MeasuredValue(double d, double d2, Units units) {
        this.value = d;
        this.stdErr = d2;
        this.units = units;
    }

    public MeasuredValue(double[] dArray, Units units) {
        this.calculateFields(dArray, units);
    }

    public MeasuredValue(Collection<Double> collection, Units units) {
        double[] dArray = new double[collection.size()];
        int n = 0;
        Iterator<Double> iterator = collection.iterator();
        while (iterator.hasNext()) {
            double d;
            dArray[n] = d = iterator.next().doubleValue();
            ++n;
        }
        this.calculateFields(dArray, units);
    }

    private void calculateFields(double[] dArray, Units units) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d2 += dArray[i];
            d3 += dArray[i] * dArray[i];
        }
        this.value = d = d2 / (double)n;
        this.stdErr = Math.sqrt((d3 / (double)n - d * d) / (double)(n - 1));
        this.units = units;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.value);
        if (this.stdErr != 0.0) {
            stringBuffer.append(" \u00b1 ");
            stringBuffer.append(this.stdErr);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.units.getSymbol());
        return stringBuffer.toString();
    }

    public String toString(DecimalFormat decimalFormat) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(decimalFormat.format(this.value));
        if (this.stdErr != 0.0) {
            stringBuffer.append(" \u00b1 ");
            stringBuffer.append(decimalFormat.format(this.stdErr));
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.units.getSymbol());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        MeasuredValue measuredValue = (MeasuredValue)object;
        if (StrictMath.abs(measuredValue.value - this.value) > StrictMath.abs(this.value) * 1.0E-12) {
            return false;
        }
        if (StrictMath.abs(measuredValue.stdErr - this.stdErr) > StrictMath.abs(this.stdErr) * 1.0E-12) {
            return false;
        }
        return measuredValue.units.equals(this.units);
    }

    public double probablyEquals(Object object) {
        if (null == object) {
            return 0.0;
        }
        if (this.getClass() != object.getClass()) {
            return 0.0;
        }
        MeasuredValue measuredValue = (MeasuredValue)object;
        if (!measuredValue.units.equals(this.units)) {
            return 0.0;
        }
        double d = Math.abs(measuredValue.getValue() - this.value);
        if (d < this.stdErr * 1.0E-5) {
            return 1.0;
        }
        double d2 = Maths.erf(d / this.stdErr / Maths.SQRT2);
        double d3 = Maths.erf(d / measuredValue.getStdErr() / Maths.SQRT2);
        return StrictMath.sqrt(d2 * d3);
    }

    public int hashCode() {
        return (int)(1234.0 * this.value + 5678.0 * this.stdErr) + this.units.hashCode();
    }

    public MeasuredValue clone() {
        return new MeasuredValue(this.value, this.stdErr, this.units);
    }

    public MeasuredValue add(double d) {
        return new MeasuredValue(this.value + d, this.stdErr, this.units);
    }

    public MeasuredValue add(MeasuredValue measuredValue) throws MixedUnitsException {
        if (!this.units.equals(measuredValue.units)) {
            throw new MixedUnitsException();
        }
        return new MeasuredValue(this.value + measuredValue.value, StrictMath.sqrt(this.stdErr * this.stdErr + measuredValue.stdErr * measuredValue.stdErr), this.units);
    }

    public MeasuredValue subtract(MeasuredValue measuredValue) throws MixedUnitsException {
        if (!this.units.equals(measuredValue.units)) {
            throw new MixedUnitsException();
        }
        return new MeasuredValue(this.value - measuredValue.value, StrictMath.sqrt(this.stdErr * measuredValue.stdErr), this.units);
    }

    public MeasuredValue multiply(double d) {
        return new MeasuredValue(this.value * d, this.stdErr * d, this.units);
    }

    public MeasuredValue multiply(MeasuredValue measuredValue) throws MixedUnitsException {
        if (!this.units.equals(measuredValue.units)) {
            throw new MixedUnitsException();
        }
        double d = this.value * measuredValue.value;
        double d2 = this.value * this.value;
        double d3 = measuredValue.value * measuredValue.value;
        double d4 = d * StrictMath.sqrt(this.stdErr * this.stdErr / d2 + measuredValue.stdErr * measuredValue.stdErr / d3);
        return new MeasuredValue(d, d4, this.units);
    }

    public MeasuredValue divide(MeasuredValue measuredValue) throws MixedUnitsException {
        if (!this.units.equals(measuredValue.units)) {
            throw new MixedUnitsException();
        }
        double d = this.value / measuredValue.value;
        double d2 = this.value * this.value;
        double d3 = measuredValue.value * measuredValue.value;
        double d4 = d * StrictMath.sqrt(this.stdErr * this.stdErr / d2 + measuredValue.stdErr * measuredValue.stdErr / d3);
        return new MeasuredValue(d, d4, this.units);
    }
}

