/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import net.grelf.AbstractDialogue;
import net.grelf.FileIO;
import net.grelf.Timer;
import net.grelf.Util;
import net.grelf.grip.Config;
import net.grelf.grip.GRIP;
import net.grelf.grip.ImSaturateDialogue;
import net.grelf.grip.Raw;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image8or16Base;
import net.grelf.image.ImageLoader;

public class BatchDialogue
extends AbstractDialogue
implements ActionListener {
    private String[] ops = new String[]{"contrast auto-stretch", "convert to monochrome", "convert to 8 bits per channel", "correct background", "flip horizontally", "flip vertically", "invert contrast", "rotate", "saturate", "scale", "square (multipy by self)", "inverse gnomonic projection", "gnomonic projection"};
    private JPanel sequencePanel = new JPanel();
    private JButton loadButton = new JButton("Load");
    private JButton clearButton = new JButton("Clear all");
    private JButton addButton = new JButton("Append operation");
    private JPanel topButtonPanel = new JPanel();
    private JButton saveButton = new JButton("Save");
    private JButton processButton = new JButton("Process");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel bottomButtonPanel = new JPanel();
    private static ProgressMonitor monitor = null;

    public BatchDialogue() {
        this.setTitle("Make batch sequence");
        Container container = this.getContentPane();
        this.sequencePanel.setLayout(new GridLayout(0, 1));
        this.saveButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.processButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.topButtonPanel.setLayout(new BorderLayout());
        this.topButtonPanel.add((Component)this.loadButton, "West");
        this.topButtonPanel.add((Component)this.clearButton, "Center");
        this.topButtonPanel.add((Component)this.addButton, "East");
        this.bottomButtonPanel.setLayout(new BorderLayout());
        this.bottomButtonPanel.add((Component)this.saveButton, "West");
        this.bottomButtonPanel.add((Component)this.processButton, "Center");
        this.bottomButtonPanel.add((Component)this.cancelButton, "East");
        container.setLayout(new BorderLayout());
        container.add((Component)this.topButtonPanel, "North");
        container.add((Component)this.sequencePanel, "Center");
        container.add((Component)this.bottomButtonPanel, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            this.save();
        } else if (object == this.clearButton) {
            this.sequencePanel.removeAll();
            this.pack();
            this.repaint();
        } else if (object == this.addButton) {
            OpPanel opPanel = new OpPanel(this);
            if (!opPanel.getOpName().equals("null")) {
                this.sequencePanel.add(opPanel);
                this.pack();
                this.repaint();
            }
        } else if (object == this.loadButton) {
            this.load();
        } else if (object == this.processButton) {
            this.setVisible(false);
            this.dispose();
            this.process();
        } else if (object == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void delete(OpPanel opPanel) {
        int n = this.getIndex(opPanel);
        if (-1 != n) {
            this.sequencePanel.remove(n);
            this.pack();
            this.repaint();
        }
    }

    private int getIndex(OpPanel opPanel) {
        Component[] componentArray = this.sequencePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (opPanel != (OpPanel)componentArray[i]) continue;
            return i;
        }
        return -1;
    }

    private void insertBefore(OpPanel opPanel) {
        OpPanel opPanel2;
        int n = this.getIndex(opPanel);
        if (-1 != n && !(opPanel2 = new OpPanel(this)).getOpName().equals("null")) {
            this.sequencePanel.add((Component)opPanel2, n);
            this.pack();
            this.repaint();
        }
    }

    private void load() {
        String string = FileIO.selectInputFile("Load sequence");
        if (null != string) {
            this.sequencePanel.removeAll();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while (null != (string2 = bufferedReader.readLine())) {
                    this.sequencePanel.add(new OpPanel(this, string2));
                }
                bufferedReader.close();
                this.pack();
                this.repaint();
            }
            catch (IOException iOException) {
                Util.logWarning(iOException.toString());
                Util.warning("Error", "File {0} could not be read", string);
            }
        }
    }

    private void save() {
        String string = FileIO.selectOutputFile("Save sequence", null, null, "x.batch");
        if (null != string) {
            try {
                PrintWriter printWriter = new PrintWriter(string);
                Component[] componentArray = this.sequencePanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    printWriter.println(((OpPanel)componentArray[i]).getOpName());
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                Util.logWarning(iOException.toString());
                Util.warning("Error", "File {0} could not be saved", string);
            }
        }
    }

    private void process() {
        Component[] componentArray = this.sequencePanel.getComponents();
        if (0 < componentArray.length) {
            OpPanel[] opPanelArray = new OpPanel[componentArray.length];
            for (int i = 0; i < componentArray.length; ++i) {
                opPanelArray[i] = (OpPanel)componentArray[i];
            }
            File[] fileArray = FileIO.selectInputFiles("Images to process");
            if (null != fileArray) {
                BatchDialogue.doOpInBackground(fileArray, opPanelArray, "_seq", fileArray.length * opPanelArray.length);
            }
        }
    }

    private static void batch(File[] fileArray, OpPanel[] opPanelArray, String string) {
        Timer timer = new Timer("BatchDialogue.batch", null);
        int n = 0;
        int n2 = fileArray.length;
        double d = Double.parseDouble(Config.getValue("Detector.width.mm.value"));
        double d2 = Double.parseDouble(Config.getValue("Detector.height.mm.value"));
        double d3 = 1.0;
        try {
            d3 = Math.abs(Double.parseDouble(Config.getValue("BackgroundFactor.value")));
        }
        catch (NumberFormatException numberFormatException) {
            d3 = 1.0;
        }
        int n3 = 256;
        try {
            n3 = Integer.parseInt(Config.getValue("BackgroundCellFactor.value"));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 256;
        }
        for (int i = 0; i < n2; ++i) {
            String string2;
            Image image;
            File file = fileArray[i];
            if (!file.exists()) continue;
            if (null != monitor) {
                monitor.setNote(file.getName() + " [" + (i + 1) + " of " + n2 + "]");
                if (monitor.isCanceled()) {
                    monitor.close();
                    return;
                }
            }
            if (null == (image = ImageLoader.load(file))) continue;
            if (!(image instanceof Image8or16Base)) {
                Util.warning("Error", "Loaded image is not 8- or 16-bit");
                return;
            }
            BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
            if (image.isRaw()) {
                Raw.interpret(image);
                Raw.removeMargin(image);
            }
            for (int j = 0; j < opPanelArray.length; ++j) {
                if (null != monitor) {
                    monitor.setProgress(n++);
                    if (monitor.isCanceled()) {
                        monitor.close();
                        return;
                    }
                }
                if (opPanelArray[j].getOpName().equals("contrast auto-stretch")) {
                    image.autoStretch(true);
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("convert to monochrome")) {
                    image.convertToMonochrome();
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("convert to 8 bits per channel")) {
                    ((Image16)image).convertToImage8();
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("correct background")) {
                    image.correctBackground(d3, n3);
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("flip horizontally")) {
                    image.flipHorizontal();
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("flip vertically")) {
                    image.flipVertical();
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("gnomonic projection")) {
                    image = image.gnomonicProjection(image.getMetadata().getFocalLength(), d, d2);
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("invert contrast")) {
                    image.invert();
                    continue;
                }
                if (opPanelArray[j].getOpName().equals("inverse gnomonic projection")) {
                    image = image.inverseGnomonicProjection(image.getMetadata().getFocalLength(), d, d2);
                    continue;
                }
                if (opPanelArray[j].getOpName().startsWith("rotate ")) {
                    int n4 = opPanelArray[j].getOpName().lastIndexOf(32);
                    string2 = opPanelArray[j].getOpName().substring(7, n4);
                    double d4 = Double.parseDouble(string2);
                    image.rotate(d4);
                    continue;
                }
                if (opPanelArray[j].getOpName().startsWith("saturate by ")) {
                    String string3 = opPanelArray[j].getOpName().substring(12);
                    int n5 = Integer.parseInt(string3);
                    ImSaturateDialogue.saturate(image, n5);
                    continue;
                }
                if (opPanelArray[j].getOpName().startsWith("scale x ")) {
                    String string4 = opPanelArray[j].getOpName().substring(8);
                    double d5 = Double.parseDouble(string4);
                    image.scale(d5, true);
                    continue;
                }
                if (!opPanelArray[j].getOpName().startsWith("square")) continue;
                image.multiply(image);
            }
            if (null == string) continue;
            String string5 = file.getPath();
            String string6 = FileIO.getExtension(string5);
            if (image.isRaw()) {
                string6 = ".tif";
            }
            if (image.getBitsPerChannel() == 8) {
                string6 = ".jpg";
            }
            string2 = FileIO.removeExtension(string5) + string + string6;
            image.save(string2);
        }
        if (null != monitor) {
            monitor.close();
        }
        timer.stop();
    }

    public static void doOpInBackground(File[] fileArray, OpPanel[] opPanelArray, String string, int n) {
        monitor = new ProgressMonitor(GRIP.getInstance(), "Batch", "Running", 0, n);
        OpThread opThread = new OpThread(fileArray, opPanelArray, string);
        opThread.start();
    }

    private static class OpThread
    extends Thread {
        private File[] files;
        private OpPanel[] ops;
        private String fileNameModifier;

        public OpThread(File[] fileArray, OpPanel[] opPanelArray, String string) {
            this.files = fileArray;
            this.ops = opPanelArray;
            this.fileNameModifier = string;
        }

        @Override
        public void run() {
            BatchDialogue.batch(this.files, this.ops, this.fileNameModifier);
        }
    }

    public class OpPanel
    extends JPanel
    implements ActionListener {
        private String opName;
        private BatchDialogue parent;
        private JLabel opLabel;
        private JButton insertButton = new JButton("Insert before");
        private JButton deleteButton = new JButton("Delete");

        public String getOpName() {
            return this.opName;
        }

        public OpPanel(BatchDialogue batchDialogue2) {
            this.parent = batchDialogue2;
            this.opName = this.selectOp();
            this.init();
        }

        public OpPanel(BatchDialogue batchDialogue2, String string) {
            this.parent = batchDialogue2;
            this.opName = string;
            this.init();
        }

        private void init() {
            this.opLabel = new JLabel(this.opName);
            this.opLabel.setPreferredSize(new Dimension(180, 20));
            this.opLabel.setSize(new Dimension(180, 20));
            this.insertButton.setPreferredSize(new Dimension(120, 20));
            this.insertButton.setSize(new Dimension(120, 20));
            this.insertButton.addActionListener(this);
            this.deleteButton.setPreferredSize(new Dimension(80, 20));
            this.deleteButton.setSize(new Dimension(80, 20));
            this.deleteButton.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.opLabel, "West");
            this.add((Component)this.insertButton, "Center");
            this.add((Component)this.deleteButton, "East");
        }

        private String selectOp() {
            String string = (String)JOptionPane.showInputDialog(this.parent, "Operation?", "Select operation", 3, null, BatchDialogue.this.ops, BatchDialogue.this.ops[0]);
            if (null != string) {
                if (string.equals("rotate")) {
                    double d = Util.askDouble("Angle to rotate anti-clockwise (degrees) [-360..360]?", 0.0, -360.0, 360.0);
                    string = -360.0 <= d && d <= 360.0 ? string + " " + Double.toString(d) + " degrees" : "null";
                } else if (string.equals("saturate")) {
                    int n = Util.askInteger("Saturation factor [-100..+100]?", 0, -100, 100);
                    string = 0 == n ? "null" : string + " by " + n;
                } else if (string.equals("scale")) {
                    double d = Util.askDouble("Factor to scale by [0.1..10]?", 1.0, 0.1, 10.0);
                    string = 0.1 <= d && d <= 10.0 ? string + " x " + Double.toString(d) : "null";
                }
            } else {
                string = "null";
            }
            return string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.insertButton) {
                this.parent.insertBefore(this);
            } else if (object == this.deleteButton) {
                this.parent.delete(this);
            }
        }
    }
}

