/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.grelf.Angle;
import net.grelf.Length;
import net.grelf.Maths;
import net.grelf.Util;
import net.grelf.astro.SkyPoint;
import net.grelf.astro.SkyVector;
import net.grelf.astro.Star;
import net.grelf.grip.BlobMeas;
import net.grelf.grip.BlobMeasList;
import net.grelf.grip.DrawingMode;
import net.grelf.grip.GlassPane;
import net.grelf.grip.ImFrame;
import net.grelf.image.Calibration;

public class Calibrator {
    private static final DecimalFormat DF3 = new DecimalFormat("0.000");

    public static void show(ImFrame imFrame) {
        imFrame.getImPane().getImage().getCalibration().show();
    }

    public static void calibrate(ImFrame imFrame) {
        imFrame.getImPane().getGlassPane().setDrawingMode(DrawingMode.CALIBRATE);
        imFrame.setTitle("Calibrate: set 2 points of known separation");
    }

    public static void calibrateOnStars(ImFrame imFrame) {
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        BlobMeasList blobMeasList = imFrame.getBlobMeases();
        double d = 0.0;
        int n = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (null != blobMeasList) {
            for (BlobMeas blobMeas : blobMeasList) {
                SkyPoint skyPoint;
                Star star = blobMeas.getStar();
                if (null == star || null == (skyPoint = star.getPosition())) continue;
                for (Object object2 : blobMeasList) {
                    serializable2 = ((BlobMeas)object2).getStar();
                    if (null == serializable2 || star.equals(serializable2) || null == (serializable = ((Star)serializable2).getPosition())) continue;
                    SkyVector skyVector = skyPoint.calculateSeparation((SkyPoint)serializable);
                    double d2 = ((BlobMeas)object2).centre.x - blobMeas.centre.x;
                    double d3 = ((BlobMeas)object2).centre.y - blobMeas.centre.y;
                    double d4 = StrictMath.sqrt(d2 * d2 + d3 * d3);
                    double d5 = StrictMath.toDegrees(StrictMath.atan2(-d3, d2));
                    double d6 = skyVector.getSeparation().getDegrees() / d4;
                    d += d6;
                    double d7 = 360.0 - skyVector.getPa().getDegrees() + d5;
                    arrayList.add(d7);
                    ++n;
                }
            }
        }
        double d8 = d / (double)n;
        double d9 = Maths.angleStatistics(arrayList).mean;
        GlassPane glassPane = imFrame.getGP();
        glassPane.overlayMeridian(d9);
        glassPane.repaint();
        object2 = imFrame.getImPane().getImage();
        serializable2 = object2.getCalibration();
        serializable = new Calibration.Units(Length.Units.PIXEL, Angle.Units.DEGREES);
        ((Calibration)serializable2).setValue(d8, (Calibration.Units)serializable, true);
        Util.message(imFrame, "Calibration", ((Calibration)serializable2).getValue(true) + "<br><br>Image size: " + object2.getWidth() + " x " + object2.getHeight() + " pixels<br>= " + DF3.format(d8 * (double)object2.getWidth()) + " x " + DF3.format(d8 * (double)object2.getHeight()) + " degrees");
    }
}

