/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ProgressMonitor;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.grelf.Gaussian;
import net.grelf.Interpolator;
import net.grelf.Statistics;
import net.grelf.Util;
import net.grelf.image.ByteMask;
import net.grelf.image.FITS;
import net.grelf.image.HistogramAll;
import net.grelf.image.Image;
import net.grelf.image.Image16;
import net.grelf.image.Image8;
import net.grelf.image.ImageBase;
import net.grelf.image.ImageLoader;
import net.grelf.image.IncompatibleImageException;
import net.grelf.image.Kernel;
import net.grelf.image.Metadata;
import net.grelf.image.RangeDouble;
import net.grelf.image.RangeInt;
import net.grelf.image.Threshold;
import net.grelf.image.Timer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Image8or16Base
extends ImageBase
implements Image {
    protected BufferedImage bim;
    protected int[] zeroPxInt;
    protected double[] zeroPxDouble;

    public BufferedImage getBufferedImage() {
        return this.bim;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bim = bufferedImage;
    }

    protected void checkCompatibility(BufferedImage bufferedImage) throws IncompatibleImageException {
        if (this.getNBands() < bufferedImage.getSampleModel().getNumBands()) {
            throw new IncompatibleImageException("Image has too many bands");
        }
    }

    @Override
    public void add(BufferedImage bufferedImage) throws IncompatibleImageException {
        this.checkCompatibility(bufferedImage);
        Timer timer = new Timer("Image8or16.add", this);
        WritableRaster writableRaster = this.bim.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n = this.getNBands();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = this.getBitsPerChannel();
        int n3 = Image8or16Base.getBitsPerChannel(bufferedImage);
        if (n2 == n3) {
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n; ++k) {
                        int n4 = k;
                        nArray[n4] = nArray[n4] + nArray2[k];
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else if (n2 > n3) {
            int n5 = n2 - n3;
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n; ++k) {
                        int n6 = k;
                        nArray[n6] = nArray[n6] + (nArray2[k] << n5);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else if (n2 < n3) {
            int n7 = n3 - n2;
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n; ++k) {
                        int n8 = k;
                        nArray[n8] = nArray[n8] + (nArray2[k] >> n7);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
        timer.stop();
    }

    @Override
    public void addProportion(Image image, double d, double d2) throws IncompatibleImageException {
        Timer timer;
        if (image instanceof Image8or16Base) {
            BufferedImage bufferedImage = ((Image8or16Base)image).bim;
            this.checkCompatibility(bufferedImage);
            timer = new Timer("Im8or16Base.add", this);
            WritableRaster writableRaster = this.bim.getRaster();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            int n = this.getNBands();
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n2 = this.getBitsPerChannel();
            int n3 = image.getBitsPerChannel();
            if (n2 == n3) {
                for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                    for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                        writableRaster.getPixel(j, i, nArray);
                        writableRaster2.getPixel(j, i, nArray2);
                        for (int k = 0; k < n; ++k) {
                            nArray[k] = (int)((double)nArray[k] * d + (double)nArray2[k] * d2);
                        }
                        writableRaster.setPixel(j, i, nArray);
                    }
                }
            } else if (n2 > n3) {
                int n4 = n2 - n3;
                for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                    for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                        writableRaster.getPixel(j, i, nArray);
                        writableRaster2.getPixel(j, i, nArray2);
                        for (int k = 0; k < n; ++k) {
                            nArray[k] = (int)((double)nArray[k] * d + (double)(nArray2[k] << n4) * d2);
                        }
                        writableRaster.setPixel(j, i, nArray);
                    }
                }
            } else if (n2 < n3) {
                int n5 = n3 - n2;
                for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                    for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                        writableRaster.getPixel(j, i, nArray);
                        writableRaster2.getPixel(j, i, nArray2);
                        for (int k = 0; k < n; ++k) {
                            nArray[k] = (int)((double)nArray[k] * d + (double)(nArray2[k] >> n5) * d2);
                        }
                        writableRaster.setPixel(j, i, nArray);
                    }
                }
            }
        } else {
            throw new IncompatibleImageException("Cannot add proportions of images with different bit depths");
        }
        timer.stop();
    }

    @Override
    public void addTranslated(BufferedImage bufferedImage, int n, int n2) throws IncompatibleImageException {
        this.checkCompatibility(bufferedImage);
        this.add(this.translateCopy(n, n2));
    }

    @Override
    public void addTranslated(BufferedImage bufferedImage, double d, double d2) throws IncompatibleImageException {
        this.checkCompatibility(bufferedImage);
        this.add(this.translateCopy(d, d2));
    }

    @Override
    public void applyCurve(RangeInt rangeInt, List<Point> list, BufferedImage bufferedImage) throws IncompatibleImageException {
        if (1 < list.size()) {
            Object object;
            int n;
            int n2 = this.getNBands();
            WritableRaster writableRaster = null;
            int n3 = this.getRange().high;
            if (null != bufferedImage) {
                if (bufferedImage.getSampleModel().getNumBands() != n2) {
                    throw new IncompatibleImageException("Target image does not have same number of channels as source image");
                }
                writableRaster = bufferedImage.getRaster();
                n = Image8or16Base.getMaxLevel(bufferedImage);
            } else {
                writableRaster = this.bim.getRaster();
                n = this.getRange().high;
            }
            int[] nArray = new int[n3 + 1];
            double d = (double)n3 / 255.0;
            double d2 = (double)n / 255.0;
            Object object2 = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                object = list.get(i);
                double d3 = (double)((Point)object2).y * d2;
                double d4 = d * (double)(((Point)object).x - ((Point)object2).x);
                if (d4 > 0.0) {
                    double d5 = d2 * (double)(((Point)object).y - ((Point)object2).y) / d4;
                    int n4 = (int)((double)((Point)object2).x * d);
                    while (n4 <= (int)((double)((Point)object).x * d) && n4 < nArray.length) {
                        nArray[n4] = (int)d3;
                        ++n4;
                        d3 += d5;
                    }
                }
                object2 = object;
            }
            WritableRaster writableRaster2 = this.bim.getRaster();
            object = new int[n2];
            int n5 = 0;
            for (int i = 0; i < this.getHeight(); ++i) {
                int n6 = 0;
                while (n6 < this.getWidth()) {
                    writableRaster2.getPixel(n6, i, (int[])object);
                    for (int j = 0; j < n2; ++j) {
                        object[j] = nArray[object[j]];
                    }
                    writableRaster.setPixel(n6, i, (int[])object);
                    ++n6;
                    ++n5;
                }
            }
        }
    }

    @Override
    public void autoCrop() {
        int n;
        int n2;
        int n3;
        Timer timer = new Timer("Image8or16Base.autoCrop", this);
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        int n6 = this.getNBands();
        int[] nArray = new int[n6];
        Point point = new Point(0, 0);
        Point point2 = new Point(n4 - 1, n5 - 1);
        boolean bl = false;
        for (n3 = 0; n3 < n5 && !bl; ++n3) {
            block1: for (n2 = 0; n2 < n4 && !bl; ++n2) {
                writableRaster.getPixel(n2, n3, nArray);
                for (n = 0; n < n6; ++n) {
                    if (0 == nArray[n]) continue;
                    bl = true;
                    point.y = n3;
                    continue block1;
                }
            }
        }
        bl = false;
        for (n3 = n5 - 1; n3 >= 0 && !bl; --n3) {
            block4: for (n2 = 0; n2 < n4 && !bl; ++n2) {
                writableRaster.getPixel(n2, n3, nArray);
                for (n = 0; n < n6; ++n) {
                    if (0 == nArray[n]) continue;
                    bl = true;
                    point2.y = n3;
                    continue block4;
                }
            }
        }
        bl = false;
        for (n3 = 0; n3 < n4 && !bl; ++n3) {
            block7: for (n2 = 0; n2 < n5 && !bl; ++n2) {
                writableRaster.getPixel(n3, n2, nArray);
                for (n = 0; n < n6; ++n) {
                    if (0 == nArray[n]) continue;
                    bl = true;
                    point.x = n3;
                    continue block7;
                }
            }
        }
        bl = false;
        for (n3 = n4 - 1; n3 >= 0 && !bl; --n3) {
            block10: for (n2 = 0; n2 < n5 && !bl; ++n2) {
                writableRaster.getPixel(n3, n2, nArray);
                for (n = 0; n < n6; ++n) {
                    if (0 == nArray[n]) continue;
                    bl = true;
                    point2.x = n3;
                    continue block10;
                }
            }
        }
        this.crop(point, point2);
        timer.stop();
    }

    @Override
    public void autoStretch(boolean bl) {
        this.autoStretch(bl, new Point(0, 0), new Point(this.bim.getWidth() - 1, this.bim.getHeight() - 1));
    }

    @Override
    public void autoStretch(boolean bl, Point point, Point point2) {
        int n;
        int n2;
        int n3;
        Timer timer = new Timer("Image8or16Base.autoStretch", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        int n5 = this.getMaxLevel();
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = n5;
            nArray3[n3] = 0;
        }
        for (n3 = point.y; n3 <= point2.y; ++n3) {
            for (n2 = point.x; n2 <= point2.x; ++n2) {
                writableRaster.getPixel(n2, n3, nArray);
                for (n = 0; n < n4; ++n) {
                    if (nArray[n] > nArray3[n]) {
                        nArray3[n] = nArray[n];
                        continue;
                    }
                    if (nArray[n] >= nArray2[n]) continue;
                    nArray2[n] = nArray[n];
                }
            }
        }
        if (bl) {
            n3 = n5;
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                if (n3 > nArray2[n]) {
                    n3 = nArray2[n];
                }
                if (n2 >= nArray3[n]) continue;
                n2 = nArray3[n];
            }
            float f = (float)n5 / (float)(n2 - n3);
            for (int i = point.y; i <= point2.y; ++i) {
                for (int j = point.x; j <= point2.x; ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    for (int k = 0; k < n4; ++k) {
                        nArray[k] = (int)((float)(nArray[k] - n3) * f);
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else {
            float[] fArray = new float[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                fArray[n2] = (float)n5 / (float)(nArray3[n2] - nArray2[n2]);
            }
            for (n2 = point.y; n2 <= point2.y; ++n2) {
                for (n = point.x; n <= point2.x; ++n) {
                    writableRaster.getPixel(n, n2, nArray);
                    for (int i = 0; i < n4; ++i) {
                        nArray[i] = (int)((float)(nArray[i] - nArray2[i]) * fArray[i]);
                    }
                    writableRaster.setPixel(n, n2, nArray);
                }
            }
        }
        timer.stop();
    }

    @Override
    public ByteMask autoThreshold() {
        Timer timer = new Timer("Image8or16Base.autoThreshold", this);
        int n = this.getNBands();
        int n2 = this.getMaxLevel();
        int n3 = n2 / 2;
        ByteMask byteMask = null;
        try {
            Statistics[] statisticsArray = new HistogramAll(this).getStatistics(0, n2);
            Threshold threshold = new Threshold(n);
            for (int i = 0; i < n; ++i) {
                if (statisticsArray[i].mean < (double)n3) {
                    threshold.th[i].low = n3;
                    threshold.th[i].high = n2;
                    continue;
                }
                threshold.th[i].low = 0;
                threshold.th[i].high = n3;
            }
            Util.logInfo("Auto-threshold levels: {0}", threshold.toString());
            byteMask = this.threshold(threshold);
        }
        catch (ArithmeticException arithmeticException) {
            Util.warning("Sorry", "You cannot do automatic thresholding on this kind of image");
        }
        timer.stop();
        return byteMask;
    }

    @Override
    public void averageVertically() {
        this.averageVertically(0, this.getHeight() - 1);
    }

    @Override
    public void averageVertically(int n, int n2) {
        Timer timer = new Timer("Image8or16Base.averageVertically", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n3 = writableRaster.getWidth();
        int n4 = n2 - n + 1;
        int n5 = this.getNBands();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        for (int i = 0; i < n3; ++i) {
            int n6;
            for (n6 = 0; n6 < n5; ++n6) {
                nArray2[n6] = 0;
            }
            for (n6 = n; n6 <= n2; ++n6) {
                writableRaster.getPixel(i, n6, nArray);
                for (int j = 0; j < n5; ++j) {
                    int n7 = j;
                    nArray2[n7] = nArray2[n7] + nArray[j];
                }
            }
            n6 = 0;
            while (n6 < n5) {
                int n8 = n6++;
                nArray2[n8] = nArray2[n8] / n4;
            }
            for (n6 = n; n6 <= n2; ++n6) {
                writableRaster.setPixel(i, n6, nArray2);
            }
        }
        timer.stop();
    }

    @Override
    public void blurGaussian(int n, int n2, ProgressMonitor progressMonitor) {
        double d = this.getMaxLevel();
        double[] dArray = Gaussian.getProfileAsArray(n, d);
        double[] dArray2 = Gaussian.getProfileAsArray(n2, d);
        this.convolve(dArray, dArray2, progressMonitor);
    }

    @Override
    public abstract Image clone();

    @Override
    public void convertToMonochrome() {
        this.convertToMonochrome(0.65, 1.0, 0.35);
    }

    @Override
    public void convertToMonochrome(double ... dArray) {
        int n = this.getNBands();
        if (n < dArray.length) {
            Util.warning("Error", "Number of factors does not equal number of image bands.");
        } else {
            Timer timer = new Timer("Image8or16Base.convertToMonochrome", this.bim);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            BufferedImage bufferedImage = this.getBitsPerChannel() == 8 ? new Image8(n2, n3, 1).getBufferedImage() : new Image16(n2, n3, 1).getBufferedImage();
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                d += dArray[i];
            }
            double d2 = 1.0 / d;
            WritableRaster writableRaster = this.bim.getRaster();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            int[] nArray = new int[n];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    double d3 = 0.0;
                    for (int k = 0; k < n; ++k) {
                        d3 += dArray[k] * (double)nArray[k];
                    }
                    nArray[0] = (int)(d3 * d2);
                    writableRaster2.setPixel(j, i, nArray);
                }
            }
            this.bim = bufferedImage;
            timer.stop();
        }
    }

    @Override
    public void convolve(Kernel kernel, ProgressMonitor progressMonitor) {
        Timer timer = new Timer("Image8or16Base.convolve", this);
        int n = this.getNBands();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n2, n3), this.bim.isAlphaPremultiplied(), null);
        int n4 = Image8or16Base.getMaxLevel(bufferedImage);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n5 = 2 * kernel.getHalfWidth() + 1;
        int n6 = n5 * n5;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = 0.0f;
        }
        float[][] fArray2 = kernel.getData();
        int n7 = 0;
        if (fArray2.length == n) {
            n7 = 1;
        }
        int n8 = 0;
        int n9 = 0;
        while (n8 < n) {
            for (int i = 0; i < fArray2[n9].length; ++i) {
                int n10 = n8;
                fArray[n10] = fArray[n10] + fArray2[n9][i];
            }
            ++n8;
            n9 += n7;
        }
        float[] fArray3 = new float[n];
        for (n9 = 0; n9 < n; ++n9) {
            fArray3[n9] = fArray[n9] != 0.0f ? 1.0f / fArray[n9] : 1.0f;
        }
        float[] fArray4 = new float[n6];
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n * n3);
        }
        int n11 = 0;
        int n12 = 0;
        while (n11 < n) {
            float[] fArray5 = fArray2[n12];
            int n13 = 0;
            int n14 = kernel.getHalfWidth();
            while (n13 < n3 - n5) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(n11 * n3 + n13);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                int n15 = 0;
                int n16 = kernel.getHalfWidth();
                while (n15 < n2 - n5) {
                    writableRaster.getSamples(n15, n13, n5, n5, n11, fArray4);
                    float f = 0.0f;
                    for (int i = 0; i < n6; ++i) {
                        f += fArray4[i] * fArray5[i];
                    }
                    if ((f *= fArray3[n11]) > (float)n4) {
                        f = n4;
                    } else if (f < 0.0f) {
                        f = 0.0f;
                    }
                    writableRaster2.setSample(n16, n14, n11, f);
                    ++n15;
                    ++n16;
                }
                ++n13;
                ++n14;
            }
            ++n11;
            n12 += n7;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        this.setBufferedImage(bufferedImage);
        timer.stop();
    }

    @Override
    public void convolve(double[] dArray, double[] dArray2, ProgressMonitor progressMonitor) {
        int n;
        int n2;
        int n3;
        int n4;
        int[] nArray;
        double d;
        int n5;
        int n6;
        WritableRaster writableRaster;
        Timer timer = new Timer("Image8or16Base.convolve", this);
        int n7 = this.getMaxLevel();
        int n8 = this.getNBands();
        int n9 = this.getWidth();
        int n10 = n9 - 1;
        int n11 = this.getHeight();
        int n12 = n11 - 1;
        BufferedImage bufferedImage = null;
        int n13 = 0;
        if (null != progressMonitor) {
            int n14 = 0;
            if (null != dArray) {
                n14 += n11;
            }
            if (null != dArray2) {
                n14 += n9;
            }
            progressMonitor.setMaximum(n14);
        }
        if (null != dArray) {
            WritableRaster writableRaster2 = this.bim.getRaster();
            bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster2.createCompatibleWritableRaster(n9, n11), this.bim.isAlphaPremultiplied(), null);
            writableRaster = bufferedImage.getRaster();
            n6 = dArray.length;
            n5 = n6 / 2;
            d = 0.0;
            for (int i = 0; i < n6; ++i) {
                d += dArray[i];
            }
            double d2 = 1.0 / d;
            int[] nArray2 = new int[n8];
            nArray = new int[n8];
            for (int i = 0; i < n11; ++i) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(++n13);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                writableRaster2.getPixel(0, i, nArray2);
                writableRaster2.getPixel(n10, i, nArray);
                for (n4 = 0; n4 < n9; ++n4) {
                    for (n3 = 0; n3 < n8; ++n3) {
                        double d3 = 0.0;
                        n2 = n4 - n5;
                        for (n = 0; n < n6; ++n) {
                            d3 = n2 < 0 ? (d3 += (double)nArray2[n3] * dArray[n]) : (n2 >= n9 ? (d3 += (double)nArray[n3] * dArray[n]) : (d3 += (double)writableRaster2.getSample(n2, i, n3) * dArray[n]));
                            ++n2;
                        }
                        if ((d3 *= d2) > (double)n7) {
                            d3 = n7;
                        } else if (d3 < 0.0) {
                            d3 = 0.0;
                        }
                        writableRaster.setSample(n4, i, n3, d3);
                    }
                }
            }
            this.bim = bufferedImage;
        }
        if (null != dArray2) {
            WritableRaster writableRaster3 = this.bim.getRaster();
            bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster3.createCompatibleWritableRaster(n9, n11), this.bim.isAlphaPremultiplied(), null);
            writableRaster = bufferedImage.getRaster();
            n6 = dArray2.length;
            n5 = n6 / 2;
            d = 0.0;
            for (int i = 0; i < n6; ++i) {
                d += dArray2[i];
            }
            double d4 = 1.0 / d;
            float[] fArray = new float[n6];
            nArray = new int[n8];
            int[] nArray3 = new int[n8];
            for (n4 = 0; n4 < n9; ++n4) {
                if (null != progressMonitor) {
                    progressMonitor.setProgress(++n13);
                    if (progressMonitor.isCanceled()) {
                        progressMonitor.close();
                        return;
                    }
                }
                writableRaster3.getPixel(n4, 0, nArray);
                writableRaster3.getPixel(n4, n12, nArray3);
                for (n3 = 0; n3 < n11; ++n3) {
                    for (n2 = 0; n2 < n8; ++n2) {
                        double d5 = 0.0;
                        n = n3 - n5;
                        for (int i = 0; i < n6; ++i) {
                            d5 = n < 0 ? (d5 += (double)nArray[n2] * dArray[i]) : (n >= n11 ? (d5 += (double)nArray3[n2] * dArray[i]) : (d5 += (double)writableRaster3.getSample(n4, n, n2) * dArray[i]));
                            ++n;
                        }
                        for (n = 0; n < n6; ++n) {
                            d5 += (double)fArray[n] * dArray2[n];
                        }
                        if ((d5 *= d4) > (double)n7) {
                            d5 = n7;
                        } else if (d5 < 0.0) {
                            d5 = 0.0;
                        }
                        writableRaster.setSample(n4, n3, n2, d5);
                    }
                }
            }
            this.bim = bufferedImage;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
    }

    @Override
    public void correctBackground(double d, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Timer timer = new Timer("Image8or16Base.correctBackground", this);
        int n9 = this.getWidth();
        int n10 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        int n11 = n9 / n;
        int n12 = n10 / n;
        int n13 = this.getMaxLevel() + 1;
        int n14 = n11 / 2;
        int n15 = n12 / 2;
        int n16 = n9 / n11;
        int n17 = n10 / n12;
        int n18 = this.getNBands();
        int[] nArray = new int[n18];
        int[][][] nArray2 = new int[n16][n17][n18];
        int[][] nArray3 = new int[n13][n18];
        for (n8 = 0; n8 < n17; ++n8) {
            for (n7 = 0; n7 < n16; ++n7) {
                int n19;
                for (n6 = 0; n6 < n18; ++n6) {
                    for (n19 = 0; n19 < n13; ++n19) {
                        nArray3[n19][n6] = 0;
                    }
                }
                for (n6 = n8 * n12; n6 < (n8 + 1) * n12; ++n6) {
                    for (n19 = n7 * n11; n19 < (n7 + 1) * n11; ++n19) {
                        writableRaster.getPixel(n19, n6, nArray);
                        for (n5 = 0; n5 < n18; ++n5) {
                            n4 = nArray[n5];
                            if (0 > n4 || n4 >= n13) continue;
                            int[] nArray4 = nArray3[n4];
                            int n20 = n5;
                            nArray4[n20] = nArray4[n20] + 1;
                        }
                    }
                }
                for (n6 = 0; n6 < n18; ++n6) {
                    nArray2[n7][n8][n6] = 0;
                    n19 = nArray3[0][n6];
                    n5 = nArray3[0][n6];
                    n4 = 0;
                    n3 = 0;
                    for (n2 = 1; n2 < n13 - 1; ++n2) {
                        if (nArray3[n2][n6] <= n19) continue;
                        n19 = nArray3[n2][n6];
                        n4 = n2;
                    }
                    for (n2 = n13 - 2; n2 >= 0; --n2) {
                        if (nArray3[n2][n6] <= n5) continue;
                        n5 = nArray3[n2][n6];
                        n3 = n2;
                    }
                    nArray2[n7][n8][n6] = (n4 + n3) / 2;
                }
            }
        }
        for (n8 = 0; n8 < n17; ++n8) {
            for (n7 = 0; n7 < n16; ++n7) {
                for (n6 = 0; n6 < n18; ++n6) {
                    nArray2[n7][n8][n6] = (int)(d * (double)nArray2[n7][n8][n6]);
                }
            }
        }
        for (n3 = 0; n3 < n17; ++n3) {
            for (n2 = 0; n2 < n16; ++n2) {
                int n21 = n3 * n12;
                int n22 = 0;
                while (n21 < (n3 + 1) * n12) {
                    float f;
                    if (n22 < n15) {
                        f = (float)(n15 + n22) / (float)n12;
                        n4 = n3 - 1;
                    } else {
                        f = (float)(n22 - n15) / (float)n12;
                        n4 = n3;
                    }
                    float f2 = 1.0f - f;
                    int n23 = n2 * n11;
                    int n24 = 0;
                    while (n23 < (n2 + 1) * n11) {
                        float f3;
                        writableRaster.getPixel(n23, n21, nArray);
                        if (n24 < n14) {
                            f3 = (float)(n14 + n24) / (float)n11;
                            n5 = n2 - 1;
                        } else {
                            f3 = (float)(n24 - n14) / (float)n11;
                            n5 = n2;
                        }
                        float f4 = 1.0f - f3;
                        for (int i = 0; i < n18; ++i) {
                            if (n4 < 0 || n4 + 1 >= n17 || n5 < 0 || n5 + 1 >= n16) {
                                if (n4 < 0 || n4 + 1 >= n17) {
                                    if (n5 < 0 || n5 + 1 >= n16) {
                                        int n25 = i;
                                        nArray[n25] = nArray[n25] - nArray2[n2][n3][i];
                                    } else {
                                        int n26 = i;
                                        nArray[n26] = nArray[n26] - (int)(0.5f + f3 * (float)nArray2[n5 + 1][n3][i] + f4 * (float)nArray2[n5][n3][i]);
                                    }
                                } else if (n5 < 0 || n5 + 1 >= n16) {
                                    if (n4 < 0 || n4 + 1 >= n17) {
                                        int n27 = i;
                                        nArray[n27] = nArray[n27] - nArray2[n2][n3][i];
                                    } else {
                                        int n28 = i;
                                        nArray[n28] = nArray[n28] - (int)(0.5f + f * (float)nArray2[n2][n4 + 1][i] + f2 * (float)nArray2[n2][n4][i]);
                                    }
                                }
                            } else {
                                int n29 = i;
                                nArray[n29] = nArray[n29] - (int)(0.5f + f * (f3 * (float)nArray2[n5 + 1][n4 + 1][i] + f4 * (float)nArray2[n5][n4 + 1][i]) + f2 * (f3 * (float)nArray2[n5 + 1][n4][i] + f4 * (float)nArray2[n5][n4][i]));
                            }
                            if (nArray[i] >= 0) continue;
                            nArray[i] = 0;
                        }
                        writableRaster.setPixel(n23, n21, nArray);
                        ++n23;
                        ++n24;
                    }
                    ++n21;
                    ++n22;
                }
            }
        }
        timer.stop();
    }

    @Override
    public void crop(Point point, Point point2) {
        Timer timer = new Timer("Image8or16Base.crop", this);
        Point point3 = new Point(Math.min(point.x, point2.x), Math.min(point.y, point2.y));
        Point point4 = new Point(Math.max(point.x, point2.x), Math.max(point.y, point2.y));
        int n = point4.x - point3.x + 1;
        int n2 = point4.y - point3.y + 1;
        int n3 = n;
        int n4 = n2;
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n3, n4), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n5 = this.getNBands();
        int[] nArray = new int[n5];
        int n6 = point3.y;
        for (int i = 0; i < n4; ++i) {
            int n7 = point3.x;
            for (int j = 0; j < n3; ++j) {
                writableRaster.getPixel(n7, n6, nArray);
                writableRaster2.setPixel(j, i, nArray);
                ++n7;
            }
            ++n6;
        }
        this.setBufferedImage(bufferedImage);
        timer.stop();
    }

    @Override
    public void deconvolve(Kernel kernel, int n, double d, ProgressMonitor progressMonitor) {
        Timer timer = new Timer("Image8or16Base.deconvolve", this);
        int n2 = this.getNBands();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getRange().high;
        WritableRaster writableRaster = this.bim.getRaster();
        WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster(n3, n4);
        this.bim.copyData(writableRaster2);
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster2, this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster3 = writableRaster.createCompatibleWritableRaster(n3, n4);
        BufferedImage bufferedImage2 = new BufferedImage(this.bim.getColorModel(), writableRaster3, this.bim.isAlphaPremultiplied(), null);
        int n6 = kernel.getHalfWidth();
        int n7 = 2 * n6 + 1;
        int n8 = n7 * n7;
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = 0.0f;
        }
        float[][] fArray2 = kernel.getData();
        int n9 = 0;
        if (fArray2.length == n2) {
            n9 = 1;
        }
        int n10 = 0;
        int n11 = 0;
        while (n10 < n2) {
            for (int i = 0; i < fArray2[n11].length; ++i) {
                int n12 = n10;
                fArray[n12] = fArray[n12] + fArray2[n11][i];
            }
            ++n10;
            n11 += n9;
        }
        float[] fArray3 = new float[n2];
        for (n11 = 0; n11 < n2; ++n11) {
            fArray3[n11] = fArray[n11] != 0.0f ? 1.0f / fArray[n11] : 1.0f;
        }
        float[] fArray4 = new float[n8];
        int n13 = 0;
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n * n2 * n4);
        }
        for (int i = 0; i < n; ++i) {
            int n14 = 0;
            int n15 = 0;
            while (n14 < n2) {
                float[] fArray5 = fArray2[n15];
                int n16 = 0;
                int n17 = n6;
                while (n16 < n4 - n7) {
                    if (null != progressMonitor) {
                        progressMonitor.setProgress(++n13);
                        if (progressMonitor.isCanceled()) {
                            progressMonitor.close();
                            return;
                        }
                    }
                    int n18 = 0;
                    int n19 = n6;
                    while (n18 < n3 - n7) {
                        int n20;
                        writableRaster2.getSamples(n18, n16, n7, n7, n14, fArray4);
                        float f = 0.0f;
                        for (n20 = 0; n20 < n8; ++n20) {
                            f += fArray4[n20] * fArray5[n20];
                        }
                        n20 = writableRaster.getSample(n19, n17, n14);
                        int n21 = writableRaster2.getSample(n19, n17, n14);
                        if ((n21 = (int)((double)n21 + d * (double)((float)n20 - (f *= fArray3[n14])))) > n5) {
                            n21 = n5;
                        } else if (n21 < 0) {
                            n21 = 0;
                        }
                        writableRaster3.setSample(n19, n17, n14, n21);
                        ++n18;
                        ++n19;
                    }
                    ++n16;
                    ++n17;
                }
                ++n14;
                n15 += n9;
            }
            WritableRaster writableRaster4 = writableRaster2;
            writableRaster2 = writableRaster3;
            writableRaster3 = writableRaster4;
            BufferedImage bufferedImage3 = bufferedImage;
            bufferedImage = bufferedImage2;
            bufferedImage2 = bufferedImage3;
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        this.setBufferedImage(bufferedImage);
        timer.stop();
    }

    @Override
    public void dispose() {
        if (null != this.bim) {
            this.bim.flush();
        }
        if (null != this.metadata) {
            this.metadata.clear();
        }
    }

    @Override
    public void divide(int n) {
        Timer timer = new Timer("Image8or16Base.divideAmplitudeByN", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        for (int i = 0; i < this.bim.getHeight(); ++i) {
            for (int j = 0; j < this.bim.getWidth(); ++j) {
                writableRaster.getPixel(j, i, nArray);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = n3++;
                    nArray[n4] = nArray[n4] / n;
                }
                writableRaster.setPixel(j, i, nArray);
            }
        }
        timer.stop();
    }

    @Override
    public void divideByFlatField(Image image) {
        int n;
        int n2;
        int n3;
        if (!(image instanceof Image8or16Base)) {
            Util.warning("Sorry", "Cannot divide 8 or 16 bit image by one having more bits per channel");
            return;
        }
        BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
        Timer timer = new Timer("Image8or16Base.divideByFlatField", this);
        WritableRaster writableRaster = this.bim.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n4 = this.getNBands();
        int n5 = this.getMaxLevel();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        float[] fArray = new float[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            fArray[n3] = 0.0f;
        }
        for (n3 = 0; n3 < bufferedImage.getHeight(); ++n3) {
            for (n2 = 0; n2 < bufferedImage.getWidth(); ++n2) {
                writableRaster2.getPixel(n2, n3, nArray2);
                for (n = 0; n < n4; ++n) {
                    float f = nArray2[n];
                    if (!(f > fArray[n])) continue;
                    fArray[n] = f;
                }
            }
        }
        for (n3 = 0; n3 < Math.min(this.getHeight(), bufferedImage.getHeight()); ++n3) {
            for (n2 = 0; n2 < Math.min(this.getWidth(), bufferedImage.getWidth()); ++n2) {
                writableRaster.getPixel(n2, n3, nArray);
                writableRaster2.getPixel(n2, n3, nArray2);
                for (n = 0; n < n4; ++n) {
                    nArray[n] = Math.min(n5, (int)((float)nArray[n] * fArray[n] / (float)nArray2[n]));
                }
                writableRaster.setPixel(n2, n3, nArray);
            }
        }
        timer.stop();
    }

    @Override
    public void drawRim(int n, Color color) {
        int n2;
        int n3;
        int n4 = Math.min(3, this.getNBands());
        double d = (double)this.getRange().high / 255.0;
        int[] nArray = new int[n4];
        nArray[0] = (int)((double)color.getRed() * d);
        if (n4 > 1) {
            nArray[1] = (int)((double)color.getGreen() * d);
        }
        if (n4 > 2) {
            nArray[2] = (int)((double)color.getBlue() * d);
        }
        int n5 = this.getWidth();
        int n6 = n5 - 1;
        int n7 = this.getHeight();
        int n8 = n7 - 1;
        WritableRaster writableRaster = this.getBufferedImage().getRaster();
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                writableRaster.setPixel(n3, n2, nArray);
                writableRaster.setPixel(n3, n8 - n2, nArray);
            }
        }
        for (n3 = 0; n3 < n7; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                writableRaster.setPixel(n2, n3, nArray);
                writableRaster.setPixel(n6 - n2, n3, nArray);
            }
        }
    }

    @Override
    public void fit(int n, int n2) {
        Timer timer = new Timer("Image8or16Base.fit", this);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        double d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
        double d2 = 1.0 / d;
        int n5 = (int)((double)n3 * d);
        int n6 = (int)((double)n4 * d);
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n5, n6), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n7 = this.getNBands();
        int[] nArray = new int[n7];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                nArray = Interpolator.getPixel(writableRaster, (double)j * d2, (double)i * d2);
                writableRaster2.setPixel(j, i, nArray);
            }
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public void flipHorizontal() {
        Timer timer = new Timer("Image8or16Base.flipHorizontal", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = this.getHeight();
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i = this.bim.getWidth() - 1; n3 < i; ++n3, --i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(n3, j, nArray);
                writableRaster.getPixel(i, j, nArray2);
                writableRaster.setPixel(i, j, nArray);
                writableRaster.setPixel(n3, j, nArray2);
            }
        }
        timer.stop();
    }

    @Override
    public void flipVertical() {
        Timer timer = new Timer("Image8or16Base.flipVertical", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = this.getWidth();
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i = this.bim.getHeight() - 1; n3 < i; ++n3, --i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, n3, nArray);
                writableRaster.getPixel(j, i, nArray2);
                writableRaster.setPixel(j, i, nArray);
                writableRaster.setPixel(j, n3, nArray2);
            }
        }
        timer.stop();
    }

    @Override
    public int getBitsPerChannel() {
        return Image8or16Base.getBitsPerChannel(this.bim);
    }

    public static int getBitsPerChannel(BufferedImage bufferedImage) {
        return bufferedImage.getSampleModel().getSampleSize(0);
    }

    @Override
    public RangeInt[] getChannelRanges() {
        int n = this.getNBands();
        RangeInt[] rangeIntArray = new RangeInt[n];
        int n2 = this.getMaxLevel();
        for (int i = 0; i < n; ++i) {
            rangeIntArray[i] = new RangeInt(0, n2);
        }
        return rangeIntArray;
    }

    @Override
    public RangeDouble[] getChannelRangesDouble() {
        int n = this.getNBands();
        RangeDouble[] rangeDoubleArray = new RangeDouble[n];
        int n2 = this.getMaxLevel();
        for (int i = 0; i < n; ++i) {
            rangeDoubleArray[i] = new RangeDouble(0.0, n2);
        }
        return rangeDoubleArray;
    }

    @Override
    public int getHeight() {
        return this.bim.getHeight();
    }

    @Override
    public String getImageTypeAsString() {
        if (null != this.getBufferedImage()) {
            return Image8or16Base.getImageTypeAsString(this.getBufferedImage());
        }
        return "(no image)";
    }

    public static String getImageTypeAsString(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 5: {
                return "TYPE_3BYTE_BGR";
            }
            case 6: {
                return "TYPE_4BYTE_ABGR";
            }
            case 7: {
                return "TYPE_4BYTE_ABGR_PRE";
            }
            case 12: {
                return "TYPE_BYTE_BINARY";
            }
            case 13: {
                return "TYPE_BYTE_INDEXED";
            }
            case 10: {
                return "TYPE_BYTE_GRAY";
            }
            case 9: {
                return "TYPE_USHORT_555_RGB";
            }
            case 8: {
                return "TYPE_USHORT_565_RGB";
            }
            case 11: {
                return "TYPE_USHORT_GRAY";
            }
            case 1: {
                return "TYPE_INT_RGB";
            }
            case 4: {
                return "TYPE_INT_BGR";
            }
            case 2: {
                return "TYPE_INT_ARGB";
            }
            case 3: {
                return "TYPE_INT_ARGB_PRE";
            }
            case 0: {
                return "TYPE_CUSTOM";
            }
        }
        return "UNKNOWN";
    }

    public int getMaxLevel() {
        return Image8or16Base.getMaxLevel(this.bim);
    }

    public static int getMaxLevel(BufferedImage bufferedImage) {
        switch (Image8or16Base.getBitsPerChannel(bufferedImage)) {
            case 16: {
                return 65535;
            }
            case 15: {
                return Short.MAX_VALUE;
            }
            case 14: {
                return 16383;
            }
            case 13: {
                return 8191;
            }
            case 12: {
                return 4095;
            }
            case 11: {
                return 2047;
            }
            case 10: {
                return 1023;
            }
            case 9: {
                return 511;
            }
            case 8: {
                return 255;
            }
            case 7: {
                return 127;
            }
            case 6: {
                return 63;
            }
            case 5: {
                return 31;
            }
            case 4: {
                return 15;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 65535;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public int getNBands() {
        return Image8or16Base.getNBands(this.bim);
    }

    public static int getNBands(BufferedImage bufferedImage) {
        return bufferedImage.getSampleModel().getNumBands();
    }

    @Override
    public RangeInt getRangeByRescanning() {
        int n = this.getMaxLevel();
        return new RangeInt(0, n);
    }

    @Override
    public RangeDouble getRangeByRescanningDouble() {
        int n = this.getMaxLevel();
        return new RangeDouble(0.0, n);
    }

    @Override
    public int[] getPixel(int n, int n2) {
        if (n < 0 || n >= this.getWidth() || n2 < 0 || n2 >= this.getHeight()) {
            return this.zeroPxInt;
        }
        int[] nArray = new int[this.getNBands()];
        return this.bim.getRaster().getPixel(n, n2, nArray);
    }

    @Override
    public double[] getPixelDouble(int n, int n2) {
        if (n < 0 || n >= this.getWidth() || n2 < 0 || n2 >= this.getHeight()) {
            return this.zeroPxDouble;
        }
        double[] dArray = new double[this.getNBands()];
        return this.bim.getRaster().getPixel(n, n2, dArray);
    }

    @Override
    public double[] getPixelDoubleInterpolated(double d, double d2) {
        int n = this.getNBands();
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        nArray = Interpolator.getPixel(this.bim.getRaster(), d, d2);
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    @Override
    public int[] getPixelInterpolated(double d, double d2) {
        return Interpolator.getPixel(this.bim.getRaster(), d, d2);
    }

    @Override
    public RangeInt getRange() {
        return new RangeInt(0, this.getMaxLevel());
    }

    @Override
    public RangeDouble getRangeDouble() {
        return new RangeDouble(0.0, this.getMaxLevel());
    }

    @Override
    public int getWidth() {
        return this.bim.getWidth();
    }

    public BufferedImage gnomonicProjection(BufferedImage bufferedImage, int n, double d, double d2) {
        if (0 < n) {
            Timer timer = new Timer("Image8or16Base.gnomonicProjection", bufferedImage);
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            double d3 = 2.0 * (double)n;
            double d4 = Math.atan2(d, d3);
            double d5 = d / d3;
            double d6 = (double)n2 * 0.5 / d4;
            double d7 = d6 * d5;
            double d8 = 1.0 / d6;
            double d9 = Math.sqrt(n2 * n2 + n3 * n3) * 0.5;
            double d10 = Math.atan2(n3, n2);
            double d11 = d6 * Math.tan(d8 * d9);
            int n4 = (int)Math.floor(d11 * Math.cos(d10));
            int n5 = (int)Math.floor(d11 * Math.sin(d10));
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.getRaster().createCompatibleWritableRaster(2 * n4, 2 * n5), bufferedImage.isAlphaPremultiplied(), null);
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            int[] nArray = new int[Image8or16Base.getNBands(bufferedImage)];
            int n6 = n2 / 2;
            int n7 = n3 / 2;
            int n8 = 0;
            int n9 = -n5;
            while (n8 < bufferedImage2.getHeight()) {
                double d12 = n9 * n9;
                int n10 = 0;
                int n11 = -n4;
                while (n10 < bufferedImage2.getWidth()) {
                    double d13 = Math.sqrt((double)(n11 * n11) + d12);
                    double d14 = d6 * Math.atan2(d13 * d5, d7);
                    double d15 = d14 / d13;
                    double d16 = (double)n11 * d15 + (double)n6;
                    double d17 = (double)n9 * d15 + (double)n7;
                    nArray = Interpolator.getPixel(writableRaster, d16, d17);
                    writableRaster2.setPixel(n10, n8, nArray);
                    ++n10;
                    ++n11;
                }
                ++n8;
                ++n9;
            }
            timer.stop();
            return bufferedImage2;
        }
        return bufferedImage;
    }

    protected BufferedImage inverseGnomonicProjection(BufferedImage bufferedImage, int n, double d, double d2) {
        if (0 < n) {
            Timer timer = new Timer("Image8or16Base.inverseGnomonicProjection", bufferedImage);
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            double d3 = (double)n2 * 0.5;
            double d4 = (double)n3 * 0.5;
            double d5 = 2.0 * (double)n;
            double d6 = Math.atan2(d, d5);
            double d7 = Math.atan2(d2, d5);
            double d8 = d / d5;
            double d9 = d2 / d5;
            double d10 = d3 / d8;
            double d11 = d4 / d9;
            double d12 = d8 / d3;
            int n4 = (int)Math.floor(d6 * d10);
            int n5 = (int)Math.floor(d7 * d11);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.getRaster().createCompatibleWritableRaster(2 * n4, 2 * n5), bufferedImage.isAlphaPremultiplied(), null);
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            int[] nArray = new int[Image8or16Base.getNBands(bufferedImage)];
            int n6 = n2 / 2;
            int n7 = n3 / 2;
            int n8 = 0;
            int n9 = -n5;
            while (n8 < bufferedImage2.getHeight()) {
                double d13 = n9 * n9;
                int n10 = 0;
                int n11 = -n4;
                while (n10 < bufferedImage2.getWidth()) {
                    double d14 = Math.sqrt((double)(n11 * n11) + d13);
                    double d15 = d10 * Math.tan(d12 * d14);
                    double d16 = d15 / d14;
                    double d17 = (double)n11 * d16 + (double)n6;
                    double d18 = (double)n9 * d16 + (double)n7;
                    nArray = Interpolator.getPixel(writableRaster, d17, d18);
                    writableRaster2.setPixel(n10, n8, nArray);
                    ++n10;
                    ++n11;
                }
                ++n8;
                ++n9;
            }
            timer.stop();
            return bufferedImage2;
        }
        return bufferedImage;
    }

    @Override
    public void invert() {
        Timer timer = new Timer("Image8or16.invert", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = this.getNBands();
        int[] nArray = new int[n];
        int n2 = this.getMaxLevel();
        for (int i = 0; i < writableRaster.getHeight(); ++i) {
            for (int j = 0; j < writableRaster.getWidth(); ++j) {
                writableRaster.getPixel(j, i, nArray);
                for (int k = 0; k < n; ++k) {
                    nArray[k] = n2 - nArray[k];
                }
                writableRaster.setPixel(j, i, nArray);
            }
        }
        timer.stop();
    }

    @Override
    public void meanFilter(int n, ProgressMonitor progressMonitor) {
        Timer timer = new Timer("Image8or16Base.meanFilter", this);
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int n3 = 2 * n + 1;
        int n4 = n3 * n3;
        int[] nArray2 = new int[n2];
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n5, n6), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n6 - n);
        }
        for (int i = n; i < writableRaster2.getHeight() - n; ++i) {
            if (null != progressMonitor) {
                progressMonitor.setProgress(i);
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    return;
                }
            }
            for (int j = n; j < writableRaster2.getWidth() - n; ++j) {
                int n7;
                for (n7 = 0; n7 < n2; ++n7) {
                    nArray2[n7] = 0;
                }
                n7 = 0;
                for (int k = i - n; k <= i + n; ++k) {
                    int n8 = j - n;
                    while (n8 <= j + n) {
                        writableRaster.getPixel(n8, k, nArray);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int n9 = i2;
                            nArray2[n9] = nArray2[n9] + nArray[i2];
                        }
                        ++n8;
                        ++n7;
                    }
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    nArray[n7] = nArray2[n7] / n4;
                }
                writableRaster2.setPixel(j, i, nArray);
            }
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public void medianFilter(int n, ProgressMonitor progressMonitor) {
        Timer timer = new Timer("Image8or16.medianFilter", this);
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int n3 = 2 * n + 1;
        int n4 = n3 * n3;
        int n5 = n4 / 2;
        int[][] nArray2 = new int[n2][n4];
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n6, n7), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n7 - n);
        }
        for (int i = n; i < writableRaster2.getHeight() - n; ++i) {
            if (null != progressMonitor) {
                progressMonitor.setProgress(i);
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    return;
                }
            }
            for (int j = n; j < writableRaster2.getWidth() - n; ++j) {
                int n8 = 0;
                for (int k = i - n; k <= i + n; ++k) {
                    int n9 = j - n;
                    while (n9 <= j + n) {
                        writableRaster.getPixel(n9, k, nArray);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            nArray2[i2][n8] = nArray[i2];
                        }
                        ++n9;
                        ++n8;
                    }
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    Arrays.sort(nArray2[n8]);
                    nArray[n8] = nArray2[n8][n5];
                }
                writableRaster2.setPixel(j, i, nArray);
            }
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public void multiply(double d) {
        Timer timer = new Timer("Image.multiply", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getNumBands();
        int[] nArray = new int[n3];
        int n4 = this.getMaxLevel();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, i, nArray);
                for (int k = 0; k < n3; ++k) {
                    nArray[k] = (int)Math.round((double)nArray[k] * d);
                    if (nArray[k] >= 0 && nArray[k] <= n4) continue;
                    nArray[k] = n4;
                }
                writableRaster.setPixel(j, i, nArray);
            }
        }
        timer.stop();
    }

    @Override
    public void multiply(Image image) {
        Timer timer = new Timer("Image8or16Base.multiply", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getNumBands();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = this.getMaxLevel();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, i, nArray);
                nArray2 = image.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray[k] = nArray[k] * nArray2[k];
                    if (nArray[k] >= 0) continue;
                    nArray[k] = n4;
                }
                writableRaster.setPixel(j, i, nArray);
            }
        }
        timer.stop();
    }

    @Override
    public void multiply(Image image, double d, double d2) {
        Timer timer = new Timer("Image.multiply", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = this.getNBands();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double d3 = this.getRange().high;
        double d4 = image.getRange().high;
        double d5 = d3 / Math.sqrt(d3 * (d * d3 + d2 * d4));
        for (int i = 0; i < Math.min(this.getHeight(), image.getHeight()); ++i) {
            for (int j = 0; j < Math.min(this.getWidth(), image.getWidth()); ++j) {
                writableRaster.getPixel(j, i, nArray);
                nArray2 = image.getPixel(j, i);
                for (int k = 0; k < n; ++k) {
                    int n2 = (int)(d5 * Math.sqrt((double)nArray[k] * (d * (double)nArray[k] + d2 * (double)nArray2[k])));
                    if (n2 < 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                    nArray[k] = n2;
                }
                writableRaster.setPixel(j, i, nArray);
            }
        }
        timer.stop();
    }

    @Override
    public void nearestExtremeFilter(int n, ProgressMonitor progressMonitor) {
        Timer timer = new Timer("Image8or16Base.nearestExtremeFilter", this);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n2, n3), this.bim.isAlphaPremultiplied(), null);
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int n5 = this.getMaxLevel();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n3 - n);
        }
        for (int i = n; i < writableRaster2.getHeight() - n; ++i) {
            if (null != progressMonitor) {
                progressMonitor.setProgress(i);
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    return;
                }
            }
            for (int j = n; j < writableRaster2.getWidth() - n; ++j) {
                int n6;
                for (n6 = 0; n6 < n4; ++n6) {
                    nArray2[n6] = n5;
                    nArray3[n6] = 0;
                }
                n6 = 0;
                for (int k = i - n; k <= i + n; ++k) {
                    int n7 = j - n;
                    while (n7 <= j + n) {
                        writableRaster.getPixel(n7, k, nArray);
                        for (int i2 = 0; i2 < n4; ++i2) {
                            if (nArray[i2] < nArray2[i2]) {
                                nArray2[i2] = nArray[i2];
                            }
                            if (nArray[i2] <= nArray3[i2]) continue;
                            nArray3[i2] = nArray[i2];
                        }
                        ++n7;
                        ++n6;
                    }
                }
                writableRaster.getPixel(j, i, nArray);
                for (n6 = 0; n6 < n4; ++n6) {
                    nArray[n6] = nArray[n6] - nArray2[n6] < nArray3[n6] - nArray[n6] ? nArray2[n6] : nArray3[n6];
                }
                writableRaster2.setPixel(j, i, nArray);
            }
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public void neutraliseBackground() {
        int n = this.getNBands();
        if (1 == n) {
            Util.message("Information", "Colour balancing is not relevant for monochrome (1-channel) images");
        } else {
            Timer timer = new Timer("Image8or16.neutraliseBackground", this);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            int n4 = this.getMaxLevel();
            Statistics[] statisticsArray = new HistogramAll(this).getStatistics();
            int n5 = statisticsArray[0].mode;
            int n6 = 0;
            for (int i = 1; i < n; ++i) {
                if (statisticsArray[i].mode >= n5) continue;
                n5 = statisticsArray[i].mode;
                n6 = i;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = (float)(n4 - n5) / (float)(n4 - statisticsArray[i].mode);
            }
            int[][] nArray = new int[n][n4 + 1];
            for (int i = 0; i <= n4; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray[j][i] = Math.max(0, n4 - (int)((float)(n4 - i) * fArray[j]));
                }
            }
            WritableRaster writableRaster = this.bim.getRaster();
            int[] nArray2 = new int[n];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    writableRaster.getPixel(j, i, nArray2);
                    for (int k = 0; k < n; ++k) {
                        if (k == n6) continue;
                        nArray2[k] = nArray[k][nArray2[k]];
                    }
                    writableRaster.setPixel(j, i, nArray2);
                }
            }
            timer.stop();
        }
    }

    @Override
    public void rankFilter(int n, ProgressMonitor progressMonitor) {
        Timer timer = new Timer("Image8or16Base.rankFilter", this);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n2, n3), this.bim.isAlphaPremultiplied(), null);
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        int n5 = this.getMaxLevel();
        float f = 2 * n + 1;
        float f2 = (float)n5 / (f * f);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n3 - n);
        }
        for (int i = n; i < writableRaster2.getHeight() - n; ++i) {
            if (null != progressMonitor) {
                progressMonitor.setProgress(i);
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    return;
                }
            }
            for (int j = n; j < writableRaster2.getWidth() - n; ++j) {
                int n6;
                for (n6 = 0; n6 < n4; ++n6) {
                    nArray3[n6] = 0;
                    nArray4[n6] = 0;
                }
                writableRaster.getPixel(j, i, nArray);
                n6 = 0;
                for (int k = i - n; k <= i + n; ++k) {
                    int n7 = j - n;
                    while (n7 <= j + n) {
                        writableRaster.getPixel(n7, k, nArray2);
                        for (int i2 = 0; i2 < n4; ++i2) {
                            if (nArray2[i2] < nArray[i2]) {
                                int n8 = i2;
                                nArray3[n8] = nArray3[n8] + 1;
                                continue;
                            }
                            if (nArray2[i2] != nArray[i2]) continue;
                            int n9 = i2;
                            nArray4[n9] = nArray4[n9] + 1;
                        }
                        ++n7;
                        ++n6;
                    }
                }
                for (n6 = 0; n6 < n4; ++n6) {
                    nArray[n6] = (int)(f2 * (float)(nArray3[n6] + nArray4[n6] / 2));
                }
                writableRaster2.setPixel(j, i, nArray);
            }
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public void reapplyColour(Image image, Image image2) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = image2.getNBands();
        int n4 = image2.getRange().high;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = image.getPixel(j, i)[0];
                int[] nArray = image2.getPixel(j, i);
                for (int k = 0; k < n3; ++k) {
                    nArray[k] = (int)Math.round((double)n5 * (double)nArray[k] / (double)n4);
                }
                this.setPixel(j, i, nArray);
            }
        }
    }

    @Override
    public void rotate(double d) {
        Timer timer = new Timer("Image8or16.rotate", this);
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = (int)Math.floor(Math.abs((double)n * d4) + Math.abs((double)n2 * d3));
        int n6 = (int)Math.floor(Math.abs((double)n * d3) + Math.abs((double)n2 * d4));
        int n7 = this.getNBands();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n5, n6), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int[] nArray = new int[n7];
        int n8 = 0;
        int n9 = -n6 / 2;
        while (n8 < n6) {
            int n10 = 0;
            int n11 = -n5 / 2;
            while (n10 < n5) {
                double d5 = (double)n11 * d4 - (double)n9 * d3;
                double d6 = (double)n11 * d3 + (double)n9 * d4;
                nArray = Interpolator.getPixel(writableRaster, d5 + (double)n3, d6 + (double)n4);
                writableRaster2.setPixel(n10, n8, nArray);
                ++n10;
                ++n11;
            }
            ++n8;
            ++n9;
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public void save(String string) {
        try {
            File file = new File(string);
            Timer timer = new Timer("Image8or16Base.save(" + file.getName() + ")", this);
            String string2 = file.getName().toLowerCase();
            if (string2.endsWith(".fits")) {
                new FITS().saveImage(file.getPath(), this);
            } else {
                String string3 = ImageLoader.getFormat(file.getName());
                if (string3.length() == 0) {
                    Util.warning("Warning", "You must put an extension on the file name");
                } else {
                    Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string3);
                    if (iterator.hasNext()) {
                        Object object;
                        ImageWriter imageWriter = iterator.next();
                        String string4 = imageWriter.getClass().getName();
                        Util.logInfo("Writer class: {0}", string4);
                        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
                        imageWriter.setOutput(fileImageOutputStream);
                        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                        if (string3.equals("tiff")) {
                            imageWriteParam.setCompressionMode(0);
                        } else {
                            if (imageWriteParam.canWriteCompressed()) {
                                imageWriteParam.setCompressionMode(2);
                                object = imageWriteParam.getCompressionTypes();
                                if (null != object) {
                                    imageWriteParam.setCompressionType(object[0]);
                                }
                                imageWriteParam.setCompressionQuality(1.0f);
                            }
                            if (imageWriteParam instanceof JPEGImageWriteParam) {
                                ((JPEGImageWriteParam)imageWriteParam).setOptimizeHuffmanTables(true);
                            }
                        }
                        object = new ImageTypeSpecifier(this.getBufferedImage());
                        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata((ImageTypeSpecifier)object, imageWriteParam);
                        if (null == iIOMetadata) {
                            Util.logWarning("Could not get default image metadata");
                        } else {
                            IIOImage iIOImage = new IIOImage(this.getBufferedImage(), null, iIOMetadata);
                            if (null != this.metadata) {
                                this.metadata.mergeIntoIIOI(iIOImage);
                            }
                            this.setDateTimeMetadata(iIOMetadata);
                            IIOMetadata iIOMetadata2 = imageWriter.convertImageMetadata(iIOMetadata, (ImageTypeSpecifier)object, imageWriteParam);
                            imageWriter.write(iIOMetadata2, iIOImage, imageWriteParam);
                        }
                        imageWriter.dispose();
                        fileImageOutputStream.close();
                        this.setFilePath(string);
                    } else {
                        Util.warning("Error", "No writer available for " + file.getName());
                    }
                }
                timer.stop();
            }
        }
        catch (IOException iOException) {
            Util.warning("Exception", iOException.toString());
        }
    }

    @Override
    public void save(String string, RangeInt rangeInt) {
        this.save(string);
    }

    @Override
    public void save(String string, RangeDouble rangeDouble) {
        this.save(string);
    }

    @Override
    public void saveAsFITS(String string) {
        new FITS().saveImage(string, this);
    }

    @Override
    public void scale(double d, boolean bl) {
        Timer timer = new Timer("Image8or16Base.scale", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = (int)Math.floor((double)n * d);
        int n6 = (int)Math.floor((double)n2 * d);
        int n7 = this.getNBands();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n5, n6), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int[] nArray = new int[n7];
        double d2 = 1.0 / d;
        if (bl) {
            int n8 = 0;
            int n9 = -n6 / 2;
            while (n8 < n6) {
                int n10 = 0;
                int n11 = -n5 / 2;
                while (n10 < n5) {
                    double d3 = (double)n11 * d2;
                    double d4 = (double)n9 * d2;
                    nArray = Interpolator.getPixel(writableRaster, d3 + (double)n3, d4 + (double)n4);
                    writableRaster2.setPixel(n10, n8, nArray);
                    ++n10;
                    ++n11;
                }
                ++n8;
                ++n9;
            }
        } else {
            int n12 = 0;
            int n13 = -n6 / 2;
            while (n12 < n6) {
                int n14 = 0;
                int n15 = -n5 / 2;
                while (n14 < n5) {
                    double d5 = (double)n15 * d2;
                    double d6 = (double)n13 * d2;
                    writableRaster.getPixel((int)(d5 + (double)n3), (int)(d6 + (double)n4), nArray);
                    writableRaster2.setPixel(n14, n12, nArray);
                    ++n14;
                    ++n15;
                }
                ++n12;
                ++n13;
            }
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    @Override
    public BufferedImage scaleDownForDisplay(int n) {
        int n2;
        BufferedImage bufferedImage = this.bim;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = Image8or16Base.getMaxLevel(bufferedImage);
        int n5 = Image8or16Base.getNBands(bufferedImage);
        int n6 = n3 / n;
        int n7 = n4 / n;
        BufferedImage bufferedImage2 = Image8or16Base.getGraphicsConfiguration().createCompatibleImage(n6, n7);
        double d2 = Image8or16Base.getMaxLevel(bufferedImage2);
        int n8 = Image8or16Base.getNBands(bufferedImage2);
        double d3 = d2 / d;
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n8];
        for (n2 = 0; n2 < n8; ++n2) {
            nArray2[n2] = 0;
        }
        if (1 == n5) {
            n2 = 0;
            for (int i = 0; i < n7; ++i) {
                int n9 = 0;
                for (int j = 0; j < n6; ++j) {
                    writableRaster.getPixel(n9, n2, nArray);
                    int n10 = (int)((double)nArray[0] * d3);
                    for (int k = 0; k < n8; ++k) {
                        nArray2[k] = n10;
                    }
                    writableRaster2.setPixel(j, i, nArray2);
                    n9 += n;
                }
                n2 += n;
            }
        } else {
            n2 = Math.min(n5, n8);
            int n11 = 0;
            for (int i = 0; i < n7; ++i) {
                int n12 = 0;
                for (int j = 0; j < n6; ++j) {
                    writableRaster.getPixel(n12, n11, nArray);
                    for (int k = 0; k < n2; ++k) {
                        nArray2[k] = (int)((double)nArray[k] * d3);
                    }
                    writableRaster2.setPixel(j, i, nArray2);
                    n12 += n;
                }
                n11 += n;
            }
        }
        return bufferedImage2;
    }

    @Override
    public void set(BufferedImage bufferedImage) throws IncompatibleImageException {
        this.checkCompatibility(bufferedImage);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int[] nArray = new int[this.getNBands()];
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = this.bim.getRaster();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                writableRaster.getPixel(j, i, nArray);
                writableRaster2.setPixel(j, i, nArray);
            }
        }
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray) {
        WritableRaster writableRaster = this.bim.getRaster();
        writableRaster.setPixel(n, n2, nArray);
    }

    @Override
    public void setPixel(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.bim.getRaster();
        writableRaster.setSample(n, n2, n3, n4);
    }

    @Override
    public void setPixelDouble(int n, int n2, double[] dArray) {
        WritableRaster writableRaster = this.bim.getRaster();
        writableRaster.setPixel(n, n2, dArray);
    }

    @Override
    public void setPixelDouble(int n, int n2, int n3, double d) {
        WritableRaster writableRaster = this.bim.getRaster();
        writableRaster.setSample(n, n2, n3, d);
    }

    @Override
    public void showInfo() {
        this.showInfo(this);
    }

    @Override
    public Image[] splitIntensity() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int n4 = this.getBitsPerChannel();
        int n5 = this.getRange().high;
        Image image = ImageBase.createImage(n, n2, 1, n4);
        if (null == image) {
            Util.warning("Error", "Unable to create intensity image");
            return null;
        }
        Image image2 = ImageBase.createImage(n, n2, n3, n4);
        if (null == image2) {
            Util.warning("Error", "Unable to create colour image");
            return null;
        }
        Timer timer = new Timer("Image.splitIntensity", this);
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7;
                int[] nArray = this.getPixel(j, i);
                int n8 = 0;
                for (n7 = 0; n7 < n3; ++n7) {
                    n8 += nArray[n7];
                }
                image.setPixel(j, i, 0, n8);
                if (n8 > n6) {
                    n6 = n8;
                }
                for (n7 = 0; n7 < n3; ++n7) {
                    nArray[n7] = (int)Math.round((double)n5 * (double)nArray[n7] / (double)n8);
                }
                image2.setPixel(j, i, nArray);
            }
        }
        image.getRangeByRescanningDouble();
        image2.getRangeByRescanningDouble();
        Image[] imageArray = new Image[]{image, image2};
        timer.stop();
        return imageArray;
    }

    @Override
    public void subtract(Image image) throws IncompatibleImageException {
        int n;
        if (!Image8or16Base.sameSizeBitsAndBands(this, image)) {
            throw new IncompatibleImageException("Incompatible images for subtraction");
        }
        Timer timer = new Timer("Image8or16Base.sub", this);
        BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
        WritableRaster writableRaster = this.bim.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n2 = this.getNBands();
        int n3 = (this.getMaxLevel() + 1) / 2 - 1;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n4 = this.getBitsPerChannel();
        if (n4 == (n = image.getBitsPerChannel())) {
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = (nArray[k] - nArray2[k]) / 2 + n3;
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else if (n4 > n) {
            int n5 = n4 - n;
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = (nArray[k] - (nArray2[k] << n5)) / 2 + n3;
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else if (n4 < n) {
            int n6 = n - n4;
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = (nArray[k] - (nArray2[k] >> n6)) / 2 + n3;
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
        timer.stop();
    }

    @Override
    public void subtractToZero(Image image) throws IncompatibleImageException {
        int n;
        if (!Image8or16Base.sameSizeBitsAndBands(this, image)) {
            throw new IncompatibleImageException("Incompatible images for subtraction");
        }
        BufferedImage bufferedImage = ((Image8or16Base)image).getBufferedImage();
        Timer timer = new Timer("Image8or16Base.sub", this);
        WritableRaster writableRaster = this.bim.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n2 = this.getNBands();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = this.getBitsPerChannel();
        if (n3 == (n = image.getBitsPerChannel())) {
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = nArray[k] - nArray2[k];
                        if (nArray[k] >= 0) continue;
                        nArray[k] = 0;
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else if (n3 > n) {
            int n4 = n3 - n;
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = nArray[k] - (nArray2[k] << n4);
                        if (nArray[k] >= 0) continue;
                        nArray[k] = 0;
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        } else if (n3 < n) {
            int n5 = n - n3;
            for (int i = 0; i < Math.min(this.getHeight(), bufferedImage.getHeight()); ++i) {
                for (int j = 0; j < Math.min(this.getWidth(), bufferedImage.getWidth()); ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    writableRaster2.getPixel(j, i, nArray2);
                    for (int k = 0; k < n2; ++k) {
                        nArray[k] = nArray[k] - (nArray2[k] >> n5);
                        if (nArray[k] >= 0) continue;
                        nArray[k] = 0;
                    }
                    writableRaster.setPixel(j, i, nArray);
                }
            }
        }
        timer.stop();
    }

    @Override
    public ByteMask threshold(Threshold threshold) {
        Timer timer = new Timer("Image8or16Base.threshold", this);
        WritableRaster writableRaster = this.bim.getRaster();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getNBands();
        int[] nArray = new int[n3];
        byte[][] byArray = new byte[n][n2];
        if (threshold.anding) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    int n4 = 3;
                    for (int k = 0; k < n3; ++k) {
                        if (nArray[k] >= threshold.th[k].low && nArray[k] <= threshold.th[k].high) continue;
                        n4 = 0;
                        break;
                    }
                    byArray[j][i] = n4;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    writableRaster.getPixel(j, i, nArray);
                    int n5 = 0;
                    for (int k = 0; k < n3; ++k) {
                        if (nArray[k] < threshold.th[k].low || nArray[k] > threshold.th[k].high) continue;
                        n5 = 3;
                        break;
                    }
                    byArray[j][i] = n5;
                }
            }
        }
        timer.stop();
        return new ByteMask(byArray);
    }

    @Override
    public void translate(int n, int n2) {
        this.setBufferedImage(this.translateCopy(n, n2));
    }

    private BufferedImage translateCopy(int n, int n2) {
        Timer timer = new Timer("Image8or16Base.translate", this);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        int n5 = n3;
        int n6 = n4;
        int n7 = this.getNBands();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n5, n6), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int[] nArray = new int[n7];
        int n8 = 0;
        int n9 = n2;
        while (n8 < n4) {
            if (n9 >= 0 && n9 < n4) {
                int n10 = 0;
                int n11 = n;
                while (n10 < n3) {
                    if (n11 >= 0 && n11 < n3) {
                        writableRaster2.setPixel(n11, n9, writableRaster.getPixel(n10, n8, nArray));
                    }
                    ++n10;
                    ++n11;
                }
            }
            ++n8;
            ++n9;
        }
        timer.stop();
        return bufferedImage;
    }

    @Override
    public void translate(double d, double d2) {
        this.setBufferedImage(this.translateCopy(d, d2));
    }

    private BufferedImage translateCopy(double d, double d2) {
        Timer timer = new Timer("Image8or16Base.translate", this);
        int n = this.getWidth();
        int n2 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        int n3 = n;
        int n4 = n2;
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n3, n4), this.bim.isAlphaPremultiplied(), null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        for (int i = 0; i < n4; ++i) {
            double d3 = (double)i - d2;
            for (int j = 0; j < n3; ++j) {
                double d4 = (double)j - d;
                writableRaster2.setPixel(j, i, Interpolator.getPixel(writableRaster, d4, d3));
            }
        }
        timer.stop();
        return bufferedImage;
    }

    @Override
    public void varianceFilter(int n, ProgressMonitor progressMonitor) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        WritableRaster writableRaster = this.bim.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.bim.getColorModel(), writableRaster.createCompatibleWritableRaster(n2, n3), this.bim.isAlphaPremultiplied(), null);
        Timer timer = new Timer("Image8or16Base.varianceFilter", this);
        int n4 = this.getNBands();
        int[] nArray = new int[n4];
        int n5 = this.getMaxLevel();
        int n6 = 2 * n + 1;
        int n7 = n6 * n6;
        double d = 1.0 / (double)n7;
        double d2 = (double)n7 / (double)n5;
        long[] lArray = new long[n4];
        long[] lArray2 = new long[n4];
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        if (null != progressMonitor) {
            progressMonitor.setMaximum(n3 - n);
        }
        for (int i = n; i < writableRaster2.getHeight() - n; ++i) {
            if (null != progressMonitor) {
                progressMonitor.setProgress(i);
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    return;
                }
            }
            for (int j = n; j < writableRaster2.getWidth() - n; ++j) {
                int n8;
                for (n8 = 0; n8 < n4; ++n8) {
                    lArray[n8] = 0L;
                    lArray2[n8] = 0L;
                }
                n8 = 0;
                for (int k = i - n; k <= i + n; ++k) {
                    int n9 = j - n;
                    while (n9 <= j + n) {
                        writableRaster.getPixel(n9, k, nArray);
                        int n10 = 0;
                        while (n10 < n4) {
                            long l = nArray[n10];
                            int n11 = n10;
                            lArray[n11] = lArray[n11] + l;
                            int n12 = n10++;
                            lArray2[n12] = lArray2[n12] + l * l;
                        }
                        ++n9;
                        ++n8;
                    }
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    double d3 = d * (double)lArray2[n8];
                    double d4 = d * (double)lArray[n8];
                    double d5 = (d3 - d4 * d4) * d2 + 0.5;
                    nArray[n8] = d5 >= (double)n5 ? n5 : (d5 < 0.0 ? 0 : (int)d5);
                }
                writableRaster2.setPixel(j, i, nArray);
            }
        }
        if (null != progressMonitor) {
            progressMonitor.close();
        }
        timer.stop();
        this.setBufferedImage(bufferedImage);
    }

    private void setDateTimeMetadata(IIOMetadata iIOMetadata) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = gregorianCalendar.get(1) + ":" + this.zeroPrefix(1 + gregorianCalendar.get(2)) + ":" + this.zeroPrefix(gregorianCalendar.get(5)) + " " + this.zeroPrefix(gregorianCalendar.get(11)) + ":" + this.zeroPrefix(gregorianCalendar.get(12)) + ":" + this.zeroPrefix(gregorianCalendar.get(13));
        this.setDateTimeMetadata(iIOMetadata, string);
    }

    private String zeroPrefix(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    private void setDateTimeMetadata(IIOMetadata iIOMetadata, String string) {
        if (null != iIOMetadata) {
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                String[] stringArray = iIOMetadata.getMetadataFormatNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl = false;
                    String string2 = "//TIFFField[@name='DateTime']";
                    Node node = iIOMetadata.getAsTree(stringArray[i]);
                    NodeList nodeList = (NodeList)xPath.evaluate(string2, node, XPathConstants.NODESET);
                    if (0 < nodeList.getLength()) {
                        string2 = "TIFFAsciis/TIFFAscii";
                        if (0 < (nodeList = (NodeList)xPath.evaluate(string2, nodeList.item(0), XPathConstants.NODESET)).getLength()) {
                            NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
                            Node node2 = namedNodeMap.getNamedItem("value");
                            if (null != node2) {
                                bl = true;
                                node2.setNodeValue(string);
                            }
                        } else {
                            Util.logInfo("No nodes found matching TIFFAsciis/TIFFAscii");
                        }
                    } else {
                        Util.logInfo("No nodes found matching //TIFFField[@name='DateTime']");
                    }
                    if (!bl) continue;
                    iIOMetadata.setFromTree(stringArray[i], node);
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                Util.warning("Error", "XPath error: could not set date of saving in metadata");
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                Util.warning("Warning", "Tree error: could not set date of saving in metadata");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Util.warning("Warning", "Cannot set date/time of saving in metadata. Continuing to process image...");
            }
            catch (IllegalStateException illegalStateException) {
                Util.warning("Warning", "Cannot set date/time of saving in metadata. Continuing to process image...");
            }
        }
    }

    @Override
    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFilePath());
        stringBuffer.append(string);
        if (this.isRaw()) {
            stringBuffer.append("RAW");
            stringBuffer.append(string);
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        stringBuffer.append("Size: ");
        stringBuffer.append(n);
        stringBuffer.append(" x ");
        stringBuffer.append(n2);
        stringBuffer.append(" pixels");
        stringBuffer.append(string);
        stringBuffer.append("Channels: ");
        stringBuffer.append(this.getNBands());
        stringBuffer.append(string);
        stringBuffer.append("Bits per channel: ");
        stringBuffer.append(this.getBitsPerChannel());
        stringBuffer.append(" [levels ");
        stringBuffer.append(this.getRange().low);
        stringBuffer.append("..");
        stringBuffer.append(this.getRange().high);
        stringBuffer.append("]");
        stringBuffer.append(string);
        stringBuffer.append("Calibration: ");
        stringBuffer.append(this.getCalibration().getValue());
        stringBuffer.append(string);
        Metadata metadata = this.getMetadata();
        if (null != metadata) {
            stringBuffer.append(metadata.toFoldedString(string));
        }
        return stringBuffer.toString();
    }
}

