/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.grelf.AbstractDialogue;
import net.grelf.Util;
import net.grelf.image.FITS_KeywordRecord;
import net.grelf.image.Image;
import net.grelf.image.Metadata;

public class MetadataDialogue
extends AbstractDialogue
implements ActionListener {
    private JTextArea jta;
    private JButton modifyButton = new JButton("Modify an entry");
    private JButton addButton = new JButton("Add an entry");
    private JButton removeButton = new JButton("Remove an entry");
    private JButton okButton = new JButton("OK");
    private Image image;
    private Metadata metadata;

    public MetadataDialogue(Image image) {
        this.setTitle("About this image");
        this.image = image;
        this.metadata = image.getMetadata();
        this.jta = new JTextArea(image.toFoldedString("\n"), 24, 80);
        JScrollPane jScrollPane = new JScrollPane(this.jta);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.modifyButton.setEnabled(null != this.metadata);
        this.modifyButton.addActionListener(this);
        this.addButton.setEnabled(null != this.metadata);
        this.addButton.addActionListener(this);
        this.removeButton.setEnabled(null != this.metadata);
        this.removeButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.placeControl(container, jScrollPane, 0, 0, 4, 1);
        this.placeControl(container, this.addButton, 0, 1, 1, 1);
        this.placeControl(container, this.modifyButton, 1, 1, 1, 1);
        this.placeControl(container, this.removeButton, 2, 1, 1, 1);
        this.placeControl(container, this.okButton, 3, 1, 1, 1);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            String string = Util.askString("Keyword to add? (at your own risk)", "");
            if (null != string) {
                if (this.metadata.contains(string)) {
                    Util.warning("Sorry", "Keyword " + string + " already exists");
                    return;
                }
                String string2 = Util.askString("Value for " + string + "?", "");
                if (null != string2) {
                    if (null != this.metadata.getList() && this.metadata.getList().size() > 0) {
                        FITS_KeywordRecord fITS_KeywordRecord = new FITS_KeywordRecord(string, string2);
                        this.metadata.getList().add(fITS_KeywordRecord);
                    } else {
                        this.metadata.addValue(string, string2);
                    }
                    this.jta.setText(this.image.toFoldedString("\n"));
                    this.repaint();
                }
            }
        } else if (object == this.modifyButton) {
            String string = Util.askString("Keyword to edit? (at your own risk)", "");
            if (null != string) {
                if (this.metadata.contains(string)) {
                    String string3 = Util.askString("New value for " + string + "?", "");
                    if (null != string3 && string3.length() > 0) {
                        this.metadata.replaceValue(string, string3);
                        this.jta.setText(this.image.toFoldedString("\n"));
                        this.repaint();
                    }
                } else {
                    Util.warning("Sorry", "Keyword " + string + " not found");
                }
            }
        } else if (object == this.removeButton) {
            String string = Util.askString("Keyword to remove? (at your own risk)", "");
            if (null != string) {
                if (this.metadata.contains(string)) {
                    if (Util.confirm("Confirm", "Remove " + string + "?")) {
                        this.metadata.remove(string);
                        this.jta.setText(this.image.toFoldedString("\n"));
                        this.repaint();
                    }
                } else {
                    Util.warning("Sorry", "Keyword " + string + " not found");
                }
            }
        } else {
            this.dispose();
        }
    }
}

