/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.mrw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.mrw.MRWImageReader;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.imageio.ImageReader;

public class MRWImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = MRWImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final int MRW_MAGIC = 5067341;

    public MRWImageReaderSpi() {
        super("MRW", "mrw", "image/x-minolta-mrw", MRWImageReader.class);
    }

    @Nonnull
    public String getDescription(Locale locale) {
        return "Standard MRW Image Reader";
    }

    @Nonnull
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new MRWImageReader(this, extension);
    }

    public boolean canDecodeInput(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        iis.seek(0L);
        int magic = iis.readInt();
        if (magic != 5067341) {
            logger.fine("MRWImageReaderSpi giving up on: '%s'", Integer.toHexString(magic));
            return false;
        }
        return true;
    }
}

