/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.BrightnessContrastDialog;
import java.io.IOException;
import java.io.InterruptedIOException;

public class BrowserControl {
    public static void displayURL(String string) throws IOException {
        if (BrowserControl.isWindows()) {
            if (string.endsWith(".html") || string.endsWith(".htm")) {
                char c = string.charAt(string.length() - 1);
                string = String.valueOf(string.substring(0, string.length() - 1)) + "%" + Integer.toHexString(c);
            }
            String string2 = "rundll32 url.dll,FileProtocolHandler " + string;
            Process process = Runtime.getRuntime().exec(string2);
        } else if (BrowserControl.isMacOS()) {
            String[] stringArray = new String[]{"netscape", string};
            Process process = Runtime.getRuntime().exec(stringArray);
        } else {
            String string3 = "netscape -remote openURL(" + string + ")";
            Process process = Runtime.getRuntime().exec(string3);
            try {
                int n = process.waitFor();
                if (n != 0) {
                    string3 = "netscape " + string;
                    process = Runtime.getRuntime().exec(string3);
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Error bringing up browser, cmd='" + string3 + "'");
                System.err.println("Caught: " + interruptedException);
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
    }

    public static void displayMailer(String string) throws IOException {
        BrowserControl.displayURL("mailto:" + string);
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Windows");
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith("Mac");
    }

    public static int getVersion() {
        return BrightnessContrastDialog.getVersion();
    }
}

