/*
 * Decompiled with CFR 0.152.
 */
package imager;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class Brush {
    BufferedImage destImage;
    TexturePaint tp;
    Point prevPoint;
    Graphics2D g2d;
    Color m_Color = Color.black;
    Composite m_Composite;
    Stroke m_Stroke;

    public void setTexture(TexturePaint texturePaint) {
        this.tp = texturePaint;
    }

    public void setTexture(BufferedImage bufferedImage) {
        this.tp = new TexturePaint(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void nullifyTexture() {
        this.tp = null;
    }

    public void setColor(Color color) {
        this.m_Color = color;
    }

    public void setComposite(Composite composite) {
        this.m_Composite = composite;
    }

    public void mousePressed(Graphics2D graphics2D, int n, int n2) {
        if (this.prevPoint == null) {
            this.prevPoint = new Point(n, n2);
        } else {
            this.prevPoint.x = n;
            this.prevPoint.y = n2;
        }
        this.g2d = graphics2D;
        if (this.tp != null) {
            graphics2D.setPaint(this.tp);
        } else {
            graphics2D.setColor(this.m_Color);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.m_Composite != null) {
            graphics2D.setComposite(this.m_Composite);
        }
        if (this.m_Stroke != null) {
            graphics2D.setStroke(this.m_Stroke);
        }
    }

    public void mouseDragged(int n, int n2) {
        this.g2d.drawLine(this.prevPoint.x, this.prevPoint.y, n, n2);
        this.prevPoint.x = n;
        this.prevPoint.y = n2;
    }

    public void mouseReleased(int n, int n2) {
        this.g2d.setPaintMode();
    }

    public void setStroke(Stroke stroke) {
        this.m_Stroke = stroke;
    }
}

