/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Brush;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public final class CloningBrush
extends Brush {
    Point sourcePoint;
    Point destPoint;
    int translateX;
    int translateY;
    boolean m_AlignMode;

    public CloningBrush(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage != null) {
            this.tp = new TexturePaint(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        this.sourcePoint = new Point(n, n2);
    }

    public void setSourcePoint(int n, int n2) {
        this.sourcePoint = new Point(n, n2);
    }

    public void mousePressed(Graphics2D graphics2D, int n, int n2) {
        if (this.destPoint == null) {
            this.destPoint = new Point(n, n2);
            this.translateX = n - this.sourcePoint.x;
            this.translateY = n2 - this.sourcePoint.y;
        } else if (this.m_AlignMode) {
            this.translateX = n - this.sourcePoint.x;
            this.translateY = n2 - this.sourcePoint.y;
        }
        if (this.prevPoint == null) {
            this.prevPoint = new Point(n - this.translateX, n2 - this.translateY);
        } else {
            this.prevPoint.x = n - this.translateX;
            this.prevPoint.y = n2 - this.translateY;
        }
        this.g2d = graphics2D;
        if (this.tp != null) {
            graphics2D.setPaint(this.tp);
        } else {
            graphics2D.setColor(this.m_Color);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.m_Composite != null) {
            graphics2D.setComposite(this.m_Composite);
        }
    }

    public void mouseDragged(int n, int n2) {
        this.g2d.translate(this.translateX, this.translateY);
        this.g2d.drawLine(this.prevPoint.x, this.prevPoint.y, n - this.translateX, n2 - this.translateY);
        this.g2d.translate(-this.translateX, -this.translateY);
        this.prevPoint.x = n - this.translateX;
        this.prevPoint.y = n2 - this.translateY;
    }

    public void setAlignMode(boolean bl) {
        this.m_AlignMode = bl;
    }
}

