/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.FormattedTextField;
import imager.TextAnimation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class HorizScrollingTextAnimation
extends TextAnimation {
    private boolean U_leftScroll = false;
    private int u_scrollValue = 10;
    private UIPanel V_uiPanel = new UIPanel();

    public void paint(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        if (!this.isTransparent) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
        if (this.text instanceof AbstractText) {
            AbstractText abstractText = (AbstractText)this.text;
            abstractText.draw((Graphics2D)graphics, rectangle2, true);
        }
    }

    public void animate(Graphics graphics, Rectangle rectangle) {
        this.xpos += this.U_leftScroll ? -this.u_scrollValue : this.u_scrollValue;
        Rectangle rectangle2 = null;
        if (this.text instanceof AbstractText) {
            rectangle2 = ((AbstractText)this.text).getBounds(graphics);
            if (this.xpos + rectangle2.width < rectangle.x) {
                this.xpos = rectangle.x + rectangle.width;
            }
            if (this.xpos > rectangle.x + rectangle.width) {
                this.xpos = -rectangle2.width;
            }
            rectangle2.y = this.ypos = (rectangle.height - rectangle2.height) / 2;
            rectangle2.x = this.xpos;
        }
        this.paint(graphics, rectangle, rectangle2);
    }

    public synchronized void reset() {
        this.xpos = 0;
    }

    public boolean isLeftScroll() {
        return this.U_leftScroll;
    }

    public int getScrollValue() {
        return this.u_scrollValue;
    }

    public void setLeftScroll(boolean bl) {
        this.U_leftScroll = bl;
    }

    public void setScrollValue(int n) {
        this.u_scrollValue = n;
    }

    public UIPanel getUIPanel() {
        return this.V_uiPanel;
    }

    public void setUIPanelBounds(int n, int n2, int n3, int n4) {
        this.V_uiPanel.setBounds(n, n2, n3, n4);
    }

    public int getNumFrames(Dimension dimension) {
        Rectangle rectangle = null;
        if (this.text instanceof AbstractText) {
            rectangle = ((AbstractText)this.text).getBounds(this.V_uiPanel.getGraphics());
            return (dimension.width + rectangle.width) / this.u_scrollValue + 1;
        }
        return 0;
    }

    class UIPanel
    extends JPanel {
        private ButtonGroup UUU_buttonGroup1;
        private JButton UVV_jButton1;
        private JCheckBox Uuu_jCheckBox1;
        private JLabel Uvv_jLabel1;
        private JLabel UUu_jLabel2;
        private JLabel UVv_jLabel3;
        private JLabel UvU_jLabel4;
        private JRadioButton VUV_jRadioButton1;
        private JRadioButton UVU_jRadioButton2;
        private JTextField UuV_jTextField1;
        private JTextField Uvu_jTextField2;

        public UIPanel() {
            this.UUV_initComponents();
            this.UvU_jLabel4.setBackground(HorizScrollingTextAnimation.this.getFillColor());
        }

        private void UUV_initComponents() {
            this.UUU_buttonGroup1 = new ButtonGroup();
            this.Uuu_jCheckBox1 = new JCheckBox();
            this.UVV_jButton1 = new JButton();
            this.UuV_jTextField1 = new FormattedTextField(2);
            this.Uvv_jLabel1 = new JLabel();
            this.UUu_jLabel2 = new JLabel();
            this.UVv_jLabel3 = new JLabel();
            this.Uvu_jTextField2 = new FormattedTextField(2);
            this.VUV_jRadioButton1 = new JRadioButton();
            this.UVU_jRadioButton2 = new JRadioButton();
            this.UvU_jLabel4 = new JLabel("     ");
            this.setLayout(null);
            this.Uuu_jCheckBox1.setFont(new Font("Dialog", 0, 12));
            this.Uuu_jCheckBox1.setText("Transparent");
            this.Uuu_jCheckBox1.addActionListener(new ActionListener(this){
                final /* synthetic */ UIPanel this$1;
                {
                    this.this$1 = uIPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    UIPanel.access$0(this.this$1, actionEvent);
                }
            });
            this.add(this.Uuu_jCheckBox1);
            this.Uuu_jCheckBox1.setBounds(10, 10, 100, 24);
            this.UVV_jButton1.setFont(new Font("Dialog", 0, 12));
            this.UVV_jButton1.setText("Color");
            this.UVV_jButton1.addActionListener(new ActionListener(this){
                final /* synthetic */ UIPanel this$1;
                {
                    this.this$1 = uIPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    UIPanel.access$1(this.this$1, actionEvent);
                }
            });
            this.add(this.UVV_jButton1);
            this.UVV_jButton1.setBounds(160, 10, 64, 26);
            this.add(this.UvU_jLabel4);
            this.UvU_jLabel4.setOpaque(true);
            this.UvU_jLabel4.setBounds(100, 10, 50, 20);
            this.UuV_jTextField1.setText("" + HorizScrollingTextAnimation.this.getDelay());
            this.UuV_jTextField1.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ UIPanel this$1;
                {
                    this.this$1 = uIPanel;
                }

                public void focusLost(FocusEvent focusEvent) {
                    UIPanel.access$2(this.this$1, focusEvent);
                }
            });
            this.add(this.UuV_jTextField1);
            this.UuV_jTextField1.setBounds(50, 50, 63, 20);
            this.Uvv_jLabel1.setFont(new Font("Dialog", 0, 12));
            this.Uvv_jLabel1.setText("Delay");
            this.add(this.Uvv_jLabel1);
            this.Uvv_jLabel1.setBounds(10, 50, 31, 16);
            this.UUu_jLabel2.setFont(new Font("Dialog", 0, 12));
            this.UUu_jLabel2.setText("ms");
            this.add(this.UUu_jLabel2);
            this.UUu_jLabel2.setBounds(115, 50, 18, 16);
            this.UVv_jLabel3.setFont(new Font("Dialog", 0, 12));
            this.UVv_jLabel3.setText("Scroll");
            this.add(this.UVv_jLabel3);
            this.UVv_jLabel3.setBounds(160, 50, 50, 16);
            this.Uvu_jTextField2.setText("" + HorizScrollingTextAnimation.this.getScrollValue());
            this.Uvu_jTextField2.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ UIPanel this$1;
                {
                    this.this$1 = uIPanel;
                }

                public void focusLost(FocusEvent focusEvent) {
                    UIPanel.access$3(this.this$1, focusEvent);
                }
            });
            this.add(this.Uvu_jTextField2);
            this.Uvu_jTextField2.setBounds(200, 50, 30, 20);
            this.VUV_jRadioButton1.setFont(new Font("Dialog", 0, 12));
            this.VUV_jRadioButton1.setSelected(true);
            this.VUV_jRadioButton1.setText("Left to Right");
            this.UUU_buttonGroup1.add(this.VUV_jRadioButton1);
            this.VUV_jRadioButton1.addItemListener(new ItemListener(this){
                final /* synthetic */ UIPanel this$1;
                {
                    this.this$1 = uIPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    UIPanel.access$4(this.this$1, itemEvent);
                }
            });
            this.add(this.VUV_jRadioButton1);
            this.VUV_jRadioButton1.setBounds(10, 80, 90, 24);
            this.UVU_jRadioButton2.setFont(new Font("Dialog", 0, 12));
            this.UVU_jRadioButton2.setText("Right to Left");
            this.UUU_buttonGroup1.add(this.UVU_jRadioButton2);
            this.UVU_jRadioButton2.addItemListener(new ItemListener(this){
                final /* synthetic */ UIPanel this$1;
                {
                    this.this$1 = uIPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    UIPanel.access$5(this.this$1, itemEvent);
                }
            });
            this.add(this.UVU_jRadioButton2);
            this.UVU_jRadioButton2.setBounds(100, 80, 104, 24);
        }

        private void UVu_jRadioButton2ItemStateChanged(ItemEvent itemEvent) {
            if (this.UVU_jRadioButton2.isSelected()) {
                HorizScrollingTextAnimation.this.U_leftScroll = true;
            }
        }

        private void Uuv_jRadioButton1ItemStateChanged(ItemEvent itemEvent) {
            if (this.VUV_jRadioButton1.isSelected()) {
                HorizScrollingTextAnimation.this.U_leftScroll = false;
            }
        }

        private void VUU_jButton1ActionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, "Background Color", this.UvU_jLabel4.getBackground());
            if (color != null) {
                this.UvU_jLabel4.setBackground(color);
                HorizScrollingTextAnimation.this.setFillColor(color);
            }
        }

        private void UUv_jTextField1FocusLost(FocusEvent focusEvent) {
            if (Integer.parseInt(this.UuV_jTextField1.getText()) < 50) {
                this.UuV_jTextField1.setText("50");
            }
            HorizScrollingTextAnimation.this.setDelay(Integer.parseInt(this.UuV_jTextField1.getText()));
        }

        private void UuU_jTextField2FocusLost(FocusEvent focusEvent) {
            if (Integer.parseInt(this.Uvu_jTextField2.getText()) < 5) {
                this.Uvu_jTextField2.setText("5");
            }
            HorizScrollingTextAnimation.this.setScrollValue(Integer.parseInt(this.Uvu_jTextField2.getText()));
        }

        private void UvV_jCheckBox1ActionPerformed(ActionEvent actionEvent) {
            HorizScrollingTextAnimation.this.setTransparent(this.Uuu_jCheckBox1.isSelected());
            this.UVV_jButton1.setEnabled(!this.Uuu_jCheckBox1.isSelected());
            if (this.Uuu_jCheckBox1.isSelected()) {
                HorizScrollingTextAnimation.this.setFillColor(Color.lightGray);
            } else {
                HorizScrollingTextAnimation.this.setFillColor(this.UvU_jLabel4.getBackground());
            }
        }

        static /* synthetic */ void access$0(UIPanel uIPanel, ActionEvent actionEvent) {
            uIPanel.UvV_jCheckBox1ActionPerformed(actionEvent);
        }

        static /* synthetic */ void access$1(UIPanel uIPanel, ActionEvent actionEvent) {
            uIPanel.VUU_jButton1ActionPerformed(actionEvent);
        }

        static /* synthetic */ void access$2(UIPanel uIPanel, FocusEvent focusEvent) {
            uIPanel.UUv_jTextField1FocusLost(focusEvent);
        }

        static /* synthetic */ void access$3(UIPanel uIPanel, FocusEvent focusEvent) {
            uIPanel.UuU_jTextField2FocusLost(focusEvent);
        }

        static /* synthetic */ void access$4(UIPanel uIPanel, ItemEvent itemEvent) {
            uIPanel.Uuv_jRadioButton1ItemStateChanged(itemEvent);
        }

        static /* synthetic */ void access$5(UIPanel uIPanel, ItemEvent itemEvent) {
            uIPanel.UVu_jRadioButton2ItemStateChanged(itemEvent);
        }
    }
}

