/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.AbstractText;
import imager.FormattedTextField;
import imager.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShadowedText
extends Text {
    public static final int SHEARED = 0;
    public static final int OFFSET = 1;
    private float UU_shearValueX;
    private float UV_shearValueY;
    private int Uu_offsetX;
    private int Uv_offsetY;
    Color shadowColor = Color.gray;
    int type;

    public ShadowedText(int n, Font font) {
        this.m_Text = "Shadow";
        this.m_Font = font;
        this.VU_setUI(n);
    }

    private void VU_setUI(int n) {
        if (n == 0) {
            this.UU_shearValueX = -1.0f;
            this.setUIPanel(new UIPanel2());
        } else {
            this.Uu_offsetX = 5;
            this.Uv_offsetY = -5;
            this.setUIPanel(new UIPanel1());
        }
    }

    public ShadowedText(String string, int n, int n2, Font font, Color color, TexturePaint texturePaint) {
        super(string, n, n2, font, color, texturePaint);
        this.m_Text = "Shadow";
        this.VU_setUI(0);
    }

    void render(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.m_Font;
        String string = this.m_Text;
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, string.length());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
        graphics2D.translate(n + this.Uu_offsetX, n2 + this.Uv_offsetY);
        Shape shape = textLayout.getOutline(AffineTransform.getShearInstance(this.UU_shearValueX, this.UV_shearValueY));
        graphics2D.setColor(this.shadowColor);
        graphics2D.fill(shape);
        graphics2D.translate(-(n + this.Uu_offsetX), -(n2 + this.Uv_offsetY));
        if (this.m_Tp == null) {
            graphics2D.setColor(this.m_Color);
        } else {
            graphics2D.setPaint(this.m_Tp);
        }
        graphics2D.drawString(this.m_Text, n, n2);
    }

    public void setShearValueX(float f) {
        this.UU_shearValueX = f;
    }

    public float getShearValueX() {
        return this.UU_shearValueX;
    }

    public void setShearValueY(float f) {
        this.UV_shearValueY = f;
    }

    public float getShearValueY() {
        return this.UV_shearValueY;
    }

    public void setOffsetX(int n) {
        this.Uu_offsetX = n;
    }

    public int getOffsetX() {
        return this.Uu_offsetX;
    }

    public void setOffsetY(int n) {
        this.Uv_offsetY = n;
    }

    public int getOffsetY() {
        return this.Uv_offsetY;
    }

    public String getName() {
        return "Shadowed Text";
    }

    public class UIPanel1
    extends JPanel {
        private JLabel UU_jLabel1 = new JLabel();
        private JTextField VV_m_OffsetXTextField = new FormattedTextField(1);
        private JLabel VU_jLabel2 = new JLabel();
        private JTextField Uv_m_OffsetYTextField = new FormattedTextField(1);
        private JLabel Uu_jLabel3 = new JLabel();
        private JButton UV_jButton1 = new JButton();

        public UIPanel1() {
            try {
                this.jbInit();
                this.Uu_jLabel3.setOpaque(true);
                this.Uu_jLabel3.setBackground(ShadowedText.this.shadowColor);
                this.VV_m_OffsetXTextField.setText("" + ShadowedText.this.Uu_offsetX);
                this.Uv_m_OffsetYTextField.setText("" + ShadowedText.this.Uv_offsetY);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void jbInit() throws Exception {
            this.UU_jLabel1.setFont(new Font("Dialog", 0, 11));
            this.UU_jLabel1.setText("Shadow Offset X:");
            this.UU_jLabel1.setBounds(new Rectangle(4, 3, 98, 28));
            this.setLayout(null);
            this.VV_m_OffsetXTextField.setBounds(new Rectangle(104, 3, 31, 27));
            this.VV_m_OffsetXTextField.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ UIPanel1 this$1;
                {
                    this.this$1 = uIPanel1;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.m_OffsetXTextField_focusLost(focusEvent);
                }
            });
            this.VU_jLabel2.setFont(new Font("Dialog", 0, 11));
            this.VU_jLabel2.setText("Shadow Offset Y:");
            this.VU_jLabel2.setBounds(new Rectangle(5, 32, 96, 27));
            this.Uv_m_OffsetYTextField.setBounds(new Rectangle(104, 34, 31, 23));
            this.Uv_m_OffsetYTextField.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ UIPanel1 this$1;
                {
                    this.this$1 = uIPanel1;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.m_OffsetYTextField_focusLost(focusEvent);
                }
            });
            this.Uu_jLabel3.setBounds(new Rectangle(96, 64, 51, 29));
            this.UV_jButton1.setBounds(new Rectangle(3, 64, 86, 29));
            this.UV_jButton1.setFont(new Font("Dialog", 0, 11));
            this.UV_jButton1.setHorizontalAlignment(2);
            this.UV_jButton1.setMargin(new Insets(1, 5, 2, 5));
            this.UV_jButton1.setText("Shadow Color");
            this.UV_jButton1.addActionListener(new ActionListener(this){
                final /* synthetic */ UIPanel1 this$1;
                {
                    this.this$1 = uIPanel1;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.jButton1_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.UU_jLabel1, null);
            this.add((Component)this.VV_m_OffsetXTextField, null);
            this.add((Component)this.VU_jLabel2, null);
            this.add((Component)this.Uv_m_OffsetYTextField, null);
            this.add((Component)this.UV_jButton1, null);
            this.add((Component)this.Uu_jLabel3, null);
        }

        void jButton1_actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, "Shadow Color", this.Uu_jLabel3.getBackground());
            if (color != null) {
                ShadowedText.this.shadowColor = color;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, this.Uu_jLabel3.getBackground(), ShadowedText.this.shadowColor);
                this.Uu_jLabel3.setBackground(color);
            }
        }

        void m_OffsetXTextField_focusLost(FocusEvent focusEvent) {
            try {
                int n = ShadowedText.this.Uu_offsetX;
                ShadowedText.this.Uu_offsetX = Integer.parseInt(this.VV_m_OffsetXTextField.getText());
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, n, ShadowedText.this.Uu_offsetX);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        void m_OffsetYTextField_focusLost(FocusEvent focusEvent) {
            try {
                int n = ShadowedText.this.Uv_offsetY;
                ShadowedText.this.Uv_offsetY = Integer.parseInt(this.Uv_m_OffsetYTextField.getText());
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, n, ShadowedText.this.Uv_offsetY);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public class UIPanel2
    extends JPanel {
        private JLabel U_jLabel3 = new JLabel();
        private JButton V_jButton1 = new JButton();
        JRadioButton jRadioButton1 = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        ButtonGroup buttonGroup1 = new ButtonGroup();

        public UIPanel2() {
            try {
                this.jbInit();
                this.U_jLabel3.setOpaque(true);
                this.U_jLabel3.setBackground(ShadowedText.this.shadowColor);
                if (ShadowedText.this.UU_shearValueX == -1.0f) {
                    this.jRadioButton1.setSelected(true);
                } else {
                    this.jRadioButton2.setSelected(true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        void jbInit() throws Exception {
            this.setLayout(null);
            this.U_jLabel3.setBounds(new Rectangle(96, 64, 51, 29));
            this.V_jButton1.setBounds(new Rectangle(3, 64, 86, 29));
            this.V_jButton1.setFont(new Font("Dialog", 0, 11));
            this.V_jButton1.setHorizontalAlignment(2);
            this.V_jButton1.setMargin(new Insets(1, 5, 2, 5));
            this.V_jButton1.setText("Shadow Color");
            this.V_jButton1.addActionListener(new ActionListener(this){
                final /* synthetic */ UIPanel2 this$1;
                {
                    this.this$1 = uIPanel2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.jButton1_actionPerformed(actionEvent);
                }
            });
            this.jRadioButton1.setText("Left Slant");
            this.jRadioButton1.setBounds(new Rectangle(3, 34, 96, 29));
            this.jRadioButton1.addChangeListener(new ChangeListener(this){
                final /* synthetic */ UIPanel2 this$1;
                {
                    this.this$1 = uIPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.jRadioButton1_stateChanged(changeEvent);
                }
            });
            this.jRadioButton2.setSelected(true);
            this.jRadioButton2.setText("Right slant");
            this.jRadioButton2.setBounds(new Rectangle(3, 6, 93, 29));
            this.jRadioButton2.addChangeListener(new ChangeListener(this){
                final /* synthetic */ UIPanel2 this$1;
                {
                    this.this$1 = uIPanel2;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.jRadioButton2_stateChanged(changeEvent);
                }
            });
            this.add((Component)this.V_jButton1, null);
            this.add((Component)this.U_jLabel3, null);
            this.add((Component)this.jRadioButton1, null);
            this.add((Component)this.jRadioButton2, null);
            this.buttonGroup1.add(this.jRadioButton2);
            this.buttonGroup1.add(this.jRadioButton1);
        }

        void jButton1_actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, "Shadow Color", this.U_jLabel3.getBackground());
            if (color != null) {
                ShadowedText.this.shadowColor = color;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, this.U_jLabel3.getBackground(), ShadowedText.this.shadowColor);
                this.U_jLabel3.setBackground(color);
            }
        }

        void jRadioButton1_stateChanged(ChangeEvent changeEvent) {
            if (this.jRadioButton1.isSelected()) {
                float f = ShadowedText.this.UU_shearValueX;
                ShadowedText.this.UU_shearValueX = 1.0f;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, f, ShadowedText.this.UU_shearValueX);
            }
        }

        void jRadioButton2_stateChanged(ChangeEvent changeEvent) {
            if (this.jRadioButton2.isSelected()) {
                float f = ShadowedText.this.UU_shearValueX;
                ShadowedText.this.UU_shearValueX = -1.0f;
                this.firePropertyChange(AbstractText.TEXT_PROPERTIES_CHANGED, f, ShadowedText.this.UU_shearValueX);
            }
        }
    }
}

