/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.Imager;
import imager.SplashPanel;
import imager.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    boolean showSplash = true;
    Image m_Image;
    int m_WaitTime = -1;
    Dimension screenSize;
    SplashPanel sp;
    Text m_Text;
    boolean m_bShowText = false;

    public SplashScreen() {
    }

    public SplashScreen(Frame frame, String string, int n) {
        super(frame);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.sp = new SplashPanel(string);
        this.getContentPane().add((Component)this.sp, "Center");
        this.setSize(this.sp.getPreferredSize());
        this.setLocation(this.screenSize.width / 2 - this.getWidth() / 2, this.screenSize.height / 2 - this.getHeight() / 2);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.showSplash = false;
                SplashScreen.this.dispose();
            }
        });
        this.m_WaitTime = n;
        if (Imager.getAppType() == 0) {
            this.m_Text = new Text("Trial Version", this.getSize().width / 2 - 90, 135, new Font("Default", 1, 18), Color.blue, null);
            this.m_bShowText = true;
        }
    }

    public void setTimer(int n) {
        this.m_WaitTime = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            return;
        }
        if (this.m_WaitTime <= 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                while (SplashScreen.this.showSplash) {
                    try {
                        if (SplashScreen.this.m_WaitTime <= 0) continue;
                        Thread.sleep(SplashScreen.this.m_WaitTime);
                        SplashScreen.this.setVisible(false);
                        SplashScreen.this.showSplash = false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "SplashThread");
        thread.start();
        this.requestFocus();
    }

    public void setText(String string) {
        if (this.m_Text == null) {
            this.m_Text = new Text(string, 1, 135, new Font("Default", 1, 15), Color.blue, null);
        } else {
            this.m_Text.m_Text = string;
        }
    }

    public void showText(boolean bl) {
        this.m_bShowText = bl;
    }
}

