/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.BrowserPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ThumbnailPanel
extends JLabel {
    String m_Foldername;
    String m_Filename;
    private Border UU_border1;
    private BrowserPanel UV_m_Parent;
    private static ThumbnailPopUpMenu Uu_PopUpMenu = new ThumbnailPopUpMenu();
    private ThumbnailPopUpMenu Uv_indivPopUpMenu;
    private long VU_lastModifiedTime;

    public ThumbnailPanel(BrowserPanel browserPanel, ImageIcon imageIcon, String string, String string2) {
        this(browserPanel, imageIcon, string, string2, string2, string2, false, false);
    }

    public ThumbnailPanel(BrowserPanel browserPanel, ImageIcon imageIcon, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        try {
            this.m_Filename = string2;
            this.UV_m_Parent = browserPanel;
            this.m_Foldername = string;
            this.setOpaque(false);
            this.jbInit();
            this.setHorizontalAlignment(0);
            if (imageIcon != null) {
                this.setIcon(imageIcon);
            }
            this.setToolTipText(string4);
            if (bl || bl2) {
                this.setText(string3.length() > 15 ? String.valueOf(string3.substring(0, 15)) + ".." : string3);
            }
            this.Uv_indivPopUpMenu = Uu_PopUpMenu;
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ThumbnailPanel.this.this_mouseClicked(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    ThumbnailPanel.this.this_mouseEntered(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    ThumbnailPanel.this.this_mouseExited(mouseEvent);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    void this_mouseClicked(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 2) {
                this.UV_m_Parent.thumbnailClicked(this.m_Foldername, this.m_Filename);
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.Uv_indivPopUpMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        try {
            this.setBackground(Color.blue);
            this.setCursor(new Cursor(12));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        try {
            this.setBackground(Color.gray);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void openImage() {
        this.UV_m_Parent.thumbnailClicked(this.m_Foldername, this.m_Filename);
    }

    void renameImage() {
        String string = (String)JOptionPane.showInputDialog(this, "Enter new name of the file(with extension)", "File rename", 3, null, null, this.m_Filename);
        if (string != null) {
            if (!new File(String.valueOf(this.m_Foldername) + File.separator + this.m_Filename).renameTo(new File(String.valueOf(this.m_Foldername) + File.separator + string))) {
                JOptionPane.showMessageDialog(this, "Error in renaming the file " + this.m_Filename);
            } else {
                this.m_Filename = string;
                this.setToolTipText(string);
            }
        }
    }

    void deleteImage() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to Delete the file " + this.m_Filename, "Delete Image", 0, 3) == 0) {
            if (!new File(String.valueOf(this.m_Foldername) + File.separator + this.m_Filename).delete()) {
                JOptionPane.showMessageDialog(this, "Error in deleting the file " + this.m_Filename);
            } else {
                this.UV_m_Parent.removeThumbnail(this);
                this.Uv_indivPopUpMenu = null;
                this.UV_m_Parent = null;
            }
        }
    }

    public String getFilePath() {
        return String.valueOf(this.m_Foldername) + File.separator + this.m_Filename;
    }

    public String getFileParent() {
        return this.m_Foldername;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.UV_m_Parent = null;
    }

    public long getLastModifiedTime() {
        return this.VU_lastModifiedTime;
    }

    public void setLastModifiedTime(long l) {
        this.VU_lastModifiedTime = l;
    }

    public static class ThumbnailPopUpMenu
    extends JPopupMenu {
        private JMenuItem UU_m_OpenMenuItem = new JMenuItem();
        private JMenuItem UV_m_RenameMenuItem = new JMenuItem();
        private JMenuItem Uu_m_DeleteMenuItem = new JMenuItem();
        private JCheckBoxMenuItem Uv_showDirectoryMenuItem = new JCheckBoxMenuItem("Show Directory", true);

        public ThumbnailPopUpMenu() {
            try {
                this.VU_jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void VU_jbInit() throws Exception {
            this.UU_m_OpenMenuItem.setMnemonic('O');
            this.UU_m_OpenMenuItem.setText("Open");
            this.UU_m_OpenMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ ThumbnailPopUpMenu this$1;
                {
                    this.this$1 = thumbnailPopUpMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.m_OpenMenuItem_actionPerformed(actionEvent);
                }
            });
            this.UV_m_RenameMenuItem.setMnemonic('R');
            this.UV_m_RenameMenuItem.setText("Rename");
            this.UV_m_RenameMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ ThumbnailPopUpMenu this$1;
                {
                    this.this$1 = thumbnailPopUpMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.m_RenameMenuItem_actionPerformed(actionEvent);
                }
            });
            this.Uu_m_DeleteMenuItem.setMnemonic('D');
            this.Uu_m_DeleteMenuItem.setText("Delete");
            this.Uu_m_DeleteMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ ThumbnailPopUpMenu this$1;
                {
                    this.this$1 = thumbnailPopUpMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.m_DeleteMenuItem_actionPerformed(actionEvent);
                }
            });
            this.add(this.UU_m_OpenMenuItem);
            this.add(this.UV_m_RenameMenuItem);
            this.add(this.Uu_m_DeleteMenuItem);
            this.addSeparator();
            JMenuItem jMenuItem = new JMenuItem("Refresh List");
            jMenuItem.setMnemonic('F');
            jMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ ThumbnailPopUpMenu this$1;
                {
                    this.this$1 = thumbnailPopUpMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.m_RefreshMenuItem_actionPerformed(actionEvent);
                }
            });
            this.add(jMenuItem);
            this.Uv_showDirectoryMenuItem.setMnemonic('S');
            this.Uv_showDirectoryMenuItem.addActionListener(new ActionListener(this){
                final /* synthetic */ ThumbnailPopUpMenu this$1;
                {
                    this.this$1 = thumbnailPopUpMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.showDirectoryMenuItem_actionPerformed(actionEvent);
                }
            });
            this.add(this.Uv_showDirectoryMenuItem);
        }

        void m_OpenMenuItem_actionPerformed(ActionEvent actionEvent) {
            ((ThumbnailPanel)this.getInvoker()).openImage();
        }

        void m_DeleteMenuItem_actionPerformed(ActionEvent actionEvent) {
            ((ThumbnailPanel)this.getInvoker()).deleteImage();
        }

        void m_RenameMenuItem_actionPerformed(ActionEvent actionEvent) {
            ((ThumbnailPanel)this.getInvoker()).renameImage();
        }

        void m_RefreshMenuItem_actionPerformed(ActionEvent actionEvent) {
            ((ThumbnailPanel)this.getInvoker()).UV_m_Parent.refreshFolder();
        }

        void showDirectoryMenuItem_actionPerformed(ActionEvent actionEvent) {
            ((ThumbnailPanel)this.getInvoker()).UV_m_Parent.setShowDirectory(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            ((ThumbnailPanel)this.getInvoker()).UV_m_Parent.refreshFolder();
        }
    }
}

