/*
 * Decompiled with CFR 0.152.
 */
package imager;

import imager.ImageSavingThread;
import imager.ImageWrapper;
import imager.Imager;
import imager.ImagerGlobal;
import imager.TileScrambler;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFrame;

class TileFrame
extends JFrame
implements ImageWrapper {
    Image orgImage;
    Image image;
    TileScrambler tileScrambler = new TileScrambler();

    TileFrame() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TileFrame.this.V_generateTile(TileFrame.this.orgImage);
            }
        });
        this.setSize(500, 500);
        this.setVisible(true);
        this.U_getImages(new File("C:\\test"));
    }

    public void paint(Graphics graphics) {
    }

    private void U_getImages(File file) {
        if (!file.exists() || !file.isDirectory()) {
            System.out.println("directory is not valid");
            return;
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            try {
                File file2 = new File(String.valueOf(file.getAbsolutePath()) + File.separator + "output" + File.separator + stringArray[n]);
                this.orgImage = ImagerGlobal.getImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(file.getAbsolutePath()) + File.separator + stringArray[n]), this);
                System.out.println("about to scramble image " + file2.getName());
                this.image = this.tileScrambler.tile(this.orgImage, 50, 50, this);
                new ImageSavingThread(this.image, file2, true, this, Imager.getAppType()).run();
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        System.out.println("images saved");
        System.exit(1);
    }

    private void V_generateTile(Image image) {
        System.out.println("clicked");
        this.image = this.tileScrambler.tile(image, 128, 128, this);
        this.repaint();
    }

    public void imageLoaded(File file, Image image) {
    }

    public void imageNotLoaded(Exception exception) {
    }

    public void imageNotSaved(Exception exception, File file) {
        System.out.println("ERROR: Could not save image " + file.getName() + " successfully");
    }

    public void imageSaved(File file) {
        System.out.println("Saved image " + file.getName() + " successfully");
    }

    public void setImageLoadingStatus(float f) {
    }
}

