/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF;

import imager.imagefileio.controlledImageConsumer;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class TIFFoutput
extends Thread
implements controlledImageConsumer {
    int[] pixels;
    int width;
    int height;
    static final int BYTE = 1;
    static final int ASCII = 2;
    static final int SHORT = 3;
    static final int LONG = 4;
    static int tag = 0;
    OutputStream output;
    boolean ifcolor = false;
    boolean ifdim = false;
    boolean started = false;
    boolean ifpixels = false;
    boolean ifcomplete = false;
    boolean ifsuccess = false;
    int ipixels = 0;
    int icomplete = 0;
    Object waitpixels = new Object();
    Object waitcomplete = new Object();
    Object waitsuccess = new Object();
    boolean ok = true;
    int redmask;
    int redshift;
    int greenmask;
    int greenshift;
    int bluemask;
    int blueshift;
    double percent = 0.0;

    public TIFFoutput(OutputStream outputStream) {
        this.output = outputStream;
    }

    public void imageComplete(int n) {
        Object object;
        if ((n & 4) != 0) {
            this.ok = false;
            object = this;
            synchronized (object) {
                if (!this.started) {
                    this.started = true;
                    this.start();
                }
            }
            object = this.waitcomplete;
            synchronized (object) {
                this.ifcomplete = true;
                this.waitcomplete.notify();
            }
        }
        if ((n & 3) != 0) {
            object = this.waitcomplete;
            synchronized (object) {
                this.ifcomplete = true;
                this.waitcomplete.notify();
            }
        }
    }

    public void setColorModel(ColorModel colorModel) {
        if (!(colorModel instanceof DirectColorModel)) {
            this.ok = false;
        } else {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n = this.redmask = directColorModel.getRedMask();
            this.redshift = 0;
            while ((n & Integer.MIN_VALUE) == 0) {
                --this.redshift;
                n <<= 1;
            }
            this.redshift += 24;
            n = this.greenmask = directColorModel.getGreenMask();
            this.greenshift = 0;
            while ((n & Integer.MIN_VALUE) == 0) {
                --this.greenshift;
                n <<= 1;
            }
            this.greenshift += 24;
            n = this.bluemask = directColorModel.getBlueMask();
            this.blueshift = 0;
            while ((n & Integer.MIN_VALUE) == 0) {
                --this.blueshift;
                n <<= 1;
            }
            this.blueshift += 24;
        }
        TIFFoutput tIFFoutput = this;
        synchronized (tIFFoutput) {
            this.ifcolor = true;
            if (this.ifcolor && this.ifdim && !this.started) {
                this.started = true;
                this.start();
            }
        }
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        TIFFoutput tIFFoutput = this;
        synchronized (tIFFoutput) {
            this.ifdim = true;
            if (this.ifcolor && this.ifdim && !this.started) {
                this.started = true;
                this.start();
            }
        }
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        this.ok = false;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n2;
        if (this.ifcomplete) {
            return;
        }
        Object object = this.waitpixels;
        synchronized (object) {
            if (!this.ifpixels) {
                try {
                    ++this.ipixels;
                    this.waitpixels.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.ok = false;
                }
            }
        }
        if (!this.ok) {
            return;
        }
        this.percent += 0.5 * (double)n3 * (double)n4 / (double)(this.width * this.height);
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n;
            int n10 = 0;
            while (n10 < n3) {
                this.pixels[n9++ + n7 * this.width] = nArray[n5 + n8 * n6 + n10];
                ++n10;
            }
            ++n7;
            ++n8;
        }
    }

    public void setProperties(Hashtable hashtable) {
    }

    void putfill(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.output.write(0);
            ++n2;
        }
    }

    void putshort(int n) throws IOException {
        this.output.write((byte)(n & 0xFF));
        this.output.write((byte)((n & 0xFF00) >>> 8));
    }

    void putlong(int n) throws IOException {
        this.output.write((byte)(n & 0xFF));
        this.output.write((byte)((n & 0xFF00) >>> 8));
        this.output.write((byte)((n & 0xFF0000) >>> 16));
        this.output.write((byte)((n & 0xFF000000) >>> 24));
    }

    void puttag(int n, int n2, int n3) throws IOException {
        this.putshort(n);
        this.putshort(n2);
        this.putlong(1);
        switch (n2) {
            case 1: 
            case 2: {
                this.output.write((byte)n3);
                this.putfill(3);
                break;
            }
            case 3: {
                this.putshort(n3);
                this.putfill(2);
                break;
            }
            case 4: {
                this.putlong(n3);
            }
        }
    }

    public void run() {
        int n;
        Object object = this.waitsuccess;
        synchronized (object) {
            this.ifsuccess = true;
            this.waitsuccess.notify();
        }
        if (!this.ok) {
            return;
        }
        byte[] byArray = new byte[3 * this.width];
        this.pixels = new int[this.width * this.height];
        object = this.waitpixels;
        synchronized (object) {
            this.ifpixels = true;
            n = 0;
            while (n < this.ipixels) {
                this.waitpixels.notify();
                ++n;
            }
        }
        object = this.waitcomplete;
        synchronized (object) {
            if (!this.ifcomplete) {
                try {
                    this.waitcomplete.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.ok = false;
                }
            }
        }
        if (!this.ok) {
            return;
        }
        try {
            this.output.write(73);
            this.output.write(73);
            this.putshort(42);
            this.putlong(8);
            this.putshort(10);
            this.puttag(256, 3, this.width);
            this.puttag(257, 3, this.height);
            this.putshort(258);
            this.putshort(3);
            this.putlong(3);
            this.putlong(134);
            this.puttag(259, 3, 1);
            this.puttag(262, 3, 2);
            this.puttag(273, 3, 140);
            this.puttag(274, 3, 1);
            this.puttag(277, 3, 3);
            this.puttag(278, 4, this.height);
            this.puttag(284, 3, 1);
            this.putlong(0);
            this.putshort(8);
            this.putshort(8);
            this.putshort(8);
            byArray = new byte[3 * this.width];
            n = 0;
            while (n < this.pixels.length) {
                this.percent += 0.5 / (double)this.height;
                int n2 = 0;
                while (n2 < this.width) {
                    byArray[3 * n2] = (byte)(this.redshift >= 0 ? (this.pixels[n2 + n] & this.redmask) >>> this.redshift : (this.pixels[n2 + n] & this.redmask) << -this.redshift);
                    byArray[3 * n2 + 1] = (byte)(this.greenshift >= 0 ? (this.pixels[n2 + n] & this.greenmask) >>> this.greenshift : (this.pixels[n2 + n] & this.greenmask) << -this.greenshift);
                    byArray[3 * n2 + 2] = (byte)(this.blueshift >= 0 ? (this.pixels[n2 + n] & this.bluemask) >>> this.blueshift : (this.pixels[n2 + n] & this.bluemask) << -this.blueshift);
                    ++n2;
                }
                this.output.write(byArray);
                n += this.width;
            }
            this.output.close();
        }
        catch (IOException iOException) {
            this.ok = false;
        }
        byArray = null;
        this.pixels = null;
        this.percent = 1.0;
    }

    public int progress() {
        return (int)(100.0 * this.percent);
    }

    public boolean success() {
        Object object = this.waitsuccess;
        synchronized (object) {
            if (!this.ifsuccess) {
                try {
                    this.waitsuccess.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.ok = false;
                }
            }
        }
        if (this.ok) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                this.ok = false;
            }
        }
        return this.ok;
    }
}

