/*
 * Decompiled with CFR 0.152.
 */
package imager.imagefileio.TIFF.enhanced;

public class MemoryFileInputFilter {
    private byte[] U_bytesArray;
    private boolean isIntel;
    private int V_currentPos;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;

    public MemoryFileInputFilter(byte[] byArray, boolean bl) {
        this.U_bytesArray = byArray;
        this.isIntel = bl;
        this.V_currentPos = 0;
    }

    public MemoryFileInputFilter(byte[] byArray) {
        this.U_bytesArray = byArray;
        this.isIntel = false;
        this.V_currentPos = 0;
    }

    public long getFilePointer() {
        return this.V_currentPos;
    }

    public boolean isIntel() {
        return this.isIntel;
    }

    public void setByteOrder(boolean bl) {
        this.isIntel = bl;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public char readChar() {
        char c = '\u0000';
        short s = this.readUnsignedByte();
        short s2 = this.readUnsignedByte();
        c = this.isIntel ? (char)(((s2 & 0xFF) << 8) + (s & 0xFF)) : (char)(((s & 0xFF) << 8) + (s2 & 0xFF));
        return c;
    }

    public short readUnsignedByte() {
        short s = (short)(this.U_bytesArray[this.V_currentPos] & 0xFF);
        ++this.V_currentPos;
        return s;
    }

    public byte readByte() {
        byte by = this.U_bytesArray[this.V_currentPos];
        ++this.V_currentPos;
        return by;
    }

    public short readShort() {
        short s = 0;
        short s2 = this.readUnsignedByte();
        short s3 = this.readUnsignedByte();
        s = this.isIntel ? (short)(((s3 & 0xFF) << 8) + (s2 & 0xFF)) : (short)(((s2 & 0xFF) << 8) + (s3 & 0xFF));
        return s;
    }

    public int readUnsignedShort() {
        int n = 0;
        short s = this.readUnsignedByte();
        short s2 = this.readUnsignedByte();
        n = this.isIntel ? ((s2 & 0xFF) << 8) + (s & 0xFF) : ((s & 0xFF) << 8) + (s2 & 0xFF);
        return n;
    }

    public long readInt() {
        long l = 0L;
        short s = this.readUnsignedByte();
        short s2 = this.readUnsignedByte();
        short s3 = this.readUnsignedByte();
        short s4 = this.readUnsignedByte();
        l = this.isIntel ? (long)(((s4 & 0xFF) << 24) + ((s3 & 0xFF) << 16) + ((s2 & 0xFF) << 8) + (s & 0xFF)) : (long)(((s & 0xFF) << 24) + ((s2 & 0xFF) << 16) + ((s3 & 0xFF) << 8) + (s4 & 0xFF));
        return l;
    }

    public long readLong() {
        long l = 0L;
        short s = this.readUnsignedByte();
        short s2 = this.readUnsignedByte();
        short s3 = this.readUnsignedByte();
        short s4 = this.readUnsignedByte();
        short s5 = this.readUnsignedByte();
        short s6 = this.readUnsignedByte();
        short s7 = this.readUnsignedByte();
        short s8 = this.readUnsignedByte();
        l = this.isIntel ? ((long)s8 << 56) + ((long)s7 << 48) + ((long)s6 << 40) + ((long)s5 << 32) + ((long)s4 << 24) + ((long)s3 << 16) + ((long)s2 << 8) + (long)s : ((long)s << 56) + ((long)s2 << 48) + ((long)s3 << 40) + ((long)s4 << 32) + ((long)s5 << 24) + ((long)s6 << 16) + ((long)s7 << 8) + (long)s8;
        return l;
    }

    public float readFloat() {
        return Float.intBitsToFloat((int)this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public int read() {
        return this.V_currentPos < this.U_bytesArray.length ? (int)this.readByte() : -1;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        this.V_currentPos = n;
        if (this.V_currentPos + n2 < this.U_bytesArray.length) {
            System.arraycopy(this.U_bytesArray, this.V_currentPos, byArray, 0, n2);
            return n2;
        }
        if (this.V_currentPos < this.U_bytesArray.length) {
            n2 = this.U_bytesArray.length - this.V_currentPos;
            System.arraycopy(this.U_bytesArray, this.V_currentPos, byArray, 0, n2);
            return n2;
        }
        return -1;
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, this.V_currentPos, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        System.arraycopy(this.U_bytesArray, n, byArray, 0, n2);
        this.V_currentPos += n2;
    }

    public void readProperly(byte[] byArray, int n, int n2) {
        if (!this.isIntel || n < 2) {
            this.readFully(byArray, this.V_currentPos + 0, n2);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                switch (n) {
                    case 2: {
                        byArray[n3 + 1] = this.U_bytesArray[this.V_currentPos];
                        ++this.V_currentPos;
                        byArray[n3] = this.U_bytesArray[this.V_currentPos];
                        ++this.V_currentPos;
                        break;
                    }
                    case 4: {
                        byArray[n3 + 3] = this.readByte();
                        byArray[n3 + 2] = this.readByte();
                        byArray[n3 + 1] = this.readByte();
                        byArray[n3] = this.readByte();
                        break;
                    }
                    case 8: {
                        byArray[n3 + 7] = this.readByte();
                        byArray[n3 + 6] = this.readByte();
                        byArray[n3 + 5] = this.readByte();
                        byArray[n3 + 4] = this.readByte();
                        byArray[n3 + 3] = this.readByte();
                        byArray[n3 + 2] = this.readByte();
                        byArray[n3 + 1] = this.readByte();
                        byArray[n3] = this.readByte();
                    }
                }
                n3 += n;
            }
        }
    }

    public void seek(long l) {
        this.V_currentPos = (int)l;
    }

    public long length() {
        return this.U_bytesArray.length;
    }

    public void close() {
        this.U_bytesArray = null;
    }
}

