/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class ColorConverterFilter
extends RGBImageFilter {
    int deviation;
    Color toColor;
    Color fromColor;

    public ColorConverterFilter(Color color, Color color2, int n) {
        this.deviation = n;
        this.toColor = color2;
        this.fromColor = color;
    }

    public int filterRGB(int n, int n2, int n3) {
        Color color = new Color(n3);
        return this.filterRGB(color.getRed(), color.getGreen(), color.getBlue(), n, n2);
    }

    public int filterRGB(int n, int n2, int n3, int n4, int n5) {
        if (n >= this.fromColor.getRed() - this.deviation && n <= this.fromColor.getRed() + this.deviation && n2 >= this.fromColor.getGreen() - this.deviation && n2 <= this.fromColor.getGreen() + this.deviation && n3 >= this.fromColor.getBlue() - this.deviation && n3 <= this.fromColor.getBlue() + this.deviation) {
            n = this.toColor.getRed() + n - this.fromColor.getRed();
            n2 = this.toColor.getGreen() + n2 - this.fromColor.getGreen();
            n3 = this.toColor.getBlue() + n3 - this.fromColor.getBlue();
            n = n > 255 ? 255 : n;
            n = n < 0 ? 0 : n;
            n2 = n2 > 255 ? 255 : n2;
            n2 = n2 < 0 ? 0 : n2;
            n3 = n3 > 255 ? 255 : n3;
            n3 = n3 < 0 ? 0 : n3;
            return new Color(n, n2, n3).getRGB();
        }
        return new Color(n, n2, n3).getRGB();
    }
}

