/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public class HSBAdjustFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 4578927872126740383L;
    public float hFactor;
    public float sFactor;
    public float bFactor;
    private float[] U_hsb = new float[3];

    public HSBAdjustFilter() {
        this(0.0f, 0.0f, 0.0f);
    }

    public HSBAdjustFilter(float f, float f2, float f3) {
        this.hFactor = f;
        this.sFactor = f2;
        this.bFactor = f3;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        Color.RGBtoHSB(n5, n6, n7, this.U_hsb);
        this.U_hsb[0] = this.U_hsb[0] + this.hFactor;
        while (this.U_hsb[0] < 0.0f) {
            this.U_hsb[0] = (float)((double)this.U_hsb[0] + Math.PI * 2);
        }
        this.U_hsb[1] = this.U_hsb[1] + this.sFactor;
        if (this.U_hsb[1] < 0.0f) {
            this.U_hsb[1] = 0.0f;
        } else if ((double)this.U_hsb[1] > 1.0) {
            this.U_hsb[1] = 1.0f;
        }
        this.U_hsb[2] = this.U_hsb[2] + this.bFactor;
        if (this.U_hsb[2] < 0.0f) {
            this.U_hsb[2] = 0.0f;
        } else if ((double)this.U_hsb[2] > 1.0) {
            this.U_hsb[2] = 1.0f;
        }
        n3 = Color.HSBtoRGB(this.U_hsb[0], this.U_hsb[1], this.U_hsb[2]);
        return n4 | n3 & 0xFFFFFF;
    }

    public String toString() {
        return "Colors/Adjust HSB...";
    }
}

