/*
 * Decompiled with CFR 0.152.
 */
package imager.plugins;

import imager.plugins.FilterCustomizer;
import imager.plugins.ImageSample;
import imager.utils.ImageOpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PreviewFilterCustomizer
extends FilterCustomizer {
    MediaTracker mediatracker;
    protected ImageFilter filter;
    protected ImageSample before;
    protected ImageSample after;
    protected Image beforeImage;
    protected JLabel arrowLabel;

    public PreviewFilterCustomizer() {
        this.setLayout(new BorderLayout(8, 8));
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "North");
        this.addBefore(jPanel);
        this.addCenter(jPanel);
        this.addAfter(jPanel);
        this.mediatracker = new MediaTracker(this);
    }

    protected void addBefore(Container container) {
        this.before = new ImageSample();
        container.add(this.before);
        this.before.setPreferredSize(this.getPreviewSize());
    }

    protected void addCenter(Container container) {
        this.arrowLabel = new JLabel(">>");
        container.add(this.arrowLabel);
    }

    protected void addAfter(Container container) {
        this.after = new ImageSample();
        container.add(this.after);
        this.after.setPreferredSize(this.getPreviewSize());
    }

    public void setObject(Object object) {
        this.filter = (ImageFilter)object;
        this.preview();
    }

    public boolean previewWholeImage() {
        return false;
    }

    public Dimension getPreviewSize() {
        return new Dimension(100, 100);
    }

    public void setPreviewImage(Image image) {
        try {
            if (image != null) {
                Dimension dimension = this.before.getPreferredSize();
                image = ImageOpUtils.createCentrallyCroppedImage(image, dimension, this);
            }
            this.beforeImage = image;
            if (this.before != null) {
                this.before.setImage(this.beforeImage);
            }
            if (this.after != null) {
                this.after.setImage(this.beforeImage);
            }
            if (image != null) {
                this.preview();
            } else {
                this.setBackgroundImage(null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBackgroundImage(Image image) {
        if (this.before != null) {
            this.before.setBackgroundImage(image);
        }
        if (this.after != null) {
            this.after.setBackgroundImage(image);
        }
    }

    public void busyCursor(boolean bl) {
        Graphics graphics;
        if (bl && (graphics = this.after.getGraphics()) != null) {
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, 1000, 1000);
            graphics.dispose();
        }
    }

    public void preview() {
        new Thread(){

            public void run() {
                if (PreviewFilterCustomizer.this.beforeImage != null) {
                    PreviewFilterCustomizer.this.busyCursor(true);
                    if (PreviewFilterCustomizer.this.after != null && PreviewFilterCustomizer.this.filter != null) {
                        Image image = PreviewFilterCustomizer.this.createImage(new FilteredImageSource(PreviewFilterCustomizer.this.beforeImage.getSource(), PreviewFilterCustomizer.this.filter));
                        PreviewFilterCustomizer.this.mediatracker.addImage(image, 0);
                        try {
                            PreviewFilterCustomizer.this.mediatracker.waitForID(0);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PreviewFilterCustomizer.this.mediatracker.removeImage(image, 0);
                        PreviewFilterCustomizer.this.after.setImage(image);
                    }
                    PreviewFilterCustomizer.this.busyCursor(false);
                }
            }
        }.start();
    }
}

