/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BackgroundBorderUIResource;
import ch.randelshofer.quaqua.ImageBevelBorder13;
import ch.randelshofer.quaqua.ImageBevelBorder14;
import ch.randelshofer.quaqua.Quaqua13PlacardButtonBorder;
import ch.randelshofer.quaqua.Quaqua13SquareButtonBorder;
import ch.randelshofer.quaqua.QuaquaButtonBorder;
import ch.randelshofer.quaqua.QuaquaIconFactory;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import javax.swing.border.Border;

public class QuaquaBorderFactory {
    private static boolean isJava13;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$awt$Insets;

    private QuaquaBorderFactory() {
    }

    public static Border create(Image img, Insets borderInsets) {
        return QuaquaBorderFactory.create(img, borderInsets, borderInsets);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets) {
        return QuaquaBorderFactory.create(img, imageInsets, borderInsets, false, true);
    }

    public static Border create(Image img, Insets borderInsets, boolean fillContentArea, boolean isCaching) {
        return QuaquaBorderFactory.create(img, borderInsets, borderInsets, fillContentArea, isCaching);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
        return QuaquaBorderFactory.create(img, imageInsets, borderInsets, fillContentArea, true);
    }

    public static Border create(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea, boolean isCaching) {
        if (isJava13) {
            return new ImageBevelBorder13(img, imageInsets, borderInsets, fillContentArea);
        }
        if (isCaching) {
            try {
                Class<?> clazz = Class.forName("ch.randelshofer.quaqua.CachedImageBevelBorder");
                Constructor<?> constructor = clazz.getConstructor(class$java$awt$Image == null ? (class$java$awt$Image = QuaquaBorderFactory.class$("java.awt.Image")) : class$java$awt$Image, class$java$awt$Insets == null ? (class$java$awt$Insets = QuaquaBorderFactory.class$("java.awt.Insets")) : class$java$awt$Insets, class$java$awt$Insets == null ? (class$java$awt$Insets = QuaquaBorderFactory.class$("java.awt.Insets")) : class$java$awt$Insets, Boolean.TYPE);
                return (Border)constructor.newInstance(img, imageInsets, borderInsets, new Boolean(fillContentArea));
            }
            catch (Exception e) {
                throw new InternalError(e.getMessage());
            }
        }
        return new ImageBevelBorder14(img, imageInsets, borderInsets, fillContentArea);
    }

    public static Border createSquareButtonBorder() {
        if (isJava13) {
            return new Quaqua13SquareButtonBorder();
        }
        try {
            Class<?> clazz = Class.forName("ch.randelshofer.quaqua.Quaqua14SquareButtonBorder");
            return (Border)clazz.newInstance();
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }

    public static Border createPlacardButtonBorder() {
        if (isJava13) {
            return new Quaqua13PlacardButtonBorder();
        }
        try {
            Class<?> clazz = Class.forName("ch.randelshofer.quaqua.Quaqua14PlacardButtonBorder");
            return (Border)clazz.newInstance();
        }
        catch (Exception e) {
            throw new InternalError(e.getMessage());
        }
    }

    public static Border create(String location, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), borderInsets, borderInsets, fill, false);
    }

    public static Border create(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, false);
    }

    public static Border createBackgroundBorder(String location, Insets imageInsets, Insets borderInsets, boolean fill) {
        return new BackgroundBorderUIResource(QuaquaBorderFactory.create(QuaquaIconFactory.createImage(location), imageInsets, borderInsets, fill, false));
    }

    public static Object create(String location, Insets insets, int count, boolean horizontal) {
        return QuaquaBorderFactory.create(location, insets, count, horizontal, true);
    }

    public static Object create(String location, Insets insets, int count, boolean horizontal, boolean fill) {
        BufferedImage[] images = Images.split(QuaquaIconFactory.createImage(location), count, horizontal);
        Border[] borders = new Border[count];
        for (int i = 0; i < count; ++i) {
            borders[i] = QuaquaBorderFactory.create((Image)images[i], insets, insets, fill);
        }
        return borders;
    }

    public static Border createButtonBorder(String type) {
        return new BackgroundBorderUIResource(new QuaquaButtonBorder("push"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String version = QuaquaManager.getProperty("java.version");
        isJava13 = version.startsWith("1.3");
    }
}

