/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ViewportPainter;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;

public class QuaquaViewportUI
extends BasicViewportUI {
    private ChangeListener changeListener;
    private JViewport viewport;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaViewportUI();
    }

    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Object ui;
            Component view = this.viewport.getView();
            Object object = ui = view == null ? null : Methods.invokeGetter((Object)view, "getUI", null);
            if (ui instanceof ViewportPainter) {
                ((ViewportPainter)ui).paintViewport(g, this.viewport);
            } else if (this.viewport.getView() != null) {
                g.setColor(this.viewport.getView().getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
    }

    public void installUI(JComponent c) {
        this.viewport = (JViewport)c;
        super.installUI(c);
        c.setOpaque(QuaquaManager.getBoolean("Viewport.opaque"));
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.viewport = (JViewport)c;
        super.uninstallUI(c);
        this.uninstallListeners();
    }

    protected void installListeners() {
        this.changeListener = this.createChangeListener();
        this.viewport.addChangeListener(this.changeListener);
    }

    protected void uninstallListeners() {
        this.viewport.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    private ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    private class ChangeHandler
    implements ChangeListener {
        private Point previousLocation = new Point();

        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            Component view;
            Point newLocation;
            if (QuaquaViewportUI.this.viewport.getView() != null && !this.previousLocation.equals(newLocation = (view = QuaquaViewportUI.this.viewport.getView()).getLocation())) {
                if (view.getHeight() < QuaquaViewportUI.this.viewport.getHeight()) {
                    if (newLocation.x > this.previousLocation.x) {
                        QuaquaViewportUI.this.viewport.repaint(0, view.getHeight(), newLocation.x - this.previousLocation.x, QuaquaViewportUI.this.viewport.getHeight() - view.getHeight());
                    }
                    if (newLocation.x < this.previousLocation.x) {
                        QuaquaViewportUI.this.viewport.repaint(QuaquaViewportUI.this.viewport.getWidth() + newLocation.x - this.previousLocation.x, view.getHeight(), this.previousLocation.x - newLocation.x, QuaquaViewportUI.this.viewport.getHeight() - view.getHeight());
                    }
                }
                if (view.getWidth() < QuaquaViewportUI.this.viewport.getWidth()) {
                    if (newLocation.y > this.previousLocation.y) {
                        QuaquaViewportUI.this.viewport.repaint(view.getWidth(), 0, QuaquaViewportUI.this.viewport.getWidth() - view.getWidth(), Math.min(view.getHeight(), newLocation.y - this.previousLocation.y));
                    }
                    if (newLocation.y < this.previousLocation.y) {
                        QuaquaViewportUI.this.viewport.repaint(view.getWidth(), Math.min(view.getHeight(), QuaquaViewportUI.this.viewport.getHeight()) - this.previousLocation.y + newLocation.y, QuaquaViewportUI.this.viewport.getWidth() - view.getWidth(), this.previousLocation.y - newLocation.y);
                    }
                }
                this.previousLocation = newLocation;
            }
        }
    }
}

