/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar;

import ch.randelshofer.quaqua.BasicQuaquaLookAndFeel;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaMenuBorder;
import java.security.AccessControlException;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

public class Quaqua13JaguarLookAndFeel
extends BasicQuaquaLookAndFeel {
    public Quaqua13JaguarLookAndFeel() {
        super("com.apple.mrj.swing.MacLookAndFeel");
    }

    public String getDescription() {
        return "The Quaqua 13 Jaguar Look and Feel version " + QuaquaManager.getVersion();
    }

    public String getName() {
        return "Quaqua Jaguar";
    }

    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaJaguarPrefix = "ch.randelshofer.quaqua.jaguar.QuaquaJaguar";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "ButtonUI", quaquaPrefix + "ButtonUI", "CheckBoxUI", quaquaPrefix + "CheckBoxUI", "ColorChooserUI", quaquaPrefix + "13" + "ColorChooserUI", "FileChooserUI", quaquaJaguarPrefix + "FileChooserUI", "FormattedTextFieldUI", quaquaPrefix + "FormattedTextFieldUI", "RadioButtonUI", quaquaPrefix + "RadioButtonUI", "ToggleButtonUI", quaquaPrefix + "ToggleButtonUI", "PopupMenuUI", quaquaPrefix + "PopupMenuUI", "SeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "MenuSeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "ScrollPaneUI", quaquaPrefix + "ScrollPaneUI", "SplitPaneUI", quaquaPrefix + "SplitPaneUI", "ToolBarSeparatorUI", quaquaPrefix + "ToolBarSeparatorUI", "PopupMenuSeparatorUI", quaquaJaguarPrefix + "SeparatorUI", "TabbedPaneUI", quaquaJaguarPrefix + "TabbedPaneUI", "TextAreaUI", quaquaPrefix + "TextAreaUI", "TextFieldUI", quaquaPrefix + "TextFieldUI", "PasswordFieldUI", quaquaPrefix + "PasswordFieldUI", "TextPaneUI", quaquaPrefix + "TextPaneUI", "EditorPaneUI", quaquaPrefix + "EditorPaneUI", "TreeUI", quaquaPrefix + "TreeUI", "LabelUI", quaquaPrefix + "LabelUI", "ListUI", quaquaPrefix + "ListUI", "ToolBarUI", quaquaPrefix + "ToolBarUI", "ComboBoxUI", quaquaPrefix + "ComboBoxUI", "TableUI", quaquaPrefix + "TableUI", "TableHeaderUI", quaquaPrefix + "TableHeaderUI", "OptionPaneUI", quaquaPrefix + "OptionPaneUI", "PanelUI", quaquaPrefix + "PanelUI", "ViewportUI", quaquaPrefix + "ViewportUI", "RootPaneUI", quaquaPrefix + "13RootPaneUI"};
        table.putDefaults(uiDefaults);
        if (!this.isUseScreenMenuBar()) {
            uiDefaults = new Object[]{"PopupMenuUI", quaquaPrefix + "PopupMenuUI", "MenuBarUI", quaquaPrefix + "MenuBarUI", "MenuUI", quaquaPrefix + "MenuUI", "MenuItemUI", quaquaPrefix + "MenuItemUI", "CheckBoxMenuItemUI", quaquaPrefix + "MenuItemUI", "RadioButtonMenuItemUI", quaquaPrefix + "MenuItemUI"};
            table.putDefaults(uiDefaults);
        }
    }

    private boolean isUseScreenMenuBar() {
        String property;
        try {
            property = QuaquaManager.getProperty("com.apple.macos.useScreenMenuBar", "false");
        }
        catch (AccessControlException e) {
            property = "false";
        }
        return property.equals("true");
    }

    protected boolean isJaguarTabbedPane() {
        String property;
        try {
            property = QuaquaManager.getProperty("Quaqua.tabLayoutPolicy");
            if (property == null) {
                property = QuaquaManager.getProperty("Quaqua.TabbedPane.design", "auto");
            }
        }
        catch (AccessControlException e) {
            property = "auto";
        }
        return property.equals("jaguar") || property.equals("wrap");
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        Object[] objects = new Object[]{"control", table.get("Panel.background"), "text", new ColorUIResource(0xFFFFFF), "menu", table.get("MenuItem.background"), "listHighlight", table.get("textHighlight"), "listHighlightText", table.get("textHighlightText"), "listHighlightBorder", new ColorUIResource(0x808080)};
        table.putDefaults(objects);
    }

    protected void initDesignDefaults(UIDefaults table) {
        Object[] objects = new Object[]{"Separator.foreground", new ColorUIResource(139, 139, 139), "Separator.highlight", new ColorUIResource(243, 243, 243), "Separator.shadow", new ColorUIResource(213, 213, 213), "Sheet.displayAsSheet", Boolean.FALSE, "ToolBarSeparator.foreground", new ColorUIResource(0)};
        table.putDefaults(objects);
        objects = this.isUseScreenMenuBar() ? new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua13JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "Menu.checkIcon", Quaqua13JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuBar.background", this.makeTextureColor(0xF4F4F4, "images/MenuBar.texture.png"), "MenuBar.shadow", new ColorUIResource(0x808080), "MenuItem.checkIcon", Quaqua13JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "PopupMenu.border", new BorderUIResource(new QuaquaMenuBorder()), "PopupMenu.foreground", new ColorUIResource(0), "RadioButtonMenuItem.checkIcon", Quaqua13JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6)} : new Object[]{"CheckBoxMenuItem.checkIcon", Quaqua13JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/CheckBoxMenuItem.icons.png", 6), "CheckBoxMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "Menu.checkIcon", Quaqua13JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "Menu.margin", new InsetsUIResource(0, 8, 0, 8), "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(0), "Menu.submenuPopupOffsetY", new Integer(-5), "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "Menu.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "MenuBar.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0), "MenuBar.margin", new InsetsUIResource(1, 8, 1, 8), "MenuBar.background", this.makeTextureColor(0xF4F4F4, "images/MenuBar.texture.png"), "MenuBar.shadow", new ColorUIResource(0x808080), "MenuItem.checkIcon", Quaqua13JaguarLookAndFeel.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/MenuItem.checkIcon.png"), "MenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "PopupMenu.border", new BorderUIResource(new QuaquaMenuBorder()), "RadioButtonMenuItem.checkIcon", Quaqua13JaguarLookAndFeel.makeButtonStateIcon("/ch/randelshofer/quaqua/images/RadioButtonMenuItem.icons.png", 6), "RadioButtonMenuItem.border", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1)};
        table.putDefaults(objects);
        objects = new Object[]{"TabbedPane.tabInsets", new InsetsUIResource(1, 10, 4, 9), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 2, 1), "TabbedPane.tabAreaInsets", new InsetsUIResource(4, 16, 0, 16), "TabbedPane.contentBorderInsets", new InsetsUIResource(5, 6, 6, 6)};
        table.putDefaults(objects);
    }
}

