/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.Application;
import com.jhlabs.app.Checkable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ActionHandler {
    public static final String INTERNAL_NAME = "int_name";
    public static final String GROUP = "group";
    protected Vector actions = new Vector();
    protected ActionHandler nextInChain;

    public void registerAction(Action action) {
        this.actions.addElement(action);
    }

    public Action getAction(String name) {
        Enumeration e = this.actions.elements();
        while (e.hasMoreElements()) {
            Action action = (Action)e.nextElement();
            if (!name.equals(action.getValue(INTERNAL_NAME))) continue;
            return action;
        }
        return this.nextInChain != null ? this.nextInChain.getAction(name) : null;
    }

    public void doAction(String name) {
        Action action = this.getAction(name);
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, name));
        }
    }

    public void makeMenuBar(JMenuBar menuBar, JMenu menu, Application.MenuBarTag tag) {
        Enumeration e = tag.elements();
        while (e.hasMoreElements()) {
            String title;
            Application.MenuTag menuTag = (Application.MenuTag)e.nextElement();
            String name = menuTag.name;
            if (menuTag == Application.getInstance().SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            if (menuTag instanceof Application.MenuItemTag) {
                title = this.localize(name);
                Application.MenuItemTag mit = (Application.MenuItemTag)menuTag;
                Action action = this.getAction(name);
                if (action == null) continue;
                this.addMenuItem(menu, action, mit.shortcut, mit.mnemonic);
                continue;
            }
            if (!(menuTag instanceof Application.MenuTag)) continue;
            title = this.localize(name);
            JMenu subMenu = new JMenu(title);
            subMenu.setMnemonic(menuTag.mnemonic);
            this.makeMenuBar(menuBar, subMenu, menuTag);
            if (subMenu.getItemCount() == 0) continue;
            if (menu != null) {
                menu.add(subMenu);
                continue;
            }
            menuBar.add(subMenu);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, Action action, char accelerator, char mnemonic) {
        String label = (String)action.getValue("ShortDescription");
        if (label == null) {
            label = this.localize((String)action.getValue(INTERNAL_NAME));
        }
        JMenuItem item = action instanceof Checkable ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
        item.setHorizontalTextPosition(4);
        item.setVerticalTextPosition(0);
        item.setEnabled(action.isEnabled());
        menu.add(item);
        if (accelerator != '\u0000') {
            int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            item.setAccelerator(KeyStroke.getKeyStroke((int)accelerator, mask));
        }
        if (mnemonic != '\u0000') {
            item.setMnemonic(mnemonic);
        }
        return item;
    }

    public void addSpecialMenuItem(JMenu menu, String name) {
    }

    public String localize(String name) {
        return name;
    }
}

