/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.Application;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class DialogController
implements Runnable {
    protected JDialog dialog;
    protected Frame parent;
    private JTextComponent text;

    public DialogController(Frame frame, String title, boolean modal) {
        this(frame, title, true, modal);
    }

    public DialogController(Frame frame, String title, boolean resizable, boolean modal) {
        this.parent = frame;
        this.dialog = new JDialog(frame, title, modal);
        this.dialog.setResizable(resizable);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogController.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.dialog.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension size = this.dialog.getSize();
            Dimension screenSize = this.dialog.getToolkit().getScreenSize();
            this.dialog.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 3);
        }
        this.dialog.setVisible(b);
    }

    public void show() {
        if (this.text != null) {
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    DialogController.this.text.requestFocus();
                }
            });
        }
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public Container getContentPane() {
        return this.dialog.getContentPane();
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setCursor(Cursor cursor) {
        this.dialog.setCursor(cursor);
    }

    public Toolkit getToolkit() {
        return this.dialog.getToolkit();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void dispose() {
        this.parent = null;
        this.dialog.dispose();
    }

    public void setDefaultButton(JButton button) {
        this.dialog.getRootPane().setDefaultButton(button);
    }

    public void selectTextField(JTextField text) {
        this.text = text;
    }

    public void run() {
        this.text.selectAll();
        this.text.requestFocus();
        this.text = null;
    }

    public static String localize(String s) {
        return Application.getInstance().localize(s);
    }
}

