/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class GraphicsUtils {
    public static GeneralPath arrowPath(float length, float shaftWidth, float headLength, float headWidth) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, shaftWidth);
        path.lineTo(length - headLength, shaftWidth);
        path.lineTo(length - headLength, headWidth);
        path.lineTo(length, 0.0f);
        path.lineTo(length - headLength, -headWidth);
        path.lineTo(length - headLength, -shaftWidth);
        path.lineTo(0.0f, -shaftWidth);
        path.closePath();
        return path;
    }

    public static void drawArrow(Graphics2D graphics, float x1, float y1, float x2, float y2, float shaftWidth, float headLength, float headWidth) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        AffineTransform saveTransform = graphics.getTransform();
        graphics.translate(x1, y1);
        graphics.rotate(Math.atan2(dy, dx));
        GeneralPath path = GraphicsUtils.arrowPath((float)Math.sqrt(dx * dx + dy * dy), shaftWidth, headLength, headWidth);
        graphics.fill(path);
        graphics.setTransform(saveTransform);
    }

    public static void drawSimpleArrow(Graphics2D graphics, float x1, float y1, float x2, float y2, float headLength, float headWidth, boolean drawShaft) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        AffineTransform saveTransform = graphics.getTransform();
        graphics.translate(x1, y1);
        graphics.rotate(Math.atan2(dy, dx));
        GeneralPath path = new GeneralPath();
        if (drawShaft) {
            path.moveTo(0.0f, 0.0f);
            path.lineTo(length, 0.0f);
        }
        path.moveTo(length, 0.0f);
        path.lineTo(length - headLength, headWidth);
        path.moveTo(length, 0.0f);
        path.lineTo(length - headLength, -headWidth);
        graphics.draw(path);
        graphics.setTransform(saveTransform);
    }

    public static void drawSimpleArrow(Graphics2D graphics, float x1, float y1, float x2, float y2, float headLength, float headWidth) {
        GraphicsUtils.drawSimpleArrow(graphics, x1, y1, x2, y2, headLength, headWidth, true);
    }

    public static void drawArrowHeads(Graphics2D g, PathIterator e, float headLength, float headWidth) {
        double[] p = new double[6];
        float thisX = 0.0f;
        float thisY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        int i = 0;
        while (!e.isDone()) {
            int type = e.currentSegment(p);
            switch (type) {
                case 0: 
                case 1: {
                    lastX = thisX;
                    lastY = thisY;
                    thisX = (float)p[0];
                    thisY = (float)p[1];
                    if (i != 1) break;
                    GraphicsUtils.drawSimpleArrow(g, thisX, thisY, lastX, lastY, headLength, headWidth, false);
                }
            }
            ++i;
            e.next();
        }
        if (i > 0) {
            GraphicsUtils.drawSimpleArrow(g, lastX, lastY, thisX, thisY, headLength, headWidth, false);
        }
    }

    public static GeneralPath regularPolygon(double centreX, double centreY, double radius1, double radius2, int count) {
        GeneralPath path = new GeneralPath();
        for (int j = 0; j < count; ++j) {
            double angle = -(Math.PI * 2 * (double)j) / (double)count;
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            double x = 0.0;
            double y = radius2;
            double nx = centreX + (c * x + s * y);
            y = centreY + (-s * x + c * y);
            if (j == 0) {
                path.moveTo((float)nx, (float)y);
            } else {
                path.lineTo((float)nx, (float)y);
            }
            if (radius2 == 0.0) continue;
            angle = -(Math.PI * 2 * ((double)j + 0.5)) / (double)count;
            s = Math.sin(angle);
            c = Math.cos(angle);
            x = 0.0;
            y = radius1;
            nx = centreX + (c * x + s * y);
            y = centreY + (-s * x + c * y);
            path.lineTo((float)nx, (float)y);
        }
        path.closePath();
        return path;
    }

    public static GeneralPath symmetryPath(double centreX, double centreY, Shape s, int count) {
        GeneralPath path = new GeneralPath();
        for (int j = 0; j < count; ++j) {
            double angle = -(Math.PI * 2 * (double)j) / (double)count;
            AffineTransform t = AffineTransform.getRotateInstance(angle, centreX, centreY);
            path.append(s.getPathIterator(t), true);
        }
        path.closePath();
        return path;
    }

    public static void drawTextAlongPath(Shape shape, Graphics2D g2d, String string, double flatness) {
        if (string.length() == 0) {
            return;
        }
        PathIterator iter = shape.getPathIterator(null, flatness);
        double[] coords = new double[6];
        char[] chars = new char[string.length()];
        int strLen = string.length();
        string.getChars(0, strLen, chars, 0);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector gv = g2d.getFont().createGlyphVector(frc, chars);
        double startX = 0.0;
        double startY = 0.0;
        double currentX = 0.0;
        double currentY = 0.0;
        double previousX = 0.0;
        double orgX = 0.0;
        double orgY = 0.0;
        double segLen = 0.0;
        double segRemaining = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        AffineTransform tr = g2d.getTransform();
        block0: for (int i = 0; i < strLen; ++i) {
            double charWidth;
            int index = i % strLen;
            double needsWidth = charWidth = (double)gv.getGlyphMetrics(index).getAdvance();
            while (needsWidth > 0.0) {
                if (segRemaining <= 0.0) {
                    if (iter.isDone()) break block0;
                    int type = iter.currentSegment(coords);
                    iter.next();
                    if (type == 0) {
                        needsWidth = charWidth;
                        orgX = currentX = coords[0];
                        startX = currentX;
                        orgY = currentY = coords[1];
                        startY = currentY;
                        segRemaining = 0.0;
                        continue;
                    }
                    if (type == 4) {
                        coords[0] = startX;
                        coords[1] = startY;
                    }
                    previousX = currentX;
                    double previousY = currentY;
                    currentX = coords[0];
                    currentY = coords[1];
                    dx = currentX - previousX;
                    dy = currentY - previousY;
                    segRemaining = segLen = Math.sqrt(dx * dx + dy * dy);
                }
                double lenTaken = needsWidth > segRemaining ? segRemaining : needsWidth;
                needsWidth -= lenTaken;
                segRemaining -= lenTaken;
            }
            double endX = currentX - dx * segRemaining / segLen;
            double endY = currentY - dy * segRemaining / segLen;
            double theta = Math.atan2(endY - orgY, endX - orgX);
            g2d.rotate(theta, orgX, orgY);
            g2d.drawString(new String(chars, index, 1), (float)orgX, (float)orgY);
            g2d.setTransform(tr);
            orgX = endX;
            orgY = endY;
        }
    }
}

