/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.app;

import com.jhlabs.app.Application;
import com.jhlabs.app.Document;
import com.jhlabs.app.DocumentWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

class WindowMenuItem
extends JMenuItem
implements ActionListener,
PropertyChangeListener {
    private int windowID;

    public WindowMenuItem(DocumentWindow window) {
        super(window.getWindowTitle());
        this.windowID = window.getUniqueID();
        this.addActionListener(this);
        window.getDocument().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        String p = e.getPropertyName();
        if (source instanceof Document && (p.equals("file") || p.equals("changed") || p.equals("views"))) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DocumentWindow window = Application.getInstance().getWindow(WindowMenuItem.this.windowID);
                    if (window != null) {
                        WindowMenuItem.this.setText(window.getWindowTitle());
                    }
                }
            });
        }
    }

    public void dispose() {
        DocumentWindow window = Application.getInstance().getWindow(this.windowID);
        if (window != null) {
            window.getDocument().removePropertyChangeListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        DocumentWindow window = Application.getInstance().getWindow(this.windowID);
        if (window != null) {
            if (window.isVisible()) {
                window.toFront();
            } else {
                window.setVisible(true);
            }
        }
    }
}

