/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.io;

import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.FileFormat;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileCacheImageOutputStream;

public class FileFormatImageIO
extends FileFormat {
    public FileFormatImageIO() {
        super("ImageIO", (String)null, null, null);
    }

    public Enumeration getSubFileFormats() {
        HashSet<String> added = new HashSet<String>();
        Vector<Writer> list = new Vector<Writer>();
        String[] names = ImageIO.getWriterFormatNames();
        ImageTypeSpecifier its = ImageTypeSpecifier.createFromBufferedImageType(2);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].toUpperCase();
            if (added.contains(name)) continue;
            added.add(name);
            Iterator<ImageWriter> it = ImageIO.getImageWriters(its, names[i]);
            if (it == null || !it.hasNext()) continue;
            list.add(new Writer(names[i]));
        }
        return list.elements();
    }

    public boolean canRead(byte[] fileStart) {
        return false;
    }

    public boolean shouldOpenFile() {
        return false;
    }

    public BufferedImage readBufferedImage(File file, InputStream in) throws IOException {
        return ImageIO.read(file);
    }

    static class Writer
    extends FileFormat {
        private String formatName;

        public Writer(String formatName) {
            super("ImageIO: " + formatName, (String)null, formatName.toLowerCase(), null);
            this.formatName = formatName;
        }

        public boolean canWrite() {
            return true;
        }

        public void writeImage(File file, OutputStream out, CompositionDocument document) throws IOException {
            BufferedImage image = document.getCompositeImage();
            ImageIO.write((RenderedImage)image, this.formatName, new FileCacheImageOutputStream(out, null));
        }
    }
}

