/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.CompositionDocument;
import com.jhlabs.ie.tool.SelectionTool;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class SelectAreaTool
extends SelectionTool {
    protected boolean square;

    public boolean doStartDrag() {
        this.square = this.event.isMetaDown();
        return super.doStartDrag();
    }

    public void doDrag(boolean erase) {
        int x = Math.min(this.startX, this.currX);
        int y = Math.min(this.startY, this.currY);
        int w = Math.abs(this.startX - this.currX);
        int h = Math.abs(this.startY - this.currY);
        if (!erase) {
            this.square = this.event.isMetaDown();
        }
        if (this.square) {
            w = h = Math.min(w, h);
        }
        this.graphics.drawRect(x, y, w, h);
    }

    public void doDrawing(Graphics2D g, Rectangle r) {
        Rectangle2D.Float s = new Rectangle2D.Float(r.x, r.y, r.width, r.height);
        g.fill(s);
    }

    public void doEndDrag() {
        boolean clear = !this.event.isShiftDown() && !this.event.isControlDown();
        Rectangle r = this.getRectangle();
        this.square = this.event.isMetaDown();
        if (this.square) {
            r.width = r.height = Math.min(r.width, r.height);
        }
        if (r.isEmpty()) {
            return;
        }
        BufferedImage selection = this.view.getSelection();
        CompositionDocument document = this.view.getDocument();
        Composition composition = document.getComposition();
        Rectangle bounds = composition.getSelectedBounds();
        if (clear) {
            composition.selectNone();
        }
        Graphics2D g = selection.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.event.isControlDown()) {
            g.setComposite(AlphaComposite.getInstance(1));
        } else {
            g.setColor(new Color(-16777216));
            g.setComposite(AlphaComposite.getInstance(2));
        }
        this.doDrawing(g, r);
        g.dispose();
        if (clear && bounds != null) {
            r = r.union(bounds);
        }
        composition.startUpdate();
        composition.updateSelection(r);
        composition.endUpdate(false);
    }

    public char getShortcutKey() {
        return 'm';
    }

    public String getToolTipText() {
        return "Rectangle Selection Tool";
    }

    public String getHelpText() {
        return "Rectangle Selection Tool: Shift key adds, Control key subtracts";
    }
}

