/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.Composition;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.ie.tool.SelectionTool;
import com.jhlabs.ie.tool.WandToolCustomizer;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.fill.PixelCompareOp;
import com.jhlabs.image.fill.PixelOp;
import com.jhlabs.image.fill.SeedFill;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;

public class WandTool
extends SelectionTool
implements PixelOp,
PixelCompareOp {
    private BufferedImage image;
    private BufferedImage selection;
    private int value;
    private int color;
    private int tolerance = 0;
    protected int[] dataBufferRGB;
    protected int dataBufferOffset;
    protected int dataBufferScanStride;
    private static Cursor cursor;

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public boolean doStartDrag() {
        boolean clear = !this.event.isShiftDown() && !this.event.isControlDown();
        this.value = this.event.isControlDown() ? 0 : -16777216;
        Composition composition = this.view.getComposition();
        Layer layer = composition.getActiveLayer();
        int x = this.view.XTox(this.currX);
        int y = this.view.YToy(this.currY);
        if (!layer.getBounds().contains(x, y)) {
            return false;
        }
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        this.image = layer.getImage();
        this.selection = this.view.getSelection();
        composition.startUpdate();
        if (clear) {
            composition.selectNone();
            composition.update(layer);
        }
        this.color = this.image.getRGB(x, y);
        DataBufferInt dataBuffer = (DataBufferInt)this.selection.getRaster().getDataBuffer();
        this.dataBufferRGB = dataBuffer.getBankData()[0];
        this.dataBufferOffset = dataBuffer.getOffset();
        this.dataBufferScanStride = ((SinglePixelPackedSampleModel)this.selection.getSampleModel()).getScanlineStride();
        SeedFill sf = new SeedFill();
        composition.update(sf.fill(layer.getWidth(), layer.getHeight(), x, y, this, this));
        composition.endUpdate(false);
        return true;
    }

    public void apply(int x, int y) {
        this.dataBufferRGB[this.dataBufferOffset + y * this.dataBufferScanStride + x] = this.value;
    }

    public boolean thisPixel(int x, int y) {
        int offset = this.dataBufferOffset + y * this.dataBufferScanStride + x;
        if (this.tolerance == 0) {
            return this.dataBufferRGB[offset] != this.value && this.image.getRGB(x, y) == this.color;
        }
        return this.dataBufferRGB[offset] != this.value && PixelUtils.nearColors(this.image.getRGB(x, y), this.color, this.tolerance);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new WandToolCustomizer();
    }

    public void setCursor(Component c) {
        if (cursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(this.getClass().getResource("WandTool.gif"));
            cursor = toolkit.createCustomCursor(image, new Point(5, 5), "tool");
        }
        c.setCursor(cursor);
    }

    public char getShortcutKey() {
        return 'w';
    }

    public String getToolTipText() {
        return "Magic Wand Selection Tool";
    }

    public String getHelpText() {
        return "Magic Wand Selection Tool: Shift key adds, Control key subtracts";
    }
}

