/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.Application;
import com.jhlabs.ie.Palette;
import com.jhlabs.ie.ui.ColorCanvas;
import com.jhlabs.image.PaintingContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class ColorChooser
extends JComponent
implements Palette,
PropertyChangeListener {
    private ColorCanvas hueCanvas;
    private ColorCanvas satCanvas;
    private Color color;

    public ColorChooser() {
        this.setLayout(new BorderLayout());
        this.satCanvas = new ColorCanvas(this, false);
        this.add((Component)this.satCanvas, "North");
        this.hueCanvas = new ColorCanvas(this, true);
        this.add((Component)this.hueCanvas, "Center");
    }

    public void startup(Application application) {
        PaintingContext.getInstance().addPropertyChangeListener(this);
    }

    public void shutdown() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("fgColor".equals(name)) {
            Color c = (Color)event.getNewValue();
            this.satCanvas.setColor(c);
            this.hueCanvas.setColor(c);
            this.color = c;
        }
    }

    public void setColor(Color c) {
        this.setThisColor(c);
        this.satCanvas.setColor(c);
        this.hueCanvas.setColor(c);
    }

    public void setThisColor(Color c) {
        Color oldColor = this.color;
        this.color = c;
        PaintingContext.getInstance().setFgColor(c.getRGB());
    }

    public Color getColor() {
        return this.color;
    }

    public void colorChanged(ColorCanvas source) {
        if (source == this.hueCanvas) {
            this.satCanvas.setColor(this.hueCanvas.getColor());
            this.setThisColor(this.satCanvas.getColor());
        } else if (source == this.satCanvas) {
            this.hueCanvas.setColor(this.satCanvas.getColor());
            this.setThisColor(this.satCanvas.getColor());
        }
    }

    public String getName() {
        return "showColors";
    }
}

