/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PaintingContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class ColorPatches
extends JComponent
implements PropertyChangeListener {
    private int cellSize = 32;
    private int offset = 16;
    private PaintingContext context;

    public ColorPatches(PaintingContext context) {
        this.context = context;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.enableEvents(16L);
        context.addPropertyChangeListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(48, 48);
    }

    public void paint(Graphics g) {
        if ((this.context.getFgColor() & 0xFF000000) == 0) {
            g.setColor(Color.gray);
            g.fillRect(this.offset, this.offset, this.cellSize, this.cellSize);
        }
        this.paintColorCell(g, this.offset, this.offset, this.context.getBgColor());
        this.paintColorCell(g, 0, 0, this.context.getFgColor());
        this.paintBlackAndWhite(g);
        this.paintSwap(g);
    }

    protected void paintColorCell(Graphics g, int x, int y, int color) {
        if ((color & 0xFF000000) == 0) {
            ImageUtils.paintCheckedBackground(this, g, x, y, this.cellSize, this.cellSize);
        } else {
            g.setColor(new Color(color));
            g.fillRect(x, y, this.cellSize, this.cellSize);
        }
        g.setColor(Color.black);
        g.drawRect(x, y, this.cellSize - 1, this.cellSize - 1);
    }

    protected void paintBlackAndWhite(Graphics g) {
        int y = this.offset + this.cellSize - 9;
        g.setColor(Color.white);
        g.fillRect(0, y, 4, 4);
        g.setColor(Color.black);
        g.drawRect(0, y, 5, 5);
        g.fillRect(3, y + 3, 6, 6);
    }

    protected void paintSwap(Graphics g) {
        int x = this.offset + this.cellSize - 8;
        g.drawLine(x, 3, x, 0);
        g.drawLine(x, 0, x + 3, 0);
        g.drawLine(x + 3, 6, x + 6, 6);
        g.drawLine(x + 6, 6, x + 6, 3);
        g.drawLine(x, 0, x + 6, 6);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            int x = e.getX();
            int y = e.getY();
            int fgColor = this.context.getFgColor();
            int bgColor = this.context.getBgColor();
            if (x >= this.cellSize || y >= this.cellSize) {
                if (x < this.offset && y >= this.cellSize) {
                    fgColor = -16777216;
                    bgColor = -1;
                } else if (y < this.offset && x >= this.cellSize) {
                    int t = fgColor;
                    fgColor = bgColor;
                    bgColor = t;
                }
            }
            this.context.setFgColor(fgColor);
            this.context.setBgColor(bgColor);
        }
        super.processMouseEvent(e);
    }

    private String colorString(int rgb) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return "A=" + a + " R=" + r + " G=" + g + " B=" + b + " ARGB=" + Integer.toHexString(rgb);
    }

    public String getToolTipText(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (x < this.cellSize && y < this.cellSize) {
            return "Foreground color: " + this.colorString(this.context.getFgColor());
        }
        if (x < this.offset && y >= this.cellSize) {
            return "Set colors to black and white";
        }
        if (y < this.offset && x >= this.cellSize) {
            return "Exchange colors";
        }
        return "Background color: " + this.colorString(this.context.getBgColor());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if ("fgColor".equals(name) || "fgColor".equals(name)) {
            this.repaint();
        }
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }
}

