/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.app.Application;
import com.jhlabs.ie.CompositionApplication;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.swing.SliderFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientEditor
extends JComponent
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    public Gradient gradient;
    private int dragKnot = -1;
    private int selectedKnot = 1;
    private Graphics dragGraphics;
    private int dragX = 0;
    private int dragDX = 0;
    private boolean newImage = true;
    private JMenuItem removeItem;
    private JMenuItem splitItem;
    private JMenuItem randomizeItem;
    private JMenuItem constantItem;
    private JMenuItem linearItem;
    private JMenuItem splineItem;
    private JMenuItem circleUpItem;
    private JMenuItem circleDownItem;
    private JMenuItem rgbItem;
    private JMenuItem hueCWItem;
    private JMenuItem hueCCWItem;
    private JSlider opacitySlider;
    private Vector listeners = new Vector();
    protected Display display = new Display();

    public GradientEditor() {
        this(null);
    }

    public GradientEditor(Gradient gradient) {
        this.gradient = gradient;
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        this.add((Component)menuBar, "North");
        JMenu editMenu = new JMenu("Edit");
        menuBar.add(editMenu);
        this.removeItem = new JMenuItem("Remove Segment");
        editMenu.add(this.removeItem);
        this.splitItem = new JMenuItem("Split Segment");
        editMenu.add(this.splitItem);
        editMenu.addSeparator();
        this.randomizeItem = new JMenuItem("Randomize");
        editMenu.add(this.randomizeItem);
        this.removeItem.addActionListener(this);
        this.splitItem.addActionListener(this);
        this.randomizeItem.addActionListener(this);
        JMenu spanMenu = new JMenu("Type");
        menuBar.add(spanMenu);
        this.constantItem = new JMenuItem("Constant");
        spanMenu.add(this.constantItem);
        this.linearItem = new JMenuItem("Linear");
        spanMenu.add(this.linearItem);
        this.splineItem = new JMenuItem("Spline");
        spanMenu.add(this.splineItem);
        this.circleUpItem = new JMenuItem("Circle Up");
        spanMenu.add(this.circleUpItem);
        this.circleDownItem = new JMenuItem("Circle Down");
        spanMenu.add(this.circleDownItem);
        spanMenu.addSeparator();
        this.rgbItem = new JMenuItem("RGB");
        spanMenu.add(this.rgbItem);
        this.hueCWItem = new JMenuItem("Clockwise Hue");
        spanMenu.add(this.hueCWItem);
        this.hueCCWItem = new JMenuItem("Counter-clockwise Hue");
        spanMenu.add(this.hueCCWItem);
        this.constantItem.addActionListener(this);
        this.linearItem.addActionListener(this);
        this.splineItem.addActionListener(this);
        this.circleUpItem.addActionListener(this);
        this.circleDownItem.addActionListener(this);
        this.rgbItem.addActionListener(this);
        this.hueCWItem.addActionListener(this);
        this.hueCCWItem.addActionListener(this);
        this.display = new Display();
        this.add((Component)this.display, "Center");
        JPanel p = new JPanel();
        p.add(new JLabel("Opacity: ", 4));
        this.opacitySlider = SliderFactory.createPercentageSlider();
        p.add(this.opacitySlider);
        this.opacitySlider.addChangeListener(this);
        this.opacitySlider.setEnabled(false);
        this.add((Component)p, "South");
    }

    public void setGradient(Gradient gradient) {
        this.gradient = gradient;
        this.selectedKnot = 1;
        this.repaint();
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public void fireColorChange(Color c) {
        this.firePropertyChange("color", null, c);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addElement(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeElement(l);
    }

    protected void fireStateChanged() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ChangeListener l = (ChangeListener)e.nextElement();
            l.stateChanged(new ChangeEvent(this));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value;
        if ("color".equals(event.getPropertyName()) && (value = event.getNewValue()) instanceof Color && this.selectedKnot != -1) {
            int rgb = ((Color)value).getRGB();
            this.gradient.setKnot(this.selectedKnot, rgb);
            this.newImage = true;
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.opacitySlider && this.selectedKnot != -1) {
            int color = this.gradient.getKnot(this.selectedKnot) & 0xFFFFFF | this.opacitySlider.getValue() * 255 / 100 << 24;
            this.gradient.setKnot(this.selectedKnot, color);
            this.newImage = true;
            this.repaint();
            this.fireStateChanged();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.linearItem) {
            this.gradient.setKnotBlend(this.selectedKnot, 16);
        } else if (source == this.splineItem) {
            this.gradient.setKnotBlend(this.selectedKnot, 32);
        } else if (source == this.circleUpItem) {
            this.gradient.setKnotBlend(this.selectedKnot, 48);
        } else if (source == this.circleDownItem) {
            this.gradient.setKnotBlend(this.selectedKnot, 64);
        } else if (source == this.constantItem) {
            this.gradient.setKnotBlend(this.selectedKnot, 80);
        } else if (source == this.rgbItem) {
            this.gradient.setKnotType(this.selectedKnot, 0);
        } else if (source == this.hueCWItem) {
            this.gradient.setKnotType(this.selectedKnot, 1);
        } else if (source == this.hueCCWItem) {
            this.gradient.setKnotType(this.selectedKnot, 2);
        } else if (source == this.removeItem) {
            if (this.selectedKnot > 0 && this.gradient.getNumKnots() > 4) {
                this.gradient.removeKnot(this.selectedKnot);
            }
        } else if (source == this.splitItem) {
            this.gradient.splitSpan(this.selectedKnot);
        } else if (source == this.randomizeItem) {
            this.gradient.randomize();
            this.selectedKnot = 1;
        }
        this.newImage = true;
        this.repaint();
    }

    class Display
    extends JComponent
    implements KeyListener {
        private ImageIcon arrowIcon = new ImageIcon(this.getClass().getResource("arrowUp.gif"));
        private Image image;
        private MemoryImageSource source;
        private boolean realDrag = true;
        private static final int leftMargin = 6;
        private static final int topmargin = 12;
        private static final int imageHeight = 28;
        private static final int dragHeight = 8;
        private static final int handleY = 40;

        public Display() {
            this.enableEvents(16L);
            this.addKeyListener(this);
            this.setToolTipText("Click above a triangle to drop paint color");
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 64);
        }

        public Dimension getMinimumSize() {
            return new Dimension(256, 64);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.image = null;
        }

        public void paintComponent(Graphics g) {
            if (GradientEditor.this.gradient != null) {
                Dimension size = this.getSize();
                int w = size.width - 12;
                int h = size.height;
                if (GradientEditor.this.newImage || this.image == null) {
                    this.makeImage(w);
                }
                g.setColor(Color.white);
                g.fillRect(0, 0, size.width, size.height);
                ImageUtils.paintCheckedBackground(this, g, 6, 12, w, 28);
                g.drawImage(this.image, 6, 12, w, 28, this);
                if (GradientEditor.this.selectedKnot != -1) {
                    int x1 = 6 + w * GradientEditor.this.gradient.getKnotPosition(GradientEditor.this.selectedKnot) / 256;
                    int x2 = 6 + w * GradientEditor.this.gradient.getKnotPosition(GradientEditor.this.selectedKnot + 1) / 256;
                    g.setColor(Color.gray);
                    g.fillRect(x1, 40, x2 - x1, 8);
                }
                int y = 40;
                for (int i = 1; i < GradientEditor.this.gradient.getNumKnots() - 1; ++i) {
                    int x = 6 + w * GradientEditor.this.gradient.getKnotPosition(i) / 256;
                    this.arrowIcon.paintIcon(this, g, x - 3, y);
                    g.setColor(new Color(GradientEditor.this.gradient.getKnot(i)));
                    g.fillRect(x - 3, y + 8, 7, 7);
                    g.setColor(Color.black);
                    g.drawRect(x - 4, y + 7, 8, 8);
                }
            }
        }

        private void makeImage(int w) {
            int[] pixels = new int[w];
            for (int x = 0; x < w; ++x) {
                int rgb;
                pixels[x] = rgb = GradientEditor.this.gradient.getColor((float)x / (float)w);
            }
            GradientEditor.this.newImage = false;
            if (this.image == null) {
                this.source = new MemoryImageSource(w, 1, ColorModel.getRGBdefault(), pixels, 0, w);
                this.image = this.createImage(this.source);
                this.source.setAnimated(true);
            } else {
                this.source.newPixels(pixels, ColorModel.getRGBdefault(), 0, w);
            }
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (GradientEditor.this.selectedKnot > 0 && GradientEditor.this.selectedKnot < GradientEditor.this.gradient.getNumKnots() - 1) {
                switch (code) {
                    case 8: 
                    case 127: {
                        if (GradientEditor.this.selectedKnot <= 0 || GradientEditor.this.gradient.getNumKnots() <= 4) break;
                        GradientEditor.this.gradient.removeKnot(GradientEditor.this.selectedKnot);
                        this.repaint();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        protected void processMouseEvent(MouseEvent e) {
            if (GradientEditor.this.gradient == null) {
                return;
            }
            int id = e.getID();
            int x = e.getX();
            int y = e.getY();
            switch (id) {
                case 501: {
                    this.requestFocus();
                    int width = this.getSize().width - 12;
                    int knotIndex = -1;
                    int spanIndex = -1;
                    for (int i = 1; i < GradientEditor.this.gradient.getNumKnots() - 1; ++i) {
                        int pos = 6 + width * GradientEditor.this.gradient.getKnotPosition(i) / 256;
                        if (Math.abs(x - pos) < 4) {
                            knotIndex = i;
                            spanIndex = i;
                            break;
                        }
                        if (x >= pos) continue;
                        spanIndex = i - 1;
                        break;
                    }
                    if (y < 40 && e.isControlDown()) {
                        ((CompositionApplication)Application.getInstance()).setFgColor(GradientEditor.this.gradient.getColor((float)(x - 6) / (float)width));
                        break;
                    }
                    if (knotIndex == -1) {
                        if (e.isShiftDown()) {
                            GradientEditor.this.gradient.addKnot(256 * x / width, -16777216, 32);
                            GradientEditor.this.newImage = true;
                            this.repaint();
                            GradientEditor.this.fireStateChanged();
                            break;
                        }
                        GradientEditor.this.selectedKnot = spanIndex;
                        this.repaint();
                        break;
                    }
                    if (y >= 48 && y <= 56) {
                        if (e.isControlDown()) {
                            ((CompositionApplication)Application.getInstance()).setFgColor(GradientEditor.this.gradient.getColor((float)(x - 6) / (float)width));
                            break;
                        }
                        int color = ((CompositionApplication)Application.getInstance()).getPaintColor(e);
                        GradientEditor.this.gradient.setKnot(knotIndex, color);
                        GradientEditor.this.newImage = true;
                        this.repaint();
                        GradientEditor.this.fireStateChanged();
                    }
                    GradientEditor.this.selectedKnot = knotIndex;
                    if (knotIndex > 1 && knotIndex < GradientEditor.this.gradient.getNumKnots() - 2) {
                        GradientEditor.this.dragKnot = knotIndex;
                        GradientEditor.this.dragX = x;
                        GradientEditor.this.dragDX = 0;
                        if (this.realDrag) {
                            GradientEditor.this.newImage = true;
                            this.repaint();
                        } else {
                            GradientEditor.this.dragGraphics = this.getGraphics();
                            GradientEditor.this.dragGraphics.setXORMode(this.getBackground());
                            this.arrowIcon.paintIcon(this, GradientEditor.this.dragGraphics, GradientEditor.this.dragX - GradientEditor.this.dragDX - 3, 40);
                        }
                        this.enableEvents(48L);
                    } else {
                        this.repaint();
                    }
                    GradientEditor.this.opacitySlider.setEnabled(GradientEditor.this.selectedKnot != -1);
                    if (GradientEditor.this.selectedKnot == -1) break;
                    GradientEditor.this.opacitySlider.setValue((GradientEditor.this.gradient.getKnot(GradientEditor.this.selectedKnot) >> 24 & 0xFF) * 100 / 255);
                    break;
                }
                case 502: {
                    this.enableEvents(16L);
                    if (GradientEditor.this.dragKnot != -1) {
                        if (this.realDrag) {
                            GradientEditor.this.newImage = true;
                            this.repaint();
                        } else {
                            this.arrowIcon.paintIcon(this, GradientEditor.this.dragGraphics, GradientEditor.this.dragX - GradientEditor.this.dragDX - 3, 40);
                            GradientEditor.this.dragGraphics.dispose();
                            GradientEditor.this.dragGraphics = null;
                        }
                        x -= GradientEditor.this.dragDX;
                        x = ImageMath.clamp(x, 6, this.getSize().width - 6);
                        GradientEditor.this.gradient.setKnotPosition(GradientEditor.this.dragKnot, 256 * x / this.getSize().width);
                        GradientEditor.this.newImage = true;
                        this.repaint();
                        GradientEditor.this.fireStateChanged();
                    }
                    GradientEditor.this.dragKnot = -1;
                }
            }
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            int id = e.getID();
            int x = e.getX();
            int y = e.getY();
            switch (id) {
                case 506: {
                    if (GradientEditor.this.dragKnot == -1) break;
                    if (this.realDrag) {
                        GradientEditor.this.dragX = x;
                        x -= GradientEditor.this.dragDX;
                        x = ImageMath.clamp(x, 6, this.getSize().width - 6);
                        GradientEditor.this.gradient.setKnotPosition(GradientEditor.this.dragKnot, 256 * x / this.getSize().width);
                        GradientEditor.this.newImage = true;
                        this.repaint();
                        break;
                    }
                    this.arrowIcon.paintIcon(this, GradientEditor.this.dragGraphics, GradientEditor.this.dragX - GradientEditor.this.dragDX - 3, 40);
                    GradientEditor.this.dragX = x;
                    this.arrowIcon.paintIcon(this, GradientEditor.this.dragGraphics, GradientEditor.this.dragX - GradientEditor.this.dragDX - 3, 40);
                }
            }
            super.processMouseMotionEvent(e);
        }
    }
}

