/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.beans.AbstractPropertyEditor;
import com.jhlabs.image.Curve;
import com.jhlabs.image.ImageMath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CurvePropertyEditor
extends AbstractPropertyEditor {
    protected Curve[] curves;
    protected Editor editor;

    public Component getCustomEditor() {
        this.editor = new Editor();
        return this.editor;
    }

    public Object getValue() {
        if (this.editor.useRGBCurve()) {
            this.curves[1] = new Curve(this.curves[0]);
            this.curves[2] = new Curve(this.curves[0]);
        }
        return this.curves;
    }

    public void setValue(Object value) {
        this.curves = (Curve[])value;
        this.editor.setCurves(this.curves);
    }

    public boolean alwaysRefresh() {
        return true;
    }

    class Graph
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        private Curve[] curves;
        private Curve curve;
        private int whichCurve = 0;
        private int selected = -1;
        private boolean showRGB = true;

        public Graph() {
            this.addMouseListener(this);
            this.addKeyListener(this);
        }

        public Dimension getMinimumSize() {
            return new Dimension(257, 257);
        }

        public Dimension getPreferredSize() {
            return new Dimension(257, 257);
        }

        public void setCurves(Curve[] curves) {
            this.curves = curves;
            if (this.whichCurve > curves.length) {
                this.whichCurve = 0;
            }
            this.curve = curves[this.whichCurve];
            this.repaint();
        }

        public void setWhichCurve(int which) {
            this.whichCurve = which;
            if (this.whichCurve == -1) {
                this.whichCurve = 0;
                this.showRGB = true;
            } else {
                this.showRGB = false;
            }
            if (this.curves != null) {
                this.curve = this.curves[this.whichCurve];
                this.repaint();
            }
        }

        protected void graph(Graphics2D g, Curve curve, Color color, boolean drawHandles) {
            int i;
            GeneralPath p = new GeneralPath();
            int numKnots = curve.x.length;
            float[] nx = new float[numKnots + 2];
            float[] ny = new float[numKnots + 2];
            System.arraycopy(curve.x, 0, nx, 1, numKnots);
            System.arraycopy(curve.y, 0, ny, 1, numKnots);
            nx[0] = nx[1];
            ny[0] = ny[1];
            nx[numKnots + 1] = nx[numKnots];
            ny[numKnots + 1] = ny[numKnots];
            g.setColor(color);
            for (i = 0; i < 255; ++i) {
                float f = (float)i / 255.0f;
                int x = (int)(255.0f * ImageMath.spline(f, nx.length, nx)) + 1;
                int y = 255 - (int)(255.0f * ImageMath.spline(f, nx.length, ny)) + 1;
                x = ImageMath.clamp(x, 0, 255);
                y = ImageMath.clamp(y, 0, 255);
                if (i == 0) {
                    p.moveTo(x, y);
                    continue;
                }
                p.lineTo(x, y);
            }
            g.draw(p);
            if (drawHandles) {
                for (i = 0; i < curve.x.length; ++i) {
                    int x = (int)(255.0f * curve.x[i]) + 1;
                    int y = 255 - (int)(255.0f * curve.y[i]) + 1;
                    g.setColor(color);
                    g.fillOval(x - 4, y - 4, 8, 8);
                    g.setColor(Color.black);
                    g.drawOval(x - 4, y - 4, 8, 8);
                }
            }
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.curves != null) {
                g.setColor(Color.white);
                g.fillRect(1, 1, 255, 255);
                g.setColor(Color.lightGray);
                g.drawLine(1, 255, 255, 1);
                g.setColor(Color.black);
                g.drawRect(0, 0, 255, 255);
                this.graph(g2d, this.curves[0], this.showRGB ? Color.black : Color.red, this.whichCurve == 0);
                if (!this.showRGB && this.curves.length == 3) {
                    this.graph(g2d, this.curves[1], Color.green, this.whichCurve == 1);
                    this.graph(g2d, this.curves[2], Color.blue, this.whichCurve == 2);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            this.requestFocus();
            int x = e.getX() - 1;
            int y = e.getY() - 1;
            int newSelected = -1;
            for (int i = 0; i < this.curve.x.length; ++i) {
                int kx = (int)(255.0f * this.curve.x[i]);
                int ky = 255 - (int)(255.0f * this.curve.y[i]) + 1;
                if (Math.abs(x - kx) >= 5 || Math.abs(y - ky) >= 5) continue;
                newSelected = i;
                this.addMouseMotionListener(this);
                break;
            }
            if (newSelected != this.selected) {
                this.selected = newSelected;
                this.repaint();
            }
            if (newSelected == -1) {
                this.selected = this.curve.addKnot((float)x / 255.0f, 1.0f - (float)y / 255.0f);
                this.addMouseMotionListener(this);
                CurvePropertyEditor.this.firePropertyChange();
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.addMouseMotionListener(this);
            if (this.selected != -1) {
                int x = e.getX() - 1;
                int y = e.getY() - 1;
                if (this.selected != 0 && this.selected != this.curve.x.length - 1 && (x < 0 || x >= this.getWidth() || y < 0 || y > this.getHeight())) {
                    this.curve.removeKnot(this.selected);
                    this.repaint();
                }
                CurvePropertyEditor.this.firePropertyChange();
                this.selected = -1;
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.selected != -1) {
                int x = e.getX() - 1;
                int y = e.getY() - 1;
                x = ImageMath.clamp(x, 0, 255);
                y = ImageMath.clamp(y, 0, 255);
                float fx = (float)x / 255.0f;
                float fy = 1.0f - (float)y / 255.0f;
                if (this.selected > 0) {
                    if (fx < this.curve.x[this.selected - 1]) {
                        fx = this.curve.x[this.selected - 1];
                    }
                } else {
                    fx = 0.0f;
                }
                if (this.selected < this.curve.x.length - 1) {
                    if (fx > this.curve.x[this.selected + 1]) {
                        fx = this.curve.x[this.selected + 1];
                    }
                } else {
                    fx = 1.0f;
                }
                this.curve.x[this.selected] = fx;
                this.curve.y[this.selected] = fy;
                this.repaint();
            }
        }

        public void keyPressed(KeyEvent e) {
            switch (e.getKeyChar()) {
                case '1': 
                case '2': 
                case '3': {
                    this.setWhichCurve(e.getKeyChar() - 49);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class Editor
    extends JPanel
    implements ChangeListener {
        private JToggleButton rgbButton;
        private JToggleButton rButton;
        private JToggleButton gButton;
        private JToggleButton bButton;
        private Graph graph;

        public Editor() {
            this.setLayout(new BorderLayout());
            this.graph = new Graph();
            this.add((Component)this.graph, "North");
            JPanel p = new JPanel();
            ButtonGroup group = new ButtonGroup();
            this.rgbButton = this.makeButton(p, group, "RGB");
            this.rButton = this.makeButton(p, group, "R");
            this.gButton = this.makeButton(p, group, "G");
            this.bButton = this.makeButton(p, group, "B");
            this.rgbButton.setSelected(true);
            this.add((Component)p, "South");
        }

        private JToggleButton makeButton(JPanel p, ButtonGroup group, String label) {
            JToggleButton b = new JToggleButton(label);
            p.add(b);
            group.add(b);
            b.addChangeListener(this);
            b.putClientProperty("Quaqua.Button.style", "square");
            return b;
        }

        public void setCurves(Curve[] curves) {
            this.graph.setCurves(curves);
        }

        public boolean useRGBCurve() {
            return this.rgbButton.isSelected();
        }

        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source == this.rgbButton) {
                this.graph.setWhichCurve(-1);
            } else if (source == this.rButton) {
                this.graph.setWhichCurve(0);
            } else if (source == this.gButton) {
                this.graph.setWhichCurve(1);
            } else if (source == this.bButton) {
                this.graph.setWhichCurve(2);
            }
        }
    }
}

