/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.image.DiffusionFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiffusionFilterCustomizer
extends PreviewFilterCustomizer
implements ItemListener,
ChangeListener {
    private JCheckBox serpentine;
    private JCheckBox colorDither;
    private JComboBox levelsChoice;
    private DiffusionFilter filter;

    public DiffusionFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        p.setLayout(new ParagraphLayout());
        p.add((Component)new JLabel("Levels:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.levelsChoice = new JComboBox();
        p.add(this.levelsChoice);
        this.levelsChoice.addItem("2 (Black and White)");
        this.levelsChoice.addItem("4");
        this.levelsChoice.addItem("5");
        this.levelsChoice.addItem("6 (World Wide Web)");
        this.levelsChoice.addItem("8");
        this.levelsChoice.addItem("16");
        this.levelsChoice.addItemListener(this);
        this.serpentine = new JCheckBox("Serpentine");
        p.add((Component)this.serpentine, ParagraphLayout.NEW_LINE);
        this.serpentine.addChangeListener(this);
        this.colorDither = new JCheckBox("Color Dither");
        p.add((Component)this.colorDither, ParagraphLayout.NEW_LINE);
        this.colorDither.addChangeListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        DiffusionFilter filter = (DiffusionFilter)o;
        this.filter = null;
        this.serpentine.setSelected(filter.getSerpentine());
        this.colorDither.setSelected(filter.getColorDither());
        this.levelsChoice.setSelectedIndex(3);
        this.filter = filter;
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.filter != null) {
            if (source == this.serpentine) {
                this.filter.setSerpentine(this.serpentine.isSelected());
            } else if (source == this.colorDither) {
                this.filter.setColorDither(this.colorDither.isSelected());
            }
            this.preview();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (this.filter != null) {
            if (source == this.levelsChoice) {
                switch (this.levelsChoice.getSelectedIndex()) {
                    case 0: {
                        this.filter.setLevels(2);
                        break;
                    }
                    case 1: {
                        this.filter.setLevels(4);
                        break;
                    }
                    case 2: {
                        this.filter.setLevels(5);
                        break;
                    }
                    case 3: {
                        this.filter.setLevels(6);
                        break;
                    }
                    case 4: {
                        this.filter.setLevels(8);
                        break;
                    }
                    default: {
                        this.filter.setLevels(16);
                    }
                }
            }
            this.preview();
        }
    }
}

