/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class Sampler {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    public static final int NEAREST_NEIGHBOUR = 0;
    public static final int BILINEAR = 1;
    protected BufferedImage image;
    protected WritableRaster raster;
    protected int edgeAction = 0;
    protected int interpolation = 1;
    protected int[] nw = new int[4];
    protected int[] ne = new int[4];
    protected int[] sw = new int[4];
    protected int[] se = new int[4];
    protected int width;
    protected int height;

    public Sampler(BufferedImage image) {
        int type = image.getType();
        if (type != 2 && type == 1) {
            throw new IllegalArgumentException("Sampler only supports TYPE_INT_ARGB or TYPE_INT_RGB images");
        }
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.raster = image.getRaster();
    }

    public void setEdgeAction(int edgeAction) {
        this.edgeAction = edgeAction;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public int sample(float x, float y) {
        int width1 = this.width - 1;
        int height1 = this.height - 1;
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        if (ix >= 0 && ix < width1 && iy >= 0 && iy < height1) {
            this.nw = this.raster.getPixel(ix, iy, this.nw);
            this.ne = this.raster.getPixel(ix + 1, iy, this.ne);
            this.sw = this.raster.getPixel(ix, iy + 1, this.sw);
            this.se = this.raster.getPixel(ix + 1, iy + 1, this.se);
        } else {
            this.nw = this.getPixel(ix, iy, this.nw);
            this.ne = this.getPixel(ix + 1, iy, this.ne);
            this.sw = this.getPixel(ix, iy + 1, this.sw);
            this.se = this.getPixel(ix + 1, iy + 1, this.se);
        }
        float wx = x - (float)ix;
        float wy = y - (float)iy;
        float cx = 1.0f - wx;
        float cy = 1.0f - wy;
        float m0 = cx * (float)this.nw[3] + wx * (float)this.ne[3];
        float m1 = cx * (float)this.sw[3] + wx * (float)this.se[3];
        int a = (int)(cy * m0 + wy * m1);
        m0 = cx * (float)this.nw[0] + wx * (float)this.ne[0];
        m1 = cx * (float)this.sw[0] + wx * (float)this.se[0];
        int r = (int)(cy * m0 + wy * m1);
        m0 = cx * (float)this.nw[1] + wx * (float)this.ne[1];
        m1 = cx * (float)this.sw[1] + wx * (float)this.se[1];
        int g = (int)(cy * m0 + wy * m1);
        m0 = cx * (float)this.nw[2] + wx * (float)this.ne[2];
        m1 = cx * (float)this.sw[2] + wx * (float)this.se[2];
        int b = (int)(cy * m0 + wy * m1);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private final int[] getPixel(int x, int y, int[] pixel) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            switch (this.edgeAction) {
                default: {
                    pixel[3] = 0;
                    pixel[2] = 0;
                    pixel[1] = 0;
                    pixel[0] = 0;
                    return pixel;
                }
                case 2: {
                    return this.raster.getPixel(ImageMath.mod(x, this.width), ImageMath.mod(y, this.height), pixel);
                }
                case 1: 
            }
            return this.raster.getPixel(ImageMath.clamp(x, 0, this.width - 1), ImageMath.clamp(y, 0, this.height - 1), pixel);
        }
        return this.raster.getPixel(x, y, pixel);
    }
}

