/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.SmearFilter;
import com.jhlabs.swing.SliderFactory;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SmearFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener,
ItemListener {
    private JSlider angle;
    private JSlider angleScatter;
    private JSlider density;
    private JSlider size;
    private JSlider mix;
    private JComboBox shape;
    private JCheckBox background;
    private SmearFilter filter;

    public SmearFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        SuperGridLayout sgl = new SuperGridLayout(3, 2);
        p.setLayout(sgl);
        sgl.setColWeight(1, 1);
        p.add(new JLabel("Angle:", 4));
        this.angle = new JSlider(0, 0, 360, 0);
        p.add(this.angle);
        this.angle.setPaintTicks(true);
        this.angle.setMajorTickSpacing(360);
        this.angle.setMinorTickSpacing(30);
        this.angle.setPaintLabels(true);
        this.angle.addChangeListener(this);
        p.add(new JLabel("Scatter:", 4));
        this.angleScatter = new JSlider(0, 0, 100, 0);
        p.add(this.angleScatter);
        this.angleScatter.setPaintTicks(true);
        this.angleScatter.setMajorTickSpacing(50);
        this.angleScatter.setMinorTickSpacing(10);
        this.angleScatter.setPaintLabels(true);
        this.angleScatter.addChangeListener(this);
        p.add(new JLabel("Density:", 4));
        this.density = new JSlider(0, 0, 100, 0);
        p.add(this.density);
        this.density.setPaintTicks(true);
        this.density.setMajorTickSpacing(50);
        this.density.setMinorTickSpacing(10);
        this.density.setPaintLabels(true);
        this.density.addChangeListener(this);
        p.add(new JLabel("Size:", 4));
        this.size = new JSlider(0, 0, 30, 0);
        p.add(this.size);
        this.size.setPaintTicks(true);
        this.size.setMajorTickSpacing(50);
        this.size.setMinorTickSpacing(10);
        this.size.setPaintLabels(true);
        this.size.addChangeListener(this);
        p.add(new JLabel("Mix:", 4));
        this.mix = SliderFactory.createPercentageSlider();
        p.add(this.mix);
        this.mix.addChangeListener(this);
        p.add(new JLabel("Shape:", 4));
        this.shape = new JComboBox();
        p.add(this.shape);
        this.shape.addItem("Crosses");
        this.shape.addItem("Lines");
        this.shape.addItem("Circles");
        this.shape.addItem("Squares");
        this.shape.addItemListener(this);
        this.background = new JCheckBox("White Background");
        p.add(this.background);
        this.background.addChangeListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        SmearFilter filter = (SmearFilter)o;
        this.filter = null;
        this.angle.setValue((int)((double)(filter.getAngle() * 180.0f) / Math.PI));
        this.angleScatter.setValue((int)((double)filter.getScatter() * 100.0));
        this.density.setValue((int)((double)filter.getDensity() * 100.0));
        this.size.setValue(filter.getDistance());
        this.mix.setValue((int)((double)filter.getMix() * 100.0));
        this.shape.setSelectedIndex(filter.getShape());
        this.background.setSelected(filter.getBackground());
        this.filter = filter;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.density) {
                this.filter.setDensity((float)this.density.getValue() / 100.0f);
            } else if (source == this.angleScatter) {
                this.filter.setScatter((float)this.angleScatter.getValue() / 100.0f);
            } else if (source == this.angle) {
                this.filter.setAngle((float)this.angle.getValue() * (float)Math.PI / 180.0f);
            } else if (source == this.size) {
                this.filter.setDistance(this.size.getValue());
            } else if (source == this.mix) {
                this.filter.setMix((float)this.mix.getValue() / 100.0f);
            } else if (source == this.background) {
                this.filter.setBackground(this.background.isSelected());
            }
            this.preview();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (this.filter != null) {
            if (source == this.shape) {
                this.filter.setShape(this.shape.getSelectedIndex());
            }
            this.preview();
        }
    }
}

