/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.image.ColormapWell;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.image.TextureFilter;
import com.jhlabs.swing.SliderFactory;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextureFilterCustomizer
extends PreviewFilterCustomizer
implements ChangeListener {
    private JSlider scale;
    private JSlider stretch;
    private JSlider angle;
    private JSlider amount;
    private JSlider turbulence;
    private JSlider gain;
    private JSlider bias;
    private JCheckBox useImageColors;
    private ColormapWell colormapWell;
    private TextureFilter filter;

    public TextureFilterCustomizer() {
        JPanel p = new JPanel();
        this.add((Component)p, "South");
        p.setLayout(new ParagraphLayout());
        p.add((Component)new JLabel("Scale:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.scale = new JSlider(0, 1, 256, 32);
        p.add(this.scale);
        this.scale.setPaintTicks(true);
        this.scale.setMajorTickSpacing(64);
        this.scale.setMinorTickSpacing(8);
        this.scale.setPaintLabels(true);
        this.scale.addChangeListener(this);
        p.add((Component)new JLabel("Stretch:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.stretch = new JSlider(0, 1, 100, 1);
        p.add(this.stretch);
        this.stretch.setPaintTicks(true);
        this.stretch.setMajorTickSpacing(50);
        this.stretch.setMinorTickSpacing(10);
        this.stretch.setPaintLabels(true);
        this.stretch.addChangeListener(this);
        p.add((Component)new JLabel("Angle:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.angle = new JSlider(0, 0, 360, 0);
        p.add(this.angle);
        this.angle.setPaintTicks(true);
        this.angle.setMajorTickSpacing(360);
        this.angle.setMinorTickSpacing(30);
        this.angle.setPaintLabels(true);
        this.angle.addChangeListener(this);
        p.add((Component)new JLabel("Amount (%):", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.amount = SliderFactory.createPercentageSlider();
        p.add(this.amount);
        this.amount.addChangeListener(this);
        p.add((Component)new JLabel("Turbulence:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.turbulence = new JSlider(0, 0, 100, 0);
        p.add(this.turbulence);
        this.turbulence.setPaintTicks(true);
        this.turbulence.setMajorTickSpacing(100);
        this.turbulence.setMinorTickSpacing(20);
        this.turbulence.setPaintLabels(true);
        this.turbulence.addChangeListener(this);
        p.add((Component)new JLabel("Gain:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.gain = SliderFactory.createPercentageSlider();
        p.add(this.gain);
        this.gain.addChangeListener(this);
        p.add((Component)new JLabel("Bias:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.bias = SliderFactory.createPercentageSlider();
        p.add(this.bias);
        this.bias.addChangeListener(this);
        p.add((Component)new JLabel("Gradient:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.colormapWell = new ColormapWell();
        p.add(this.colormapWell);
        this.colormapWell.addChangeListener(this);
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (TextureFilter)o;
        this.scale.setValue((int)this.filter.getScale());
        this.stretch.setValue((int)this.filter.getStretch() * 10);
        this.angle.setValue((int)((double)(this.filter.getAngle() * 180.0f) / Math.PI));
        this.amount.setValue((int)((double)this.filter.amount * 100.0));
        this.turbulence.setValue((int)(((double)this.filter.getTurbulence() - 1.0) * 100.0 / 8.0));
        this.gain.setValue((int)((double)this.filter.gain * 100.0));
        this.bias.setValue((int)((double)this.filter.bias * 100.0));
        this.colormapWell.setColormap(this.filter.getColormap());
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source == this.scale) {
                this.filter.setScale(this.scale.getValue());
            } else if (source == this.stretch) {
                this.filter.setStretch(this.stretch.getValue() / 10);
            } else if (source == this.angle) {
                this.filter.setAngle((float)this.angle.getValue() * (float)Math.PI / 180.0f);
            } else if (source == this.amount) {
                this.filter.amount = (float)this.amount.getValue() / 100.0f;
            } else if (source == this.turbulence) {
                this.filter.setTurbulence(1.0f + (float)this.turbulence.getValue() / 9.0f);
            } else if (source == this.gain) {
                this.filter.gain = (float)this.gain.getValue() / 100.0f;
            } else if (source == this.bias) {
                this.filter.bias = (float)this.bias.getValue() / 100.0f;
            } else if (source == this.colormapWell) {
                this.filter.setColormap(this.colormapWell.getColormap());
            }
            this.preview();
        }
    }
}

