/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.dng;

import it.tidalwave.imageio.dng.DNGImageReader;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;

public class DNGImageReaderSpi
extends RAWImageReaderSpiSupport {
    public DNGImageReaderSpi() {
        super("DNG", "dng", "image/x-adobe-dng", DNGImageReader.class);
    }

    public String getDescription(Locale locale) {
        return "Standard DNG Image Reader";
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new DNGImageReader(this, extension);
    }

    public boolean canDecodeInput(RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        long ifdOffset = TIFFImageReaderSupport.processHeader(iis, null);
        IFD primaryIFD = new IFD();
        primaryIFD.load(iis, ifdOffset);
        return primaryIFD.isDNGVersionAvailable();
    }
}

