/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;
import java.awt.RenderingHints;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorConvertOp;
import javax.annotation.Nonnull;

public class ColorProfileOperation
extends OperationSupport {
    private static final Logger logger = ColorProfileOperation.getLogger(ColorProfileOperation.class);

    public ColorProfileOperation() {
        super(Source.Type.RAW);
    }

    public void process(@Nonnull PipelineArtifact artifact) {
        logger.fine("process()", new Object[0]);
        ColorProfileOperation.logImage(logger, ">>>> image: ", artifact.getImage());
        ICC_Profile colorProfile = ICC_Profile.getInstance(1000);
        RenderingHints hints = null;
        ColorConvertOp ccOp = new ColorConvertOp(new ICC_Profile[]{colorProfile}, hints);
        artifact.setImage(ccOp.filter(artifact.getImage(), null));
        ColorProfileOperation.logImage(logger, ">>>> process returning: ", artifact.getImage());
    }
}

