/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.QTAppException;
import quicktime.app.RecordMovieCallback;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.image.CSequence;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.CompressedFrameInfo;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.QTImage;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.QTHandle;
import quicktime.util.RawEncodedImage;

public class RecordMovie {
    private QTHandle imageHandle;
    private RawEncodedImage compressedImage;
    private VideoMedia vidMedia;
    private int recordFrames;
    private int currentRecordFrame;
    private CSequence seq;
    private ImageDescription recDesc;
    private Track vidTrack;
    private RecordMovieCallback cb;
    private boolean doAsync;
    private Movie mov;
    private Thread cbThread;
    private boolean inPreflightMode = false;
    private boolean recording = false;
    private QDGraphics gw;
    private QDRect gwRect;
    private int scale;
    private int spatialQuality;
    private int temporalQuality;
    private int keyFrameRate;
    private int codecType;
    private CodecComponent codec;

    public RecordMovie() throws QTException {
        this(null, null, null);
    }

    public RecordMovie(Movie movie, RecordMovieCallback recordMovieCallback) throws QTException {
        this(movie, recordMovieCallback, null);
    }

    public RecordMovie(Movie movie, RecordMovieCallback recordMovieCallback, QDRect qDRect) throws QTException {
        this.gwRect = qDRect;
        this.setMovie(movie, recordMovieCallback);
    }

    public void setMovie(Movie movie, RecordMovieCallback recordMovieCallback) throws QTException {
        if (this.recording) {
            throw new QTAppException("Can't reset movie whilst recording");
        }
        this.mov = movie;
        this.cb = recordMovieCallback;
        if (this.cb != null) {
            this.cbThread = new Thread(new Runnable(){

                public void run() {
                    if (RecordMovie.this.cb != null) {
                        RecordMovie.this.cb.finish(RecordMovie.this.mov);
                    }
                }
            });
        }
    }

    public void setCompressionSettings(int n, int n2, int n3, int n4, int n5, CodecComponent codecComponent) throws QTException {
        this.scale = n;
        this.spatialQuality = n2;
        this.temporalQuality = n3;
        this.keyFrameRate = n4;
        this.codecType = n5;
        this.codec = codecComponent;
    }

    public void addedToSource(QDGraphics qDGraphics) throws QTException {
        if (this.recording) {
            throw new QTAppException("Can't reset parameters once recording has begun");
        }
        if (!(this.inPreflightMode || this.mov != null && this.cb != null)) {
            throw new QTAppException("Must specify a movie and the callback class before recording");
        }
        if (this.codec == null) {
            throw new QTAppException("Must set compression settings before record or preflight can be done");
        }
        if (this.gwRect == null) {
            this.gwRect = qDGraphics.getPortRect();
        }
        this.gw = qDGraphics;
        if (this.vidTrack == null && !this.inPreflightMode) {
            this.addNewTrack();
        }
        this.seq = new CSequence(this.gw, this.gwRect, this.gw.getPixMap().getPixelSize(), this.codecType, this.codec, this.spatialQuality, this.temporalQuality, this.keyFrameRate, null, 0);
        this.recDesc = this.seq.getDescription();
        int n = QTImage.getMaxCompressionSize(this.gw, this.gwRect, this.gw.getPixMap().getPixelSize(), this.spatialQuality, this.codecType, this.codec);
        this.imageHandle = new QTHandle(n, true);
        this.imageHandle.lock();
        this.compressedImage = RawEncodedImage.fromQTHandle(this.imageHandle);
        if (!this.inPreflightMode) {
            this.vidMedia.beginEdits();
        }
        this.recording = !this.inPreflightMode;
    }

    public synchronized void setPreflighting(boolean bl) throws QTException {
        if (this.recording) {
            throw new QTAppException("Can't set preflighting whilst recording");
        }
        this.inPreflightMode = bl;
    }

    public boolean isPreflighting() {
        return this.inPreflightMode;
    }

    public synchronized void recordMode(int n) throws QTException {
        if (this.mov == null) {
            throw new QTAppException("Can't go to record mode without first specifying a movie");
        }
        this.currentRecordFrame = 1;
        this.inPreflightMode = false;
        this.recordFrames = n;
    }

    public void abortRecording() throws QTException {
        if (this.recording) {
            this.vidMedia.endEdits();
            this.cleanup();
            this.recording = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean frameReady() throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            RecordMovie recordMovie = this;
            synchronized (recordMovie) {
                if (this.inPreflightMode) {
                    CompressedFrameInfo compressedFrameInfo = this.seq.compressFrame(this.gw, this.gwRect, 4, this.compressedImage);
                    return true;
                }
                if (this.recording && this.currentRecordFrame++ <= this.recordFrames) {
                    CompressedFrameInfo compressedFrameInfo = this.seq.compressFrame(this.gw, this.gwRect, 4, this.compressedImage);
                    boolean bl = compressedFrameInfo.getSimilarity() == 0;
                    this.vidMedia.addSample(this.imageHandle, 0, compressedFrameInfo.getDataSize(), 600 / this.scale, this.recDesc, 1, bl ? 0 : 1);
                    if (this.currentRecordFrame > this.recordFrames) {
                        this.cleanupMovie();
                        this.recording = false;
                        this.cbThread.start();
                        return false;
                    }
                    return true;
                }
            }
        }
        this.cleanup();
        return false;
    }

    private void cleanupMovie() throws QTException {
        this.vidMedia.endEdits();
        this.vidTrack.insertMedia(0, 0, this.vidMedia.getDuration(), 1.0f);
        this.cleanup();
    }

    private void cleanup() {
        this.vidTrack = null;
        this.vidMedia = null;
        this.compressedImage = null;
        this.imageHandle = null;
        this.gw = null;
    }

    private void addNewTrack() throws QTException {
        if (this.mov == null) {
            throw new QTAppException("Can't add a Track without movie being specified");
        }
        if (this.vidTrack != null) {
            throw new QTAppException("Can't alter movie while current movie is being recorded");
        }
        this.vidTrack = this.mov.addTrack(this.gwRect.getWidth(), this.gwRect.getHeight(), 0.0f);
        this.vidMedia = new VideoMedia(this.vidTrack, 600);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

