/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDisplaySpace;
import quicktime.app.image.Transformable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.std.image.Matrix;

public abstract class TransformMatrix {
    protected static final int kLeftSide = 1;
    protected static final int kRightSide = 16;
    protected static final int kTopSide = 256;
    protected static final int kBottomSide = 4096;
    public static final int kNoConstraint = 0;
    public static final int kConstrainWithinLeft = 1;
    public static final int kConstrainWithinRight = 16;
    public static final int kConstrainWithinTop = 256;
    public static final int kConstrainWithinBottom = 4096;
    public static final int kConstrainWithinHorizontal = 17;
    public static final int kConstrainWithinVertical = 4352;
    public static final int kConstrainWithinAll = 4369;
    public static final int kConstraintSpecifiedLeft = 65536;
    public static final int kConstraintSpecifiedRight = 0x100000;
    public static final int kConstraintSpecifiedTop = 0x1000000;
    public static final int kConstraintSpecifiedBottom = 0x10000000;
    public static final int kConstraintSpecifiedHorizontal = 0x110000;
    public static final int kConstraintSpecifiedVertical = 0x11000000;
    public static final int kConstraintSpecifiedAll = 0x11110000;
    private int constrained = 0;
    protected Transformable target;
    public int specifiedRightConstraint = 1;
    public int specifiedLeftConstraint = 1;
    public int specifiedTopConstraint = 1;
    public int specifiedBottomConstraint = 1;
    private QDPoint[] origPt;
    private QDRect spaceRect;
    private Matrix invSpaceMatrix;
    private Matrix origTargetMatrix;
    private QDPoint[] newPt = new QDPoint[1];
    private QDRect transformMatrixRect = new QDRect();
    private Matrix deltaMatrix;
    private int setXLeft;
    private int setXRight;
    private int setYTop;
    private int setYBottom;

    protected TransformMatrix() {
        this.newPt[0] = new QDPoint(0, 0);
    }

    public String toString() {
        return this.getClass().getName() + "[target=" + this.target + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        if (object instanceof TransformMatrix) {
            TransformMatrix transformMatrix = (TransformMatrix)object;
            if (this.target != null) {
                return this.target.equals(transformMatrix.target);
            }
        }
        return false;
    }

    public Transformable getTarget() {
        return this.target;
    }

    public void setConstraint(int n) {
        this.constrained = n;
    }

    public int getConstraint() {
        return this.constrained;
    }

    public void initialize(QTDisplaySpace qTDisplaySpace, Transformable transformable) throws QTException {
        this.target = transformable;
        QDRect qDRect = qTDisplaySpace.getDisplayBounds();
        Matrix matrix = qTDisplaySpace.getMatrix();
        this.invSpaceMatrix = new Matrix();
        Matrix matrix2 = matrix.copy();
        matrix2.setTx(0.0f);
        matrix2.setTy(0.0f);
        matrix2.inverse(this.invSpaceMatrix);
        this.origPt = new QDPoint[1];
        this.origPt[0] = new QDPoint(0, 0);
        this.origTargetMatrix = this.target.getMatrix();
        this.spaceRect = qDRect.copy();
        this.spaceRect.setX(0);
        this.spaceRect.setY(0);
        this.invSpaceMatrix.transformRect(this.spaceRect);
    }

    public void initialize(QTDisplaySpace qTDisplaySpace, Transformable transformable, int n, int n2) throws QTException {
        this.target = transformable;
        QDRect qDRect = qTDisplaySpace.getDisplayBounds();
        Matrix matrix = qTDisplaySpace.getMatrix();
        this.invSpaceMatrix = new Matrix();
        Matrix matrix2 = matrix.copy();
        matrix2.setTx(0.0f);
        matrix2.setTy(0.0f);
        matrix2.inverse(this.invSpaceMatrix);
        this.origPt = new QDPoint[1];
        this.origPt[0] = new QDPoint(n, n2);
        this.invSpaceMatrix.transformPoints(this.origPt);
        this.origTargetMatrix = this.target.getMatrix();
        this.spaceRect = qDRect.copy();
        this.spaceRect.setX(0);
        this.spaceRect.setY(0);
        this.invSpaceMatrix.transformRect(this.spaceRect);
    }

    public boolean transformTarget() throws QTException {
        this.deltaMatrix = this.target.getMatrix().copy();
        this.doTransformation(this.deltaMatrix);
        return this.completeTransformation();
    }

    public boolean transformTarget(int n, int n2) throws QTException {
        this.newPt[0].setX(n);
        this.newPt[0].setY(n2);
        this.invSpaceMatrix.transformPoints(this.newPt);
        int n3 = this.newPt[0].getX() - this.origPt[0].getX();
        int n4 = this.newPt[0].getY() - this.origPt[0].getY();
        this.deltaMatrix = this.origTargetMatrix.copy();
        this.doTransformation(this.deltaMatrix, n3, n4);
        return this.completeTransformation();
    }

    public void flipTransformationSettings() {
    }

    protected abstract void doTransformation(Matrix var1, int var2, int var3) throws QTException;

    protected abstract void doTransformation(Matrix var1) throws QTException;

    protected void boundsReached(int n) {
    }

    private boolean completeTransformation() throws QTException {
        boolean bl = false;
        if (this.constrained != 0) {
            QDDimension qDDimension = this.target.getOriginalSize();
            int n = qDDimension.getWidth();
            int n2 = qDDimension.getHeight();
            float f = this.deltaMatrix.getTx();
            float f2 = this.deltaMatrix.getTy();
            this.setXLeft = this.spaceRect.getX();
            this.setXRight = this.spaceRect.getWidth() - n;
            this.setYTop = this.spaceRect.getY();
            this.setYBottom = this.spaceRect.getHeight() - n2;
            short s = this.deltaMatrix.getType();
            switch (s) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    this.transformMatrixRect.setWidth(n);
                    this.transformMatrixRect.setHeight(n2);
                    this.transformMatrixRect.setX(0);
                    this.transformMatrixRect.setY(0);
                    this.deltaMatrix.transformRect(this.transformMatrixRect);
                    n = this.transformMatrixRect.getWidth();
                    n2 = this.transformMatrixRect.getHeight();
                    this.setXLeft = (int)(this.deltaMatrix.getTx() - (float)this.transformMatrixRect.getX() + 0.5f);
                    f -= (float)this.setXLeft;
                    this.setYTop = (int)(this.deltaMatrix.getTy() - (float)this.transformMatrixRect.getY() + 0.5f);
                    f2 -= (float)this.setYTop;
                    this.setYBottom = this.spaceRect.getHeight() - n2 + this.setYTop;
                    this.setXRight = this.spaceRect.getWidth() - n2 + this.setXLeft;
                }
            }
            bl = this.doConstraintsTesting(f, f2, n, n2);
        }
        this.target.setMatrix(this.deltaMatrix);
        return bl;
    }

    private boolean doConstraintsTesting(float f, float f2, int n, int n2) {
        boolean bl = false;
        if (f < (float)this.spaceRect.getX()) {
            if ((this.constrained & 1) != 0) {
                this.deltaMatrix.setTx(this.setXLeft);
                this.boundsReached(1);
                bl = true;
            } else if ((this.constrained & 0x10000) != 0 && f <= (float)(-n)) {
                this.deltaMatrix.setTx(-n + this.specifiedLeftConstraint + this.setXLeft);
                this.boundsReached(1);
                bl = true;
            }
        } else if (f + (float)n > (float)this.spaceRect.getWidth()) {
            if ((this.constrained & 0x10) != 0) {
                this.deltaMatrix.setTx(this.setXRight);
                this.boundsReached(16);
                bl = true;
            } else if ((this.constrained & 0x100000) != 0 && f >= (float)this.spaceRect.getWidth()) {
                this.deltaMatrix.setTx(this.setXRight + n - this.specifiedRightConstraint);
                this.boundsReached(16);
                bl = true;
            }
        }
        if (f2 < (float)this.spaceRect.getY()) {
            if ((this.constrained & 0x100) != 0) {
                this.deltaMatrix.setTy(this.setYTop);
                this.boundsReached(256);
                bl = true;
            } else if ((this.constrained & 0x1000000) != 0 && f2 <= (float)(-n2)) {
                this.deltaMatrix.setTy(-n2 + this.specifiedTopConstraint + this.setYTop);
                this.boundsReached(256);
                bl = true;
            }
        } else if (f2 + (float)n2 > (float)this.spaceRect.getHeight()) {
            if ((this.constrained & 0x1000) != 0) {
                this.deltaMatrix.setTy(this.setYBottom);
                this.boundsReached(4096);
                bl = true;
            } else if ((this.constrained & 0x10000000) != 0 && f2 >= (float)this.spaceRect.getHeight()) {
                this.deltaMatrix.setTy(this.setYBottom + n2 - this.specifiedBottomConstraint);
                this.boundsReached(4096);
                bl = true;
            }
        }
        return bl;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

