/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.anim;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.QTAppException;
import quicktime.app.actions.Notifier;
import quicktime.app.actions.NotifyListener;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.SpriteInvalidException;
import quicktime.app.anim.TwoDSpriteInfo;
import quicktime.app.display.Layerable;
import quicktime.app.image.Compositable;
import quicktime.app.image.ImageDataSequence;
import quicktime.app.image.ImageSettable;
import quicktime.app.image.ImageSpec;
import quicktime.app.image.Transformable;
import quicktime.app.time.Timer;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.std.anim.Sprite;
import quicktime.std.anim.SpriteWorld;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.util.EncodedImage;
import quicktime.util.RawEncodedImage;

public class TwoDSprite
implements NotifyListener,
Transformable,
Layerable,
ImageSettable,
Compositable {
    private static EncodedImage ei;
    private static ImageDescription id;
    private transient Sprite sprite;
    private TwoDSpriteInfo info;
    private transient ImageSpec is;
    transient SWCompositor spriteIsCompositor;
    private transient SWCompositor parentCompositor;
    private transient Timer parentsTimer;
    protected String label;

    private static EncodedImage getDummyEI() throws QTException {
        if (ei == null) {
            ei = new RawEncodedImage(4, true);
        }
        return ei;
    }

    private static ImageDescription getDummyID() throws QTException {
        if (id == null) {
            if (QTSession.isCurrentOS(2)) {
                id = new ImageDescription(32);
                id.setDepth(0);
            } else {
                id = new ImageDescription(1918990112);
                id.setDepth(32);
            }
            id.setSpatialQuality(512);
            id.setWidth(1);
            id.setHeight(1);
            id.setHRes(72.0f);
            id.setVRes(72.0f);
            id.setDataSize(4);
            id.setFrameCount(1);
            id.setClutID(-1);
        }
        return id;
    }

    public TwoDSprite(TwoDSpriteInfo twoDSpriteInfo) throws QTException {
        this.info = twoDSpriteInfo;
    }

    public TwoDSprite() throws QTException {
        this(new Matrix(), 1, null);
    }

    public TwoDSprite(Matrix matrix, int n, GraphicsMode graphicsMode) throws QTException {
        this.info = new TwoDSpriteInfo(TwoDSprite.getDummyEI(), TwoDSprite.getDummyID(), matrix, false, n, graphicsMode);
    }

    public TwoDSprite(ImageSpec imageSpec, Matrix matrix, boolean bl, int n) throws QTException {
        this.info = new TwoDSpriteInfo(imageSpec.getImage(), imageSpec.getDescription(), matrix, bl, n);
    }

    public TwoDSprite(ImageSpec imageSpec, Matrix matrix, boolean bl, int n, GraphicsMode graphicsMode) throws QTException {
        this.info = new TwoDSpriteInfo(imageSpec.getImage(), imageSpec.getDescription(), matrix, bl, n, graphicsMode);
    }

    public TwoDSprite(ImageDataSequence imageDataSequence, int n, Matrix matrix, boolean bl, int n2) throws QTException {
        this.info = new TwoDSpriteInfo(imageDataSequence.getImage(n), imageDataSequence.getDescription(), matrix, bl, n2);
    }

    public TwoDSprite(ImageDataSequence imageDataSequence, int n, Matrix matrix, boolean bl, int n2, GraphicsMode graphicsMode) throws QTException {
        this.info = new TwoDSpriteInfo(imageDataSequence.getImage(n), imageDataSequence.getDescription(), matrix, bl, n2, graphicsMode);
    }

    TwoDSprite(Sprite sprite) throws QTException {
        this.sprite = sprite;
        this.info = new TwoDSpriteInfo(this.sprite.getImageData(), this.sprite.getImageDescription(), this.sprite.getMatrix(), this.sprite.getVisible(), this.sprite.getLayer());
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean setNotifier(Notifier notifier) {
        if (notifier instanceof ImageSpec) {
            this.is = (ImageSpec)((Object)notifier);
            return true;
        }
        this.is = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyComplete() {
        if (this.is == null) {
            return;
        }
        try {
            ImageSpec imageSpec = this.is;
            synchronized (imageSpec) {
                this.setImageData(this.is.getImage(), this.is.getDescription());
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "setImageData");
        }
    }

    public void setImageData(EncodedImage encodedImage, ImageDescription imageDescription) throws QTException {
        encodedImage = encodedImage == null ? TwoDSprite.getDummyEI() : encodedImage;
        this.info.desc = imageDescription = imageDescription == null ? TwoDSprite.getDummyID() : imageDescription;
        if (this.sprite != null) {
            this.sprite.setImageDescription(imageDescription);
            if (encodedImage != TwoDSprite.getDummyEI() && this.info.image == TwoDSprite.getDummyEI()) {
                this.sprite.setGraphicsMode(this.info.graphicsMode);
                this.sprite.setVisible(true);
            }
            this.setImage(encodedImage);
        } else {
            this.setImage(encodedImage);
        }
    }

    public void setImage(EncodedImage encodedImage) throws QTException {
        EncodedImage encodedImage2 = encodedImage = encodedImage != null ? encodedImage : TwoDSprite.getDummyEI();
        if (this.sprite != null) {
            boolean bl = this.sprite.setImageDataIfDifferent(encodedImage);
            if (encodedImage == TwoDSprite.getDummyEI()) {
                this.sprite.setVisible(false);
            }
            if (bl) {
                this.doParentRedraw(true);
            }
        }
        this.info.image = encodedImage;
    }

    private final void doParentRedraw(boolean bl) throws QTException {
        if (bl && this.parentsTimer != null && !this.parentsTimer.isTicking() && this.parentCompositor != null && this.parentCompositor.isAutoRedrawing()) {
            this.parentCompositor.idle();
        }
    }

    public SWCompositor getParent() {
        return this.parentCompositor;
    }

    void setParent(SWCompositor sWCompositor) {
        this.parentCompositor = sWCompositor;
        this.parentsTimer = sWCompositor != null ? sWCompositor.getTimer() : null;
    }

    Sprite getSprite() {
        return this.sprite;
    }

    public boolean isValid() {
        return this.sprite != null;
    }

    public void remove() throws QTException {
        if (this.sprite != null) {
            boolean bl = this.getVisible();
            this.sprite.remove();
            this.doParentRedraw(bl);
            this.sprite = null;
        }
    }

    public TwoDSpriteInfo getSpriteInfo() throws QTException {
        return this.info;
    }

    protected void removeNotify() throws QTException {
        if (this.spriteIsCompositor != null) {
            this.spriteIsCompositor.setGWorld(QDGraphics.scratch);
        }
        this.sprite = null;
    }

    public void createSprite(SpriteWorld spriteWorld) throws QTException {
        if (this.sprite != null) {
            this.sprite.remove();
        }
        if (this.info == null) {
            throw new QTAppException("Can't create sprite with no information");
        }
        if (this.info.image == null || this.info.desc == null) {
            this.info.image = TwoDSprite.getDummyEI();
            this.info.desc = TwoDSprite.getDummyID();
        }
        if (this.info.image == TwoDSprite.getDummyEI() || this.info.desc == TwoDSprite.getDummyID()) {
            this.info.visible = false;
        }
        this.sprite = new Sprite(spriteWorld, this.info.desc, this.info.image, this.info.matrix, this.info.visible, this.info.layer);
        this.sprite.setGraphicsMode(this.info.graphicsMode);
        if (this.spriteIsCompositor != null) {
            this.spriteIsCompositor.setGWorld(QDGraphics.validScratch);
        }
        this.doParentRedraw(this.getVisible());
    }

    public Matrix getMatrix() throws QTException {
        if (this.sprite != null) {
            return this.sprite.getMatrix();
        }
        return this.info.matrix;
    }

    public void setMatrix(Matrix matrix) throws QTException {
        if (this.sprite != null) {
            this.sprite.setMatrix(matrix);
        }
        this.info.matrix = matrix;
        if (this.spriteIsCompositor != null) {
            this.spriteIsCompositor.setMatrix(matrix);
        }
        if (this.sprite != null) {
            this.doParentRedraw(this.getVisible());
        }
    }

    public Dimension getInitialSize() throws QTException {
        return new Dimension(this.info.desc.getWidth(), this.info.desc.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        return new QDDimension(this.info.desc.getWidth(), this.info.desc.getHeight());
    }

    public final void invalidate() throws QTException {
        if (this.sprite == null) {
            QTRuntimeException.handleOrThrow(new SpriteInvalidException(this.toString()), this, "invalidate");
            return;
        }
        this.sprite.invalidate();
        if (!(this.info.image instanceof RawEncodedImage)) {
            this.sprite.setImageData(this.info.image);
        }
        this.doParentRedraw(this.getVisible());
    }

    public boolean hitTest(int n, QDPoint qDPoint) throws QTException {
        if (this.sprite == null) {
            QTRuntimeException.handleOrThrow(new SpriteInvalidException(this.toString()), this, "hitTest");
            return false;
        }
        return this.sprite.hitTest(n, qDPoint);
    }

    public ImageDescription getDescription() throws QTException {
        if (this.sprite != null) {
            return this.sprite.getImageDescription();
        }
        return this.info.desc;
    }

    public void setDescription(ImageDescription imageDescription) throws QTException {
        if (this.sprite != null) {
            this.sprite.setImageDescription(imageDescription);
        }
        this.info.desc = imageDescription;
    }

    public EncodedImage getImage() throws QTException {
        if (this.sprite != null) {
            return this.sprite.getImageData();
        }
        return this.info.image;
    }

    public boolean getVisible() throws QTException {
        if (this.sprite != null) {
            return this.sprite.getVisible();
        }
        return this.info.visible;
    }

    public void setVisible(boolean bl) throws QTException {
        if (this.sprite != null) {
            this.sprite.setVisible(bl);
            this.doParentRedraw(bl);
        }
        this.info.visible = bl;
    }

    public int getLayer() throws QTException {
        if (this.sprite != null) {
            return this.sprite.getLayer();
        }
        return this.info.layer;
    }

    public void setLayer(int n) throws QTException {
        if (this.sprite != null) {
            this.sprite.setLayer(n);
            this.doParentRedraw(this.getVisible());
        }
        this.info.layer = n;
    }

    public GraphicsMode getGraphicsMode() throws QTException {
        if (this.sprite != null) {
            return this.sprite.getGraphicsMode();
        }
        return this.info.graphicsMode;
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        if (this.sprite != null) {
            this.sprite.setGraphicsMode(graphicsMode);
            this.doParentRedraw(this.getVisible());
        }
        this.info.graphicsMode = graphicsMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TwoDSprite) {
            TwoDSprite twoDSprite = (TwoDSprite)object;
            if (twoDSprite.sprite == null) {
                return false;
            }
            return twoDSprite.sprite.equals(this.sprite);
        }
        return false;
    }

    public String toString() {
        try {
            String string = "";
            if (this.label != null) {
                string = "label=" + this.label;
            }
            return this.getClass().getName() + "[" + string + "sprite= " + this.sprite + ",matrix=" + this.getMatrix() + "]";
        }
        catch (QTException qTException) {
            return this.getClass().getName();
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        ei = null;
        id = null;
    }
}

