/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.ImagePresenter;
import quicktime.app.image.ImageSequencer;
import quicktime.app.image.ImageSettable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.util.EncodedImage;

public abstract class ImageViewer
implements QTDrawable,
ImageSettable {
    private ImageSequencer images;
    protected ImagePresenter imagePresenter;

    public ImageViewer(ImageSequencer imageSequencer) throws QTException {
        this.setImages(imageSequencer);
    }

    public ImageSequencer getImages() {
        return this.images;
    }

    public void setImageData(EncodedImage encodedImage, ImageDescription imageDescription) throws QTException, StdQTException {
        if (this.imagePresenter == null) {
            this.imagePresenter = new ImagePresenter(new QDRect(imageDescription.getWidth(), imageDescription.getHeight()));
        }
        this.imagePresenter.setImageData(encodedImage, imageDescription);
        this.imagePresenter.redraw(null);
    }

    public void setImages(ImageSequencer imageSequencer) throws QTException {
        this.images = imageSequencer;
        this.setImageData(imageSequencer.getImage(), imageSequencer.getDescription());
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.imagePresenter.setGWorld(qDGraphics);
    }

    public QDGraphics getGWorld() {
        return this.imagePresenter.getGWorld();
    }

    public void setDisplayBounds(QDRect qDRect) throws StdQTException {
        this.imagePresenter.setDisplayBounds(qDRect);
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() {
        return this.imagePresenter.getDisplayBounds();
    }

    public void setClip(Region region) throws QTException {
        this.imagePresenter.setClip(region);
    }

    public Region getClip() throws QTException {
        return this.imagePresenter.getClip();
    }

    public Dimension getInitialSize() throws QTException {
        return this.imagePresenter.getInitialSize();
    }

    public QDDimension getOriginalSize() throws QTException {
        return this.imagePresenter.getOriginalSize();
    }

    public Matrix getMatrix() throws StdQTException {
        return this.imagePresenter.getMatrix();
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.imagePresenter.setMatrix(matrix);
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        this.imagePresenter.setGraphicsMode(graphicsMode);
    }

    public GraphicsMode getGraphicsMode() {
        return this.imagePresenter.getGraphicsMode();
    }

    public final synchronized void redraw(Region region) throws QTException {
        this.imagePresenter.redraw(region);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

