/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Redrawable;
import quicktime.app.players.MoviePlayer;
import quicktime.app.players.QTPlayer;
import quicktime.app.spaces.Space;
import quicktime.app.time.Timeable;
import quicktime.jdirect.QTNative;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.util.RawEncodedImage;

public class QTImageProducer
implements ImageProducer,
Redrawable {
    private static final boolean debug = false;
    private static long msecs;
    private static final boolean profile = false;
    private Dimension size;
    private int rowInts;
    private QDGraphics gw;
    private PixMap pm;
    private int[] pixels;
    private QTDrawable qtSource;
    private ColorModel cm = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    private Hashtable props = new Hashtable();
    private Vector consumers = new Vector();
    private boolean doesRedraw;
    private boolean singleFrame;

    private static boolean requiresRedrawing(QTDrawable qTDrawable) {
        return qTDrawable instanceof Space || qTDrawable instanceof Timeable || qTDrawable instanceof Redrawable && !((Redrawable)((Object)qTDrawable)).isSingleFrame();
    }

    public QTImageProducer(QTDrawable qTDrawable, Dimension dimension) throws QTException {
        if (qTDrawable instanceof QTPlayer) {
            qTDrawable = new MoviePlayer(((QTPlayer)qTDrawable).getMovieController().getMovie());
        }
        this.qtSource = qTDrawable;
        this.setRedrawing(QTImageProducer.requiresRedrawing(qTDrawable));
        this.singleFrame = !this.isRedrawing();
        this.size = dimension;
        this.gw = new QDGraphics(new QDRect(this.size));
        qTDrawable.setDisplayBounds(new QDRect(this.size));
        qTDrawable.setGWorld(this.gw);
        this.pm = this.gw.getPixMap();
        this.rowInts = this.pm.getRowBytes() / 4;
        this.pixels = new int[this.rowInts * this.size.height];
        qTDrawable.redraw(null);
        this.copyPixels();
        if (this.isSingleFrame()) {
            this.gw.disposeQTObject();
            this.gw = null;
            this.pm = null;
            this.qtSource = null;
        }
    }

    public QDGraphics getGWorld() {
        return this.gw;
    }

    public boolean isSingleFrame() {
        return this.singleFrame;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block7: {
            if (this.isConsumer(imageConsumer)) {
                return;
            }
            try {
                this.consumers.addElement(imageConsumer);
                imageConsumer.setDimensions(this.size.width, this.size.height);
                if (!this.isConsumer(imageConsumer)) {
                    return;
                }
                imageConsumer.setProperties(this.props);
                if (!this.isConsumer(imageConsumer)) {
                    return;
                }
                imageConsumer.setColorModel(this.cm);
                if (this.isConsumer(imageConsumer)) {
                    int n = 14;
                    if (this.isSingleFrame()) {
                        n |= 0x10;
                    }
                    imageConsumer.setHints(n);
                }
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageConsumer)) break block7;
                imageConsumer.imageComplete(1);
            }
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProduction(ImageConsumer imageConsumer) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QTImageProducer qTImageProducer = this;
            synchronized (qTImageProducer) {
                block13: {
                    try {
                        this.addConsumer(imageConsumer);
                        if (!this.isConsumer(imageConsumer)) {
                            return;
                        }
                        imageConsumer.setPixels(0, 0, this.size.width, this.size.height, this.cm, this.pixels, 0, this.rowInts);
                        if (this.isConsumer(imageConsumer)) {
                            if (this.isSingleFrame()) {
                                imageConsumer.imageComplete(3);
                                if (this.isConsumer(imageConsumer)) {
                                    imageConsumer.imageComplete(1);
                                    this.removeConsumer(imageConsumer);
                                }
                            } else {
                                imageConsumer.imageComplete(2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!this.isConsumer(imageConsumer)) break block13;
                        imageConsumer.imageComplete(1);
                    }
                }
            }
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private synchronized void copyPixels() throws QTException {
        RawEncodedImage rawEncodedImage = this.pm.getPixelData();
        rawEncodedImage.copyToArray(0, this.pixels, 0, this.pixels.length);
    }

    public synchronized void redraw(Region region) throws QTException {
        if (this.consumers.isEmpty() && this.isSingleFrame()) {
            return;
        }
        this.qtSource.redraw(null);
        this.updateConsumers(region);
    }

    public synchronized void updateConsumers(Region region) throws QTException {
        int n;
        int n2;
        int n3;
        Object object;
        if (!this.isSingleFrame()) {
            this.copyPixels();
        }
        int n4 = 0;
        if (region != null) {
            object = region.getRgnBBox();
            n3 = ((QDRect)object).getX();
            n2 = ((QDRect)object).getY();
            n = ((QDRect)object).getWidth();
            n4 = ((QDRect)object).getHeight();
        } else {
            n3 = 0;
            n2 = 0;
            n = this.size.width;
            n4 = this.size.height;
        }
        object = this.consumers.elements();
        while (object.hasMoreElements()) {
            ImageConsumer imageConsumer = (ImageConsumer)object.nextElement();
            imageConsumer.setPixels(n3, n2, n, n4, this.cm, this.pixels, 0, this.rowInts);
            if (!this.isConsumer(imageConsumer)) continue;
            imageConsumer.imageComplete(2);
        }
    }

    public synchronized void setRedrawing(boolean bl) {
        this.doesRedraw = bl;
    }

    public boolean isRedrawing() {
        return this.doesRedraw;
    }

    public Dimension getSize() {
        return new Dimension(this.size);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        msecs = 0L;
    }
}

