/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.spaces;

import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.TickleList;
import quicktime.app.spaces.CollectionController;
import quicktime.app.spaces.Controller;
import quicktime.app.spaces.Listener;
import quicktime.app.spaces.ListenerController;
import quicktime.app.spaces.Protocol;
import quicktime.app.spaces.Space;
import quicktime.app.spaces.TicklishController;
import quicktime.app.spaces.TimeableController;
import quicktime.app.time.Timeable;
import quicktime.app.time.Timer;
import quicktime.std.clocks.TimeBase;

public abstract class SimpleSpace
implements Space {
    protected Vector controllersVec = new Vector();
    protected Vector containedSpaces = new Vector();
    protected TickleList ticklers = new TickleList();
    protected Timer timer;
    private Object listenerSource;
    private Protocol prots;

    protected SimpleSpace(Protocol protocol) throws QTException {
        this.prots = protocol;
    }

    protected SimpleSpace(Protocol protocol, int n, int n2) throws QTException {
        this.prots = protocol;
        this.timer = new Timer(n, n2, this);
    }

    public void timeChanged(int n) throws QTException {
        this.ticklers.timeChanged(n);
    }

    public boolean tickle(float f, int n) throws QTException {
        return !this.ticklers.isEmpty() ? this.ticklers.tickle(f, n) : false;
    }

    public Enumeration tickleList() {
        return this.ticklers.members();
    }

    public Object getSource() {
        return this.listenerSource;
    }

    public Protocol getProtocol() {
        return this.prots;
    }

    public boolean isAppropriate(Object object) {
        return this.getProtocol().passProtocol(object);
    }

    public synchronized boolean hasMember(Object object) {
        if (!this.isAppropriate(object)) {
            return false;
        }
        Enumeration enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(object)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addedTo(Object object) {
        if (this.listenerSource != null) {
            this.removedFrom(this.listenerSource);
        }
        this.listenerSource = object;
        if (this.listenerSource != null) {
            Object object2;
            Enumeration enumeration = this.containedSpaces.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Space)enumeration.nextElement();
                object2.addedTo(this.listenerSource);
            }
            enumeration = this.members();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (!(object2 instanceof Listener) || object2 instanceof Space) continue;
                ((Listener)object2).addedTo(this.listenerSource);
            }
            enumeration = this.controllers();
            while (enumeration.hasMoreElements()) {
                object2 = (Controller)enumeration.nextElement();
                if (!(object2 instanceof ListenerController)) continue;
                ((ListenerController)object2).addedTo(this.listenerSource);
            }
        }
    }

    public synchronized void removedFrom(Object object) {
        if (this.listenerSource != null) {
            Object object2;
            if (object != this.listenerSource) {
                QTRuntimeException.handleOrThrow(new QTRuntimeException(new QTRuntimeException("Remove from object Space has no interest in")), this, "removedFrom");
                return;
            }
            Enumeration enumeration = this.controllers();
            while (enumeration.hasMoreElements()) {
                object2 = (Controller)enumeration.nextElement();
                if (!(object2 instanceof ListenerController)) continue;
                ((ListenerController)object2).removedFrom(this.listenerSource);
            }
            enumeration = this.containedSpaces.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Space)enumeration.nextElement();
                object2.removedFrom(this.listenerSource);
            }
            enumeration = this.members();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (!(object2 instanceof Listener) || object2 instanceof Space) continue;
                ((Listener)object2).removedFrom(this.listenerSource);
            }
            this.listenerSource = null;
        }
    }

    public synchronized void addController(Controller controller) throws QTException {
        Object object;
        Object object2;
        if (controller == null) {
            return;
        }
        if (this.controllersVec.contains(controller)) {
            return;
        }
        controller.addedToSpace(this);
        this.controllersVec.addElement(controller);
        if (controller instanceof TimeableController) {
            object2 = ((Timeable)((Object)controller)).getTimeBase();
            object = this.timer.getTimeBase();
            ((TimeBase)object2).setMasterTimeBase((TimeBase)object, null);
        }
        if (controller instanceof ListenerController && this.listenerSource != null) {
            ((ListenerController)controller).addedTo(this.listenerSource);
        }
        if (controller instanceof CollectionController && (object2 = (CollectionController)controller).isWholespace()) {
            object = this.members();
            while (object.hasMoreElements()) {
                object2.addMember(object.nextElement());
            }
        }
        if (controller instanceof TicklishController) {
            this.ticklers.addMember(controller);
        }
    }

    public synchronized void removeController(Controller controller) throws QTException {
        Object object;
        if (controller == null) {
            return;
        }
        if (!this.controllersVec.contains(controller)) {
            return;
        }
        this.controllersVec.removeElement(controller);
        controller.removedFromSpace();
        if (controller instanceof TimeableController) {
            object = ((Timeable)((Object)controller)).getTimeBase();
            ((TimeBase)object).setMasterTimeBase(null, null);
        }
        if (controller instanceof ListenerController && this.listenerSource != null) {
            ((ListenerController)controller).removedFrom(this.listenerSource);
        }
        if (controller instanceof CollectionController) {
            object = (CollectionController)controller;
            Enumeration enumeration = this.members();
            while (enumeration.hasMoreElements()) {
                object.removeMember(enumeration.nextElement());
            }
        }
        if (controller instanceof TicklishController) {
            this.ticklers.removeMember(controller);
        }
    }

    public Enumeration controllers() {
        return this.controllersVec.elements();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public abstract boolean addMember(Object var1) throws QTException;

    public abstract void removeMember(Object var1) throws QTException;

    protected synchronized void memberAdded(Object object) throws QTException {
        Object object2;
        TimeBase timeBase;
        Object object3;
        if (object instanceof Space) {
            object3 = (Space)object;
            timeBase = object3.getTimer().getTimeBase();
            object2 = this.timer.getTimeBase();
            timeBase.setMasterTimeBase((TimeBase)object2, null);
            this.containedSpaces.addElement(object);
            if (this.listenerSource != null) {
                object3.addedTo(this.listenerSource);
            }
        } else {
            if (object instanceof Timeable) {
                object3 = ((Timeable)object).getTimeBase();
                timeBase = this.timer.getTimeBase();
                ((TimeBase)object3).setMasterTimeBase(timeBase, null);
            }
            if (object instanceof Listener && this.listenerSource != null) {
                ((Listener)object).addedTo(this.listenerSource);
            }
        }
        object3 = this.controllers();
        while (object3.hasMoreElements()) {
            timeBase = object3.nextElement();
            if (!(timeBase instanceof CollectionController) || !(object2 = (CollectionController)((Object)timeBase)).isWholespace()) continue;
            object2.addMember(object);
        }
    }

    protected synchronized void memberRemoved(Object object) throws QTException {
        TimeBase timeBase;
        Object object2;
        if (object instanceof Space) {
            object2 = (Space)object;
            timeBase = object2.getTimer().getTimeBase();
            timeBase.setMasterTimeBase(null, null);
            this.containedSpaces.removeElement(object);
            if (this.listenerSource != null) {
                object2.removedFrom(this.listenerSource);
            }
        } else {
            if (object instanceof Timeable) {
                object2 = ((Timeable)object).getTimeBase();
                ((TimeBase)object2).setMasterTimeBase(null, null);
            }
            if (object instanceof Listener && this.listenerSource != null) {
                ((Listener)object).removedFrom(this.listenerSource);
            }
        }
        object2 = this.controllers();
        while (object2.hasMoreElements()) {
            timeBase = object2.nextElement();
            if (!(timeBase instanceof CollectionController)) continue;
            ((CollectionController)((Object)timeBase)).removeMember(object);
        }
    }

    public synchronized void removeAllControllers() throws QTException {
        Enumeration enumeration = this.controllers();
        while (enumeration.hasMoreElements()) {
            this.removeController((Controller)enumeration.nextElement());
        }
    }

    public synchronized void removeAllMembers() throws QTException {
        Enumeration enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            this.removeMember(enumeration.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = QTSession.terminationLock();
        synchronized (object) {
            if (QTSession.isInitialized()) {
                this.removeAllControllers();
                this.removeAllMembers();
            }
        }
        super.finalize();
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

